<?php
	/**
	 * Augmit Social Widget
	 *
	 *
	 * @author 		basictheme
	 * @category 	Widgets
	 * @package 	Augmit/Widgets
	 * @version 	1.0.1
	 * @extends 	WP_Widget
	 */
	add_action('widgets_init', 'advkt_phone_widget');
	function advkt_phone_widget() {
		register_widget('advkt_phone_widget');
	}
	
	
	class Advkt_Phone_Widget  extends WP_Widget{
		
		public function __construct(){
			parent::__construct('advkt_phone_widget',esc_html__('Advkt Phone Widget','advkt-toolkit'),array(
				'description' => esc_html__('Phone Widget by Advkt','advkt-toolkit'),
			));
		}
		
		public function widget($args,$instance){
			extract($args);
			extract($instance);
		 	print $before_widget; 
             if($instance['title']):
                echo $before_title; ?> 
                    <?php echo apply_filters( 'widget_title', $instance['title'] ); ?>
                <?php echo $after_title; ?>
            <?php endif; ?>
		
                <a href="tel:<?php echo esc_attr( $phone_number ); ?>" class="footer-widget-title"><?php echo esc_html( $phone_number ); ?></a>
                <p class="desc"><?php echo esc_html( $subtext ); ?></p>
               		
	    	<?php print $after_widget; ?>  
		<?php
		}
		

		/**
		 * widget function.
		 *
		 * @see WP_Widget
		 * @access public
		 * @param array $instance
		 * @return void
		 */
		public function form($instance){
			$title  = isset($instance['title'])? $instance['title']:'';
			$subtext  = isset($instance['subtext'])? $instance['subtext']:'';
			$phone_number  = isset($instance['phone_number'])? $instance['phone_number']:'';
			
			?>
			<p>
				<label for="title"><?php esc_html_e('Title:','advkt-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('title')); ?>"  name="<?php print esc_attr($this->get_field_name('title')); ?>" value="<?php print esc_attr($title); ?>">

			<p>
				<label for="subtext"><?php esc_html_e('Sub Heading','advkt-toolkit'); ?></label>
			    <input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('subtext')); ?>"  name="<?php print esc_attr($this->get_field_name('subtext')); ?>" value="<?php print esc_attr($subtext); ?>">
            </p>

			<p>
				<label for="phone_number"><?php esc_html_e('Phone Number','advkt-toolkit'); ?></label>
			    <input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('phone_number')); ?>"  name="<?php print esc_attr($this->get_field_name('phone_number')); ?>" value="<?php print esc_attr($phone_number); ?>">
            </p>

			<?php
		}
				
		public function update( $new_instance, $old_instance ) {
			$instance = array();
			$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
			$instance['phone_number'] = ( ! empty( $new_instance['phone_number'] ) ) ? strip_tags( $new_instance['phone_number'] ) : 'fa-regular fa-location-dot';
			$instance['subtext'] = ( ! empty( $new_instance['subtext'] ) ) ? strip_tags( $new_instance['subtext'] ) : '';
			
			return $instance;
		}
	}
