<?php
	/**
	 * torun Footer full Widget
	 *
	 *
	 * @author 		Nilartstudio
	 * @category 	Widgets
	 * @package 	torun/Widgets
	 * @version 	1.0.0
	 * @extends 	WP_Widget
	 */
	add_action('widgets_init', 'advkt_address_info_widget');
	function advkt_address_info_widget() {
		register_widget('advkt_address_info_widget');
	}
	
	
	class Advkt_Address_Info_Widget  extends WP_Widget{
		
		public function __construct(){
			parent::__construct('advkt_address_info_widget',esc_html__('Advkt Company Address Info','advkt-toolkit'),array(
				'description' => esc_html__('Company Contact Info Footer Top Widget by Advkt','advkt-toolkit'),
			));
		}
		
		public function widget($args, $instance){
			extract($args);
			extract($instance);
			print $before_widget;
			?>

	
	



                            <?php
                            if ( ! empty( $title ) ) {
                                echo $before_title . apply_filters( 'widget_title', $title ) . $after_title;
                            } ?>

                            <div class="footer-widget-info">
                                <div class="footer-widget-contact">
                                    <div class="footer-contact">
                                        <ul>
											<?php
                                            if( $address !== ""): ?>
												<li>
													<div class="contact-icon"><?php echo esc_html( $address_label ); ?></div>
													<div class="contact-text">
														<span><?php echo esc_html( $address ); ?></span>
													</div>
												</li>
											<?php
                                            endif; ?>


											<?php
                                            if( $email !== ""): ?>
												<li>
													<div class="contact-icon"><?php echo esc_html( $email_label ); ?></div>
													<div class="contact-text">
														<a href="mailto:<?php echo esc_attr( $email ); ?>"><span><?php echo esc_html( $email ); ?></span></a>
													</div>
												</li>
											<?php
                                            endif; ?>

                                            <?php
                                            if( $phone_number !== ""): ?>
                                                <li>
                                                    <div class="contact-icon"><?php echo esc_html($phone_label); ?></div>
                                                    <div class="contact-text">
                                                        <a href="tel:<?php echo esc_attr($phone_number); ?>"><?php echo esc_html($phone_number); ?></a>
                                                    </div>
                                                </li>
                                            <?php
                                            endif; ?>

											<?php
                                            if( $mobile_number !== ""): ?>
												<li>
													<div class="contact-icon"><?php echo esc_html($mobile_label); ?></div>
													<div class="contact-text">
														<a href="tel:<?php echo esc_attr($mobile_number); ?>"><?php echo esc_html($mobile_number); ?></a>
													</div>
												</li>
											<?php
                                            endif; ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>



				
       

              	<?php print $after_widget; ?>
			<?php 
		}
		

		/**
		 * widget function.
		 *
		 * @see WP_Widget
		 * @access public
		 * @param array $instance
		 * @return void
		 */
		public function form($instance){

			$title  = isset($instance['title'])? $instance['title']:'';

			$address_label  = isset($instance['address_label'])? $instance['address_label']:'';
			$address  = isset($instance['address'])? $instance['address']:'';

			$email_label  = isset($instance['email_label'])? $instance['email_label']:'';
			$email  = isset($instance['email'])? $instance['email']:'';

			$phone_label  = isset($instance['phone_label'])? $instance['phone_label']:'';
			$phone_number  = isset($instance['phone_number'])? $instance['phone_number']:'';

			$mobile_label  = isset($instance['mobile_label'])? $instance['mobile_label']:'';
			$mobile_number  = isset($instance['mobile_number'])? $instance['mobile_number']:'';
			?>
			<p>
				<label for="title"><?php esc_html_e('Title:','advkt-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('title')); ?>"  name="<?php print esc_attr($this->get_field_name('title')); ?>" value="<?php print esc_attr($title); ?>">

	
			<p>
				<label for="address_label"><?php esc_html_e('Address Label: ','advkt-toolkit'); ?></label>
				<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('address_label')); ?>"  name="<?php print esc_attr($this->get_field_name('address_label')); ?>" value="<?php print esc_attr($address_label); ?>">
			</p>
			<p>
				<label for="address"><?php esc_html_e('Address Info: ','advkt-toolkit'); ?></label>
			</p>

			<textarea class="widefat" rows="2" cols="15" id="<?php print esc_attr($this->get_field_id('address')); ?>" value="<?php print esc_attr($address); ?>" name="<?php print esc_attr($this->get_field_name('address')); ?>"><?php print esc_attr($address); ?></textarea>

	
			<p>
				<label for="email_label"><?php esc_html_e('Email Label: ','advkt-toolkit'); ?></label>
				<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('email_label')); ?>"  name="<?php print esc_attr($this->get_field_name('email_label')); ?>" value="<?php print esc_attr($email_label); ?>">
			</p>
			<p>
				<label for="email"><?php esc_html_e('Email Address: ','advkt-toolkit'); ?></label>
				<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('email')); ?>"  name="<?php print esc_attr($this->get_field_name('email')); ?>" value="<?php print esc_attr($email); ?>">
			</p>


	
			<p>
				<label for="phone_label"><?php esc_html_e('Tel Phone Label: ','advkt-toolkit'); ?></label>
				<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('phone_label')); ?>"  name="<?php print esc_attr($this->get_field_name('phone_label')); ?>" value="<?php print esc_attr($phone_label); ?>">
			</p>

			<p>
				<label for="phone_number"><?php esc_html_e('Tel Phone Number: ','advkt-toolkit'); ?></label>
				<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('phone_number')); ?>"  name="<?php print esc_attr($this->get_field_name('phone_number')); ?>" value="<?php print esc_attr($phone_number); ?>">
			</p>

			<p>
				<label for="mobile_label"><?php esc_html_e('Mobile Label: ','advkt-toolkit'); ?></label>
				<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('mobile_label')); ?>"  name="<?php print esc_attr($this->get_field_name('mobile_label')); ?>" value="<?php print esc_attr($mobile_label); ?>">
			</p>

			<p>
				<label for="mobile_number"><?php esc_html_e('Mobile Phone Number: ','advkt-toolkit'); ?></label>
				<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('mobile_number')); ?>"  name="<?php print esc_attr($this->get_field_name('mobile_number')); ?>" value="<?php print esc_attr($mobile_number); ?>">
			</p>

		
			<?php
		}
				
		public function update( $new_instance, $old_instance ) {
			$instance = array();
			$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';

			$instance['address_label'] = ( ! empty( $new_instance['address_label'] ) ) ? strip_tags( $new_instance['address_label'] ) : '';
			$instance['address'] = ( ! empty( $new_instance['address'] ) ) ? strip_tags( $new_instance['address'] ) : '';

			$instance['email_label'] = ( ! empty( $new_instance['email_label'] ) ) ? strip_tags( $new_instance['email_label'] ) : '';
			$instance['email'] = ( ! empty( $new_instance['email'] ) ) ? strip_tags( $new_instance['email'] ) : '';

			$instance['phone_label'] = ( ! empty( $new_instance['phone_label'] ) ) ? strip_tags( $new_instance['phone_label'] ) : '';
			$instance['phone_number'] = ( ! empty( $new_instance['phone_number'] ) ) ? strip_tags( $new_instance['phone_number'] ) : '';

			$instance['mobile_label'] = ( ! empty( $new_instance['mobile_label'] ) ) ? strip_tags( $new_instance['mobile_label'] ) : '';
			$instance['mobile_number'] = ( ! empty( $new_instance['mobile_number'] ) ) ? strip_tags( $new_instance['mobile_number'] ) : '';


			return $instance;
		}
	}