<?php 
/** 
 * The main template file
 *
 * @package  WordPress
 * @subpackage  torun
 */
get_header(); ?>

        <?php 
            if( have_posts() ):
            while( have_posts() ):the_post();
                    $title = get_post_meta(get_the_ID(), 'member_title', true);
                    $designation = get_post_meta(get_the_ID(), 'member_designation', true);
                    $short_desc = get_post_meta(get_the_ID(), 'member_short_desc', true);
                    $member_single_img_url = get_post_meta( get_the_ID(), 'member_single_img', true );

                    $social_profiles_repeat_group = get_post_meta(get_the_ID(), 'social_profiles_repeat_group', true); 
                    $left_skills_repeat_group = get_post_meta(get_the_ID(), 'left_skills_repeat_group', true); 
                    $right_skills_repeat_group = get_post_meta(get_the_ID(), 'right_skills_repeat_group', true); 

                    $first_tab_title = get_post_meta(get_the_ID(), 'member_first_tab_title', true);
                    $second_tab_title = get_post_meta(get_the_ID(), 'member_second_tab_title', true);
                    ?>

                    <!-- team member details start -->
                    <div class="team-member-details">
                            <div class="container">

                                <!-- single team member start -->
                                <div class="single-team-member">
                                    <div class="row gy-4">
                                        <div class="col-lg-5">
                                            <div class="team-member-thumb">
                                                <?php
                                                if($member_single_img_url !== "" ): ?>                    
                                                    <div class="image">
                                                        <img src="<?php echo $member_single_img_url; ?>" alt="">
                                                    </div>
                                                <?php
                                                else: ?>
                                                    <div class="image">
                                                        <img src="<?php the_post_thumbnail_url(); ?>" alt="">
                                                    </div>
                                                <?php
                                                endif; ?>

                                                <div class="user-meta background-gray">
                                                    <h2 class="title mb-0 text-center"><?php the_title(); ?></h2>
                                                    <span class="desc"><?php echo $designation; ?></span>
                                                        <?php 
                                                        if(is_array($social_profiles_repeat_group)): ?> 
                                                            <div class="member-social-site justify-content-between">
                                                                <?php   
                                                                foreach ($social_profiles_repeat_group as $value) { ?>
                                                                <a href="<?php echo esc_attr( $value['social_profile_link'] ); ?>"><i class="<?php echo esc_attr( $value['social_profile_icon'] ); ?>"></i></a>
                                                                <?php  
                                                                } 
                                                                ?> 
                                                            </div>
                                                        <?php 
                                                        endif; ?>
                                                </div>
                                            </div>
                                            
                                        </div>
                                        <div class="col-lg-7">
                                            <div class="team-member-content">
                                                <div class="content">
                                                    <h2 class="title mb-0"><?php echo $title; ?></h2>
                                                    <p class="mb-0"><?php echo $short_desc; ?></p>
                                                </div>
                                                <div class="team-tab">
                                                    <nav>
                                                        <ul class="nav-tab" id="nav-tab" role="tablist">
                                                            <li class="active" id="nav-tab1" data-bs-toggle="tab" data-bs-target="#nav-education" role="tab" aria-controls="nav-education" aria-selected="true"><?php echo $first_tab_title; ?></li>
                                                            <li class="" id="nav-tab2" data-bs-toggle="tab" data-bs-target="#nav-carrera" role="tab" aria-controls="nav-carrera" aria-selected="false"><?php echo $second_tab_title; ?></li>
                                                        </ul>
                                                    </nav>
                                                    <div class="tab-content" id="nav-tabContent">
                                                        <div class="tab-pane fade show active" id="nav-education" role="tabpanel" aria-labelledby="nav-tab1">
                                                            <?php 
                                                            if(is_array($left_skills_repeat_group)): ?> 
                                                                <div class="progress-skill">
                                                                    <?php   
                                                                    foreach ($left_skills_repeat_group as $value) { ?>
                                                                        <div class="title-wrapper">
                                                                            <div class="icon">
                                                                                <?php
                                                                                if( isset( $value['left_skill_icon'] ) ): ?>
                                                                                    <i class="<?php echo esc_attr( $value['left_skill_icon']); ?>"></i>
                                                                                <?php
                                                                                endif; ?>

                                                                                <?php
                                                                                if( isset( $value['left_skill_label'] ) ): ?>
                                                                                    <h3 class="mb-0 title"><?php print wp_kses_post($value['left_skill_label']); ?></h3>
                                                                                <?php
                                                                                endif; ?>
                                                                            </div>

                                                                            <?php
                                                                            if( isset( $value['left_skill_info'] ) ): ?>
                                                                                <p class="desc"><?php print wp_kses_post($value['left_skill_info']); ?></p>
                                                                            <?php
                                                                            endif; ?>
                                                                        </div>
                                                                    <?php  
                                                                    } 
                                                                    ?> 
                                                                </div>
                                                            <?php 
                                                            endif; ?>
                                                        </div>
                                                        <div class="tab-pane fade" id="nav-carrera" role="tabpanel" aria-labelledby="nav-tab2">
                                                            <?php 
                                                            if(is_array($right_skills_repeat_group)): ?>                                         
                                                                <div class="progress-skill">
                                                                    <?php   
                                                                    foreach ($right_skills_repeat_group as $value) { ?>
                                                                        <div class="title-wrapper">
                                                                            <div class="icon">
                                                                                <?php
                                                                                if( isset( $value['right_skill_icon'] ) ): ?>
                                                                                    <i class="<?php echo esc_attr( $value['right_skill_icon']); ?>"></i>
                                                                                <?php
                                                                                endif; ?>

                                                                                <?php
                                                                                if( isset( $value['right_skill_label'] ) ): ?>
                                                                                    <h3 class="mb-0 title"><?php print wp_kses_post($value['right_skill_label']); ?></h3>
                                                                                <?php
                                                                                endif; ?>
                                                                            </div>
                                                                            
                                                                            <?php
                                                                            if( isset( $value['right_skill_info'] ) ): ?>
                                                                                <p class="desc"><?php print wp_kses_post($value['right_skill_info']); ?></p>
                                                                            <?php
                                                                            endif; ?>
                                                                        </div>
                                                                    <?php  
                                                                    } 
                                                                    ?> 
                                                                </div>
                                                            <?php 
                                                            endif; ?>



                                                        </div>
                                                    </div>
                                                    
                                                </div>
                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- single team member end -->

                            </div>
                        </div>
                        <!-- team member details end -->

                        <?php the_content(); ?>

                   


                <?php 
                endwhile; wp_reset_query();
            endif; 
        ?>


<?php get_footer();  ?>