<?php
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Redux' ) ) {
	return;
}

$opt_name = 'advkt_options';

/** Start Core Options */
$theme = wp_get_theme();

$args = array(
	'opt_name'                  => $opt_name,
	'display_name' 				=> esc_html__( ucwords($theme->get( 'Name' )) . ' Options Panel', 'advkt-toolkit' ),
	'display_version'           => $theme->get( 'Version' ),
	'menu_type'                 => 'menu',
	'allow_sub_menu'            => true,
	'menu_title'                => esc_html__( 'Advkt Options', 'advkt-toolkit' ),
	'page_title'                => esc_html__( 'Advkt Options', 'advkt-toolkit' ),
	'disable_google_fonts_link' => false,
	'admin_bar'                 => true,
	'admin_bar_icon'            => 'dashicons-portfolio',
	'admin_bar_priority'        => 50,
	'global_variable'           => $opt_name,
	'dev_mode'                  => false,
	'customizer'                => true,
	'open_expanded'             => false,
	'disable_save_warn'         => false,
	'page_priority'             => 90,
	'page_parent'               => 'themes.php',
	'page_permissions'          => 'manage_options',
	'menu_icon'                 => '',
	'last_tab'                  => '',
	'page_icon'                 => 'icon-themes',
	'page_slug'                 => $opt_name,
	'save_defaults'             => true,
	'default_show'              => false,
	'default_mark'              => '*',
	'show_import_export'        => true,
	'transient_time'            => 60 * MINUTE_IN_SECONDS,
	'output'                    => true,
	'output_tag'                => true,
	'footer_credit'             => '',
	'use_cdn'                   => true,
	'admin_theme'               => 'wp',
	'flyout_submenus'           => true,
	'font_display'              => 'swap',
	'hints'                     => array(
		'icon'          => 'el el-question-sign',
		'icon_position' => 'right',
		'icon_color'    => 'lightgray',
		'icon_size'     => 'normal',
		'tip_style'     => array(
			'color'   => 'red',
			'shadow'  => true,
			'rounded' => false,
			'style'   => '',
		),
		'tip_position'  => array(
			'my' => 'top left',
			'at' => 'bottom right',
		),
		'tip_effect'    => array(
			'show' => array(
				'effect'   => 'slide',
				'duration' => '500',
				'event'    => 'mouseover',
			),
			'hide' => array(
				'effect'   => 'slide',
				'duration' => '500',
				'event'    => 'click mouseleave',
			),
		),
	),
	'database'                  => '',
	'network_admin'             => true,
	'search'                    => false,
);

Redux::set_args( $opt_name, $args );

/** End Core Options */

/** START Header Fields */
Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Header', 'advkt-toolkit' ),
		'id'               => 'header',
		'desc'             => esc_html__( 'All Header fields here!', 'advkt-toolkit' ),
		'customizer_width' => '450px',
		'icon'             => 'el el-home',
	)
);

Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Header Topbar Setting', 'advkt-toolkit' ),
		'id'               => 'header_topbar_setting',
		'subsection'       => true,
		'customizer_width' => '450px',
		'fields'           => array(
			array(
				'id'       => 'advkt_emergency_phone_switch',
				'type'     => 'switch', 
				'title'    => esc_html__('Show Emergency Phone Number', 'advkt-toolkit'),
				'default'  => false,
			),
			array(
				'id'       => 'advkt_emergency_phone_label',
				'type'     => 'text',
				'title'    => esc_html__('Primary Phone Label','advkt-toolkit'),
				'default'  => esc_html__('Emergency call','advkt-toolkit'),
            ),
			array(
				'id'       => 'advkt_emergency_phone_icon',
				'type'     => 'text',
				'title'    => esc_html__('Primary Phone Icon','advkt-toolkit'),
				'default'  => esc_html__('fa-thin fa-phone-volume','advkt-toolkit'),
            ),
			array(
				'id'       => 'advkt_emergency_phone',
				'type'     => 'text',
				'title'    => esc_html__('Primary Phone Number','advkt-toolkit'),
				'default'  => esc_html__('0123 4567 890','advkt-toolkit'),
            ),
			// array(
			// 	'id'   =>'divider_0001',
			// 	'type' => 'divide'
            // ),
			array(
				'id'       => 'advkt_phone_switch',
				'type'     => 'switch', 
				'title'    => esc_html__('Show Phone Number', 'advkt-toolkit'),
				'default'  => false,
			),
			array(
				'id'       => 'advkt_phone_label',
				'type'     => 'text',
				'title'    => esc_html__('Secondary Phone Label','advkt-toolkit'),
				'default'  => esc_html__('Call Us For Free Consultation','advkt-toolkit'),
            ),
			array(
				'id'       => 'advkt_phone',
				'type'     => 'text',
				'title'    => esc_html__('Secondary Phone Number','advkt-toolkit'),
				'default'  => esc_html__('0123 4567 890','advkt-toolkit'),
            ),
			// array(
			// 	'id'   =>'divider_0002',
			// 	'type' => 'divide'
            // ),
			array(
				'id'       => 'advkt_opening_hour_switch',
				'type'     => 'switch', 
				'title'    => esc_html__('Show Open Hour', 'advkt-toolkit'),
				'default'  => false,
			),
			array(
				'id'       => 'advkt_opening_hour_icon',
				'type'     => 'text',
				'title'    => esc_html__('Opening Hour Icon','advkt-toolkit'),
				'default'  => esc_html__('fa-thin fa-clock','advkt-toolkit'),
            ),
			array(
				'id'       => 'advkt_opening_hour_text',
				'type'     => 'text',
				'title'    => esc_html__('Opening Hour','advkt-toolkit'),
				'default'  => esc_html__('Oneday to Friday - 08:00 - 20:00', 'advkt-toolkit'),
            ),
			// array(
			// 	'id'   =>'divider_000020',
			// 	'type' => 'divide'
            // ),
			array(
				'id'       => 'advkt_show_header_top_social_profile',
				'type'     => 'switch', 
				'title'    => esc_html__('Show Social Profiles', 'advkt-toolkit'),
				'default'  => false,
			),
		),
	)
);

Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Header Sidebar Area', 'advkt-toolkit' ),
		'id'               => 'header_notice',
		'subsection'       => true,
		'customizer_width' => '450px',
		'fields'           => array(
			array(
				'id'       => 'header_topbar_switch',
				'type'     => 'switch', 
				'title'    => esc_html__('Show Header Topbar', 'advkt-toolkit'),
				'default'  => false,
			),
			array(
				'id'       => 'sidebar_logo',
				'type'     => 'media', 
				'url'      => false,
				'title'    => esc_html__('Sidebar Logo', 'advkt-toolkit'),
				'required' => array('header_topbar_switch','=', 1),
				'default'  => array(
					'url'=>get_template_directory_uri() . '/img/logo/dark-logo.png'
				),
            ),
			array(
				'id'       => 'company_info',
				'type'     => 'editor',
				'title'    => esc_html__('Company Info', 'advkt-toolkit'),
				'required' => array('header_topbar_switch','=', 1),
				'default'  => esc_html__('Although we are located in Brooklyn, our maritime lawyers are proud to help the injured throughout the nation, including workers who were working in foreign waters at the time of the incident go up against the largest offshore companies and win', 'advkt-toolkit'),
				'args'   => array(
					'teeny'            => true,
					'textarea_rows'    => 10
				)
            ),
			// array(
			// 	'id'   =>'divider_000',
			// 	'type' => 'divide',
			// 	'required' => array('header_topbar_switch','=', 1),
            // ),
			array(
				'id'       => 'sidebar_contact_info',
				'type'     => 'text',
				'title'    => esc_html__('Contact Info Text', 'advkt-toolkit'),
				'required' => array('header_topbar_switch','=', 1),
				'default'  => esc_html__('Contact Info', 'advkt-toolkit'),
            ),
			array(
				'id'       => 'sidebar_address_icon',
				'type'     => 'text',
				'title'    => esc_html__('Address Icon', 'advkt-toolkit'),
				'required' => array('header_topbar_switch','=', 1),
				'default'  => esc_html__('fa-solid fa-location-dot', 'advkt-toolkit'),
            ),
			array(
				'id'       => 'sidebar_address',
				'type'     => 'text',
				'title'    => esc_html__('Address Info', 'advkt-toolkit'),
				'required' => array('header_topbar_switch','=', 1),
				'default'  => esc_html__('20, Bordeshi, New York, US', 'advkt-toolkit'),
            ),
			array(
				'id'       => 'sidebar_email_icon',
				'type'     => 'text',
				'title'    => esc_html__('Email Icon', 'advkt-toolkit'),
				'required' => array('header_topbar_switch','=', 1),
				'default'  => esc_html__('fa-regular fa-envelope', 'advkt-toolkit'),
            ),
			array(
				'id'       => 'sidebar_email_address',
				'type'     => 'text',
				'title'    => esc_html__('Email Address', 'advkt-toolkit'),
				'required' => array('header_topbar_switch','=', 1),
				'default'  => esc_html__('hello@advkt.com', 'advkt-toolkit'),
            ),
			array(
				'id'       => 'sidebar_phone_icon',
				'type'     => 'text',
				'title'    => esc_html__('Phone Icon', 'advkt-toolkit'),
				'required' => array('header_topbar_switch','=', 1),
				'default'  => esc_html__('fa-solid fa-phone', 'advkt-toolkit'),
            ),
			array(
				'id'       => 'sidebar_phone_number',
				'type'     => 'text',
				'title'    => esc_html__('Phone Number', 'advkt-toolkit'),
				'required' => array('header_topbar_switch','=', 1),
				'default'  => esc_html__('+123-456-7890', 'advkt-toolkit'),
            ),
			// array(
			// 	'id'   =>'divider_33333',
			// 	'type' => 'divide',
			// 	'required' => array('header_topbar_switch','=', 1),
            // ),
			array(
				'id'       => 'show_sidebar_social_profile',
				'type'     => 'switch', 
				'title'    => esc_html__('Show Sidebar Social Profile', 'advkt-toolkit'),
				'default'  => false,
			),
			array(
				'id'         => 'sidebar_social_profile',
				'type'       => 'repeater',
				'title'      => __( 'Social Profiles', 'advkt-toolkit' ),
				'subtitle'   => __( '', 'advkt-toolkit' ),
				'desc'       => __( '', 'advkt-toolkit' ),
				//'group_values' => true, // Group all fields below within the repeater ID
				//'item_name' => '', // Add a repeater block name to the Add and Delete buttons
				//'bind_title' => '', // Bind the repeater block title to this field ID
				//'static'     => 2, // Set the number of repeater blocks to be output
				//'limit' => 2, // Limit the number of repeater blocks a user can create
				// 'sortable' => true, // Allow the users to sort the repeater blocks or not
				'fields'     => array(
					array(
						'id'          => 'social_profile_icon',
						'type'        => 'text',
						'placeholder' => __( 'Social Profile Icon', 'advkt-toolkit' ),
					),
					array(
						'id'          => 'social_profile_link',
						'type'        => 'text',
						'placeholder' => __( 'Social Profile Link', 'advkt-toolkit' ),
					),
				)
			)	
		),
	)
);

Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Header Setting', 'advkt-toolkit' ),
		'id'               => 'header_setting',
		'subsection'       => true,
		'customizer_width' => '450px',
		'fields'           => array(
			array(
				'id'       => 'choose_default_header',
				'type'     => 'select',
				'title'    => esc_html__('Choose Header Style', 'advkt-toolkit'), 
				'options'  => array(
					'1' => esc_html__( 'Header Style 1', 'advkt-toolkit' ),
					'2' => esc_html__( 'Header Style 2', 'advkt-toolkit' ),
					'3' => esc_html__( 'Header Style 3', 'advkt-toolkit' ),
				),
				'default'  => '3',
			),
			array(
				'id'       => 'primary_logo',
				'type'     => 'media', 
				'url'      => false,
				'title'    => esc_html__('Header Logo', 'advkt-toolkit'),
				'default'  => array(
					'url'=>get_template_directory_uri() . '/img/logo/logo.png'
				),
            ),
			array(
				'id'       => 'sticky_logo',
				'type'     => 'media', 
				'url'      => false,
				'title'    => esc_html__('Sticky Logo', 'advkt-toolkit'),
				'default'  => array(
					'url'=>get_template_directory_uri() . '/img/logo/logo.png'
				),
            ),
			array(
				'id'       => 'show_header_sidebar',
				'type'     => 'switch', 
				'title'    => esc_html__('Show Sidebar', 'advkt-toolkit'),
				'default'  => false,
			),
			array(
				'id'       => 'show_header_menu_button',
				'type'     => 'switch', 
				'title'    => esc_html__('Show Button', 'advkt-toolkit'),
				'default'  => false,
			),
			array(
				'id'       => 'header_menu_btn_text',
				'type'     => 'text',
				'title'    => esc_html__('Button Text', 'advkt-toolkit'),
				'default' => esc_html__('Free Consultation','augmit'),
				'required' => array('show_header_menu_button','=', 1),
            ),
			array(
				'id'       => 'header_menu_btn_link',
				'type'     => 'text',
				'title'    => esc_html__('Button Link', 'advkt-toolkit'),
				'default' => '#',
				'required' => array('show_header_menu_button','=', 1),
            )
		),
	)
);



Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Mobile Header Setting', 'advkt-toolkit' ),
		'id'               => 'mobile_header_setting',
		'subsection'       => true,
		'customizer_width' => '450px',
		'fields'           => array(
			array(
				'id'       => 'mobile_header_logo',
				'type'     => 'media', 
				'url'      => false,
				'title'    => esc_html__('Header Logo', 'advkt-toolkit'),
				'default'  => array(
					'url'=>get_template_directory_uri() . '/img/logo/logo.png'
				),
            ),
			array(
				'id'       => 'mobile_header_show_contact_info',
				'type'     => 'switch', 
				'title'    => esc_html__('Show Contact Info', 'advkt-toolkit'),
				'default'  => false,
			),
			array(
				'id'       => 'mobile_header_contact_info',
				'type'     => 'text',
				'title'    => esc_html__('Contact Info','advkt-toolkit'),
				'default' => esc_html__('Contact Info','advkt-toolkit'),
				'required' => array('mobile_header_show_contact_info','=', 1),
            ),
			array(
				'id'       => 'mobile_header_contact_address',
				'type'     => 'text',
				'title'    => esc_html__('Address','advkt-toolkit'),
				'default' => esc_html__('20, Bordeshi, New York, US','advkt-toolkit'),
				'required' => array('mobile_header_show_contact_info','=', 1),
            ),
			array(
				'id'       => 'mobile_header_contact_email',
				'type'     => 'text',
				'title'    => esc_html__('Email','advkt-toolkit'),
				'default' => esc_html__('hello@augmit.com','advkt-toolkit'),
				'required' => array('mobile_header_show_contact_info','=', 1),
            ),
			array(
				'id'       => 'mobile_header_contact_phone',
				'type'     => 'text',
				'title'    => esc_html__('Phone','advkt-toolkit'),
				'default' => esc_html__('+123-456-7890','advkt-toolkit'),
				'required' => array('mobile_header_show_contact_info','=', 1),
            ),
			array(
				'id'       => 'mobile_header_show_social_info',
				'type'     => 'switch', 
				'title'    => esc_html__('Show Social Info', 'advkt-toolkit'),
				'default'  => false,
			),
		),
	)
);

Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Menu Typography', 'advkt-toolkit' ),
		'id'               => 'header_typography',
		'subsection'       => true,
		'customizer_width' => '450px',
		'fields'           => array(
			array(
				'id'             => 'primary_menu_Typography',
				'type'           => 'typography',
				'title'          => esc_html__('Header Style 1 : Menu Typography', 'advkt-toolkit'),
				'google'         => true,
				'text-align'     => false,
				'text-transform' => true,
				'color'          => false,
				'line-height'    => true,
				'letter-spacing' => true,
				'all_styles'     => true,
				'preview'        => array('text'),
				'output'         => array('.header-area.style-1 .main-menu ul li a'),
				'compiler'       => array('.header-area.style-1 .main-menu ul li a'),
				'units'          => 'px',
				'default'        => array(
					'font-size'   => '',
					'font-family' => '',
					'text-transform' => '',
					'font-weight' => '',
					'line-height' => '',
					'google'      => true
				),
			),
			array(
				'id'       => 'menu_font_color',
				'type'     => 'color',
				'title'    => esc_html__('Normal Color', 'advkt-toolkit'), 
				'default'  => '',
				'output'   => array('.header-area.style-1 .main-menu ul li a, .header-area.style-1 .main-menu ul ul li a'),
				'transparent' => false,
			),
			array(
				'id'       => 'menu_font_hover_color',
				'type'     => 'color',
				'title'    => esc_html__('Hover Color', 'advkt-toolkit'), 
				'default'  => '',
				'output'   => array('.header-area.style-1 .main-menu ul li a:hover, .header-area.style-1 .main-menu ul ul li a:hover'),
				'transparent' => false,
			),
			array(
				'id'       => 'menu_font_active_color',
				'type'     => 'color',
				'title'    => esc_html__('Active Color', 'advkt-toolkit'), 
				'default'  => '',
				'output'   => array('.header-area.style-1 .main-menu ul li.active > a'),
				'transparent' => false,
			),
			array(
				'id'       => 'menu_backgound_color',
				'type'     => 'background',
				'title'    => esc_html__('Background Color', 'advkt-toolkit'), 
				'output'   => array('.header-area.style-1, .header-area.style-1 .header-menu-area'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'default'  => array(
					'background-color' => '',
				)
			),
			array(
				'id'       => 'sticky_menu_backgound_color',
				'type'     => 'background',
				'title'    => esc_html__('Sticky Background Color', 'advkt-toolkit'), 
				'output'   => array('.header-area.style-1.sticky_menu'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'default'  => array(
					'background-color' => '',
				)
			),
			// array(
			// 	'id'   =>'divider_1',
			// 	'type' => 'divide'
			// ),
			array(
				'id'             => 'secondary_menu_Typography',
				'type'           => 'typography',
				'title'          => esc_html__('Header Style 2 : Menu Typography', 'advkt-toolkit'),
				'google'         => true,
				'text-align'     => false,
				'text-transform' => true,
				'color'          => false,
				'line-height'    => true,
				'letter-spacing' => true,
				'all_styles'     => true,
				'preview'        => array('text'),
				'output'         => array('.header-area.style-2 .main-menu ul li a'),
				'compiler'       => array('.header-area.style-2 .main-menu ul li a'),
				'units'          => 'px',
				'default'        => array(
					'font-size'   => '',
					'font-family' => '',
					'text-transform' => '',
					'font-weight' => '',
					'line-height' => '',
					'google'      => true
				),
			),
			array(
				'id'       => 'secondary_menu_font_color',
				'type'     => 'color',
				'title'    => esc_html__('Normal Color', 'advkt-toolkit'), 
				'default'  => '',
				'output'   => array('.header-area.style-2 .main-menu ul li a, .header-area.style-2 .main-menu ul ul li a'),
				'transparent' => false,
			),
			array(
				'id'       => 'secondary_menu_font_hover_color',
				'type'     => 'color',
				'title'    => esc_html__('Hover Color', 'advkt-toolkit'), 
				'default'  => '',
				'output'   => array('.header-area.style-2 .main-menu ul li a:hover, .header-area.style-2 .main-menu ul ul li a:hover'),
				'transparent' => false,
			),
			array(
				'id'       => 'secondary_menu_font_active_color',
				'type'     => 'color',
				'title'    => esc_html__('Active Color', 'advkt-toolkit'), 
				'default'  => '',
				'output'   => array('.header-area.style-2 .main-menu ul li.active > a'),
				'transparent' => false,
			),
			array(
				'id'       => 'secondary_menu_backgound_color',
				'type'     => 'background',
				'title'    => esc_html__('Background Color', 'advkt-toolkit'), 
				'output'   => array('.header-area.style-2, .header-area.style-2 .header-menu-area'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'default'  => array(
					'background-color' => '',
				)
			),
			array(
				'id'       => 'secondary_sticky_menu_backgound_color',
				'type'     => 'background',
				'title'    => esc_html__('Sticky Background Color', 'advkt-toolkit'), 
				'output'   => array('.header-area.style-2.sticky_menu'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'default'  => array(
					'background-color' => '',
				)
			),
			// array(
			// 	'id'   =>'divider_2',
			// 	'type' => 'divide'
			// ),
			array(
				'id'             => 'third_menu_Typography',
				'type'           => 'typography',
				'title'          => esc_html__('Header Style 3 : Menu Typography', 'advkt-toolkit'),
				'google'         => true,
				'text-align'     => false,
				'text-transform' => true,
				'color'          => false,
				'line-height'    => true,
				'letter-spacing' => true,
				'all_styles'     => true,
				'preview'        => array('text'),
				'output'         => array('.header-area.style-3 .main-menu ul li a'),
				'compiler'       => array('.header-area.style-3 .main-menu ul li a'),
				'units'          => 'px',
				'default'        => array(
					'font-size'   => '',
					'font-family' => '',
					'text-transform' => '',
					'font-weight' => '',
					'line-height' => '',
					'google'      => true
				),
			),
			array(
				'id'       => 'third_menu_font_color',
				'type'     => 'color',
				'title'    => esc_html__('Normal Color', 'advkt-toolkit'), 
				'default'  => '',
				'output'   => array('.header-area.style-3 .main-menu ul li a, .header-area.style-3 .main-menu ul ul li a'),
				'transparent' => false,
			),
			array(
				'id'       => 'third_menu_font_hover_color',
				'type'     => 'color',
				'title'    => esc_html__('Hover Color', 'advkt-toolkit'), 
				'default'  => '',
				'output'   => array('.header-area.style-3 .main-menu ul li a:hover, .header-area.style-3 .main-menu ul ul li a:hover'),
				'transparent' => false,
			),
			array(
				'id'       => 'third_menu_font_active_color',
				'type'     => 'color',
				'title'    => esc_html__('Active Color', 'advkt-toolkit'), 
				'default'  => '',
				'output'   => array('.header-area.style-3 .main-menu ul li.active > a'),
				'transparent' => false,
			),
			array(
				'id'       => 'third_menu_backgound_color',
				'type'     => 'background',
				'title'    => esc_html__('Background Color', 'advkt-toolkit'), 
				'output'   => array('.header-area.style-3, .header-area.style-3 .header-menu-area'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'default'  => array(
					'background-color' => '',
				)
			),
			array(
				'id'       => 'third_sticky_menu_backgound_color',
				'type'     => 'background',
				'title'    => esc_html__('Sticky Background Color', 'advkt-toolkit'), 
				'output'   => array('.header-area.style-3.sticky_menu'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'default'  => array(
					'background-color' => '',
				)
			),
		),
	)
);

Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Button Typography', 'advkt-toolkit' ),
		'id'               => 'header_top_button_typography',
		'subsection'       => true,
		'customizer_width' => '450px',
		'fields'           => array(
			array(
				'id'       => 'show_header_one_button_typography',
				'type'     => 'switch', 
				'title'    => esc_html__('Header Style 1 : Show Button Typography', 'advkt-toolkit'),
				'default'  => false,
			),
			array(
				'id'             => 'header_btn_Typography',
				'type'           => 'typography',
				'title'          => esc_html__('Button Typography', 'advkt-toolkit'),
				'google'         => true,
				'text-align'     => false,
				'text-transform' => true,
				'color'          => false,
				'line-height'    => true,
				'letter-spacing' => true,
				'all_styles'     => true,
				'preview'        => array('text'),
				'output'         => array('.header-area.style-1 .search-btn-with-btn .theme-btn'),
				'compiler'       => array('.header-area.style-1 .search-btn-with-btn .theme-btn'),
				'units'          => 'px',
				'default'        => array(
					'font-size'   => '',
					'font-family' => '',
					'font-weight' => '',
					'line-height' => '',
					'color'		=> '',
					'google'      => true
				),
				'required' => array('show_header_one_button_typography','=', 1),
			),
			array(
					'id'       => 'header_btn_color',
					'type'     => 'color',
					'title'    => esc_html__('Button Normal Color', 'advkt-toolkit'), 
					'default'  => '',
					'output'   => array('.header-area.style-1 .search-btn-with-btn .theme-btn'),
					'transparent' => false,
					'required' => array('show_header_one_button_typography','=', 1),
			),
			array(
				'id'       => 'header_btn_hover_color',
				'type'     => 'color',
				'title'    => esc_html__('Button Hover Color', 'advkt-toolkit'), 
				'default'  => '',
				'output'   => array('.header-area.style-1 .search-btn-with-btn .theme-btn:hover'),
				'transparent' => false,
				'required' => array('show_header_one_button_typography','=', 1),
			),
			array(
				'id'       => 'header_btn_background_color',
				'type'     => 'background',
				'title'    => esc_html__('Button Background Color', 'advkt-toolkit'), 
				'output'   => array('.header-area.style-1 .search-btn-with-btn .theme-btn'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'default'  => array(
					'background-color' => '',
				),
				'required' => array('show_header_one_button_typography','=', 1),
			),
			array(
				'id'       => 'header_btn_background_hover_color',
				'type'     => 'background',
				'title'    => esc_html__('Button Background Hover Color', 'advkt-toolkit'), 
				'output'   => array('.header-area.style-1 .search-btn-with-btn .theme-btn:hover'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'default'  => array(
					'background-color' => '',
				),
				'required' => array('show_header_one_button_typography','=', 1),
			),
            array(
                'id'       => 'header_btn_border',
				'type'     => 'border',
				'title'    => esc_html__('Button Border Option', 'your-project-name'),
				'subtitle' => esc_html__('Only color validation can be done on this field type', 'your-project-name'),
				'output'   => array('.header-area.style-1 .search-btn-with-btn .theme-btn'),
				'desc'     => esc_html__('This is the description field, again good for additional info.', 'your-project-name'),
				'default'  => array(
					'border-color'  => '', 
					'border-style'  => '', 
					'border-top'    => '', 
					'border-right'  => '', 
					'border-bottom' => '', 
					'border-left'   => ''
				),
				'required' => array('show_header_one_button_typography','=', 1),
            ),
            array(
                'id'       => 'header_btn_padding',
                'type'     => 'spacing',
                'mode'     => 'padding',
                'title'    => esc_html__('Button Padding Option', 'advkt-toolkit'),
                'output'   => array('.header-area.style-1 .search-btn-with-btn .theme-btn'),
                'units'    => 'px',
                'default'  => array(
                    'padding-top'    => '',
                    'padding-right'  => '',
                    'padding-bottom' => '',
                    'padding-left'   => '',
                ),
				'required' => array('show_header_one_button_typography','=', 1),
            ),
			// array(
			// 	'id'   =>'header_top_1',
			// 	'type' => 'divide'
			// ),
			array(
				'id'       => 'show_header_two_button_typography',
				'type'     => 'switch', 
				'title'    => esc_html__('Header Style 2 : Show Button Typography', 'advkt-toolkit'),
				'default'  => false,
			),
			array(
				'id'             => 'header_two_btn_Typography',
				'type'           => 'typography',
				'title'          => esc_html__('Button Typography', 'advkt-toolkit'),
				'google'         => true,
				'text-align'     => false,
				'text-transform' => true,
				'color'          => false,
				'line-height'    => true,
				'letter-spacing' => true,
				'all_styles'     => true,
				'preview'        => array('text'),
				'output'         => array('.header-area.style-2 .header-top .header-social-wrapper .btn-wrapper .theme-btn'),
				'compiler'       => array('.header-area.style-2 .header-top .header-social-wrapper .btn-wrapper .theme-btn'),
				'units'          => 'px',
				'default'        => array(
					'font-size'   => '',
					'font-family' => '',
					'font-weight' => '',
					'line-height' => '',
					'color'		=> '',
					'google'      => true
				),
				'required' => array('show_header_two_button_typography','=', 1),
			),
			array(
					'id'       => 'header_two_btn_color',
					'type'     => 'color',
					'title'    => esc_html__('Button Normal Color', 'advkt-toolkit'), 
					'default'  => '',
					'output'   => array('.header-area.style-2 .header-top .header-social-wrapper .btn-wrapper .theme-btn'),
					'transparent' => false,
					'required' => array('show_header_two_button_typography','=', 1),
			),
			array(
				'id'       => 'header_two_btn_hover_color',
				'type'     => 'color',
				'title'    => esc_html__('Button Hover Color', 'advkt-toolkit'), 
				'default'  => '',
				'output'   => array('.header-area.style-2 .header-top .header-social-wrapper .btn-wrapper .theme-btn:hover'),
				'transparent' => false,
				'required' => array('show_header_two_button_typography','=', 1),
			),
			array(
				'id'       => 'header_two_btn_background_color',
				'type'     => 'background',
				'title'    => esc_html__('Button Background Color', 'advkt-toolkit'), 
				'output'   => array('.header-area.style-2 .header-top .header-social-wrapper .btn-wrapper .theme-btn'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'default'  => array(
					'background-color' => '',
				),
				'required' => array('show_header_two_button_typography','=', 1),
			),
			array(
				'id'       => 'header_two_btn_background_hover_color',
				'type'     => 'background',
				'title'    => esc_html__('Button Background Hover Color', 'advkt-toolkit'), 
				'output'   => array('.header-area.style-2 .header-top .header-social-wrapper .btn-wrapper .theme-btn:hover'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'default'  => array(
					'background-color' => '',
				),
				'required' => array('show_header_two_button_typography','=', 1),
			),
            array(
                'id'       => 'header_two_btn_border',
				'type'     => 'border',
				'title'    => esc_html__('Button Border Option', 'your-project-name'),
				'subtitle' => esc_html__('Only color validation can be done on this field type', 'your-project-name'),
				'output'   => array('.header-area.style-2 .header-top .header-social-wrapper .btn-wrapper .theme-btn'),
				'desc'     => esc_html__('This is the description field, again good for additional info.', 'your-project-name'),
				'default'  => array(
					'border-color'  => '', 
					'border-style'  => '', 
					'border-top'    => '', 
					'border-right'  => '', 
					'border-bottom' => '', 
					'border-left'   => ''
				),
				'required' => array('show_header_two_button_typography','=', 1),
            ),
            array(
                'id'       => 'header_two_btn_padding',
                'type'     => 'spacing',
                'mode'     => 'padding',
                'title'    => esc_html__('Button Padding Option', 'advkt-toolkit'),
                'output'   => array('.header-area.style-2 .header-top .header-social-wrapper .btn-wrapper .theme-btn'),
                'units'    => 'px',
                'default'  => array(
                    'padding-top'    => '',
                    'padding-right'  => '',
                    'padding-bottom' => '',
                    'padding-left'   => '',
                ),
				'required' => array('show_header_two_button_typography','=', 1),
            ),

			// array(
			// 	'id'   =>'header_top_2',
			// 	'type' => 'divide'
			// ),
			array(
				'id'       => 'show_header_three_button_typography',
				'type'     => 'switch', 
				'title'    => esc_html__('Header Style 3 : Show Button Typography', 'advkt-toolkit'),
				'default'  => false,
			),
			array(
				'id'             => 'header_three_btn_Typography',
				'type'           => 'typography',
				'title'          => esc_html__('Button Typography', 'advkt-toolkit'),
				'google'         => true,
				'text-align'     => false,
				'text-transform' => true,
				'color'          => false,
				'line-height'    => true,
				'letter-spacing' => true,
				'all_styles'     => true,
				'preview'        => array('text'),
				'output'         => array('.header-area.style-3 .header-cta-btn .cta-btn-wrapper .cta-btn'),
				'compiler'       => array('.header-area.style-3 .header-cta-btn .cta-btn-wrapper .cta-btn'),
				'units'          => 'px',
				'default'        => array(
					'font-size'   => '',
					'font-family' => '',
					'font-weight' => '',
					'line-height' => '',
					'color'		=> '',
					'google'      => true
				),
				'required' => array('show_header_three_button_typography','=', 1),
			),
			array(
					'id'       => 'header_three_btn_color',
					'type'     => 'color',
					'title'    => esc_html__('Button Normal Color', 'advkt-toolkit'), 
					'default'  => '',
					'output'   => array('.header-area.style-3 .header-cta-btn .cta-btn-wrapper .cta-btn'),
					'transparent' => false,
					'required' => array('show_header_three_button_typography','=', 1),
			),
			array(
				'id'       => 'header_three_btn_hover_color',
				'type'     => 'color',
				'title'    => esc_html__('Button Hover Color', 'advkt-toolkit'), 
				'default'  => '',
				'output'   => array('.header-area.style-3 .header-cta-btn .cta-btn-wrapper .cta-btn:hover'),
				'transparent' => false,
				'required' => array('show_header_three_button_typography','=', 1),
			),
			array(
				'id'       => 'header_three_btn_background_color',
				'type'     => 'background',
				'title'    => esc_html__('Button Background Color', 'advkt-toolkit'), 
				'output'   => array('.header-area.style-3 .header-cta-btn .cta-btn-wrapper .cta-btn'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'default'  => array(
					'background-color' => '',
				),
				'required' => array('show_header_three_button_typography','=', 1),
			),
			array(
				'id'       => 'header_three_btn_background_hover_color',
				'type'     => 'background',
				'title'    => esc_html__('Button Background Hover Color', 'advkt-toolkit'), 
				'output'   => array('.header-area.style-3 .header-cta-btn .cta-btn-wrapper .cta-btn:hover'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'default'  => array(
					'background-color' => '',
				),
				'required' => array('show_header_three_button_typography','=', 1),
			),
            array(
                'id'       => 'header_three_btn_border',
				'type'     => 'border',
				'title'    => esc_html__('Button Border Option', 'your-project-name'),
				'subtitle' => esc_html__('Only color validation can be done on this field type', 'your-project-name'),
				'output'   => array('.header-area.style-3 .header-cta-btn .cta-btn-wrapper .cta-btn'),
				'desc'     => esc_html__('This is the description field, again good for additional info.', 'your-project-name'),
				'default'  => array(
					'border-color'  => '', 
					'border-style'  => '', 
					'border-top'    => '', 
					'border-right'  => '', 
					'border-bottom' => '', 
					'border-left'   => ''
				),
				'required' => array('show_header_three_button_typography','=', 1),
            ),
            array(
                'id'       => 'header_three_btn_padding',
                'type'     => 'spacing',
                'mode'     => 'padding',
                'title'    => esc_html__('Button Padding Option', 'advkt-toolkit'),
                'output'   => array('.header-area.style-3 .header-cta-btn .cta-btn-wrapper .cta-btn'),
                'units'    => 'px',
                'default'  => array(
                    'padding-top'    => '',
                    'padding-right'  => '',
                    'padding-bottom' => '',
                    'padding-left'   => '',
                ),
				'required' => array('show_header_three_button_typography','=', 1),
            ),
			
		),
	)
);

Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Phone Typography', 'advkt-toolkit' ),
		'id'               => 'header_top_phone_typography_setting',
		'subsection'       => true,
		'customizer_width' => '450px',
		'fields'           => array(
			array(
				'id'       => 'show_header_one_phone_typography',
				'type'     => 'switch', 
				'title'    => esc_html__('Header Style 1 : Show Phone Typography', 'advkt-toolkit'),
				'default'  => false,
			),
			array(
				'id'             => 'header_phone_Typography',
				'type'           => 'typography',
				'title'          => esc_html__('Phone Typography', 'advkt-toolkit'),
				'google'         => true,
				'text-align'     => false,
				'text-transform' => true,
				'color'          => false,
				'line-height'    => true,
				'letter-spacing' => true,
				'all_styles'     => true,
				'preview'        => array('text'),
				'output'         => array('.header-area.style-1 .ct-header-btn .content-wrapper .text'),
				'compiler'       => array('.header-area.style-1 .ct-header-btn .content-wrapper .text'),
				'units'          => 'px',
				'default'        => array(
					'font-size'   => '',
					'font-family' => '',
					'font-weight' => '',
					'line-height' => '',
					'color'		=> '',
					'google'      => true
				),
				'required' => array('show_header_one_phone_typography','=', 1),
			),
			array(
					'id'       => 'header_phone_color',
					'type'     => 'color',
					'title'    => esc_html__('Phone Normal Color', 'advkt-toolkit'), 
					'default'  => '',
					'output'   => array('.header-area.style-1 .ct-header-btn .content-wrapper .text'),
					'transparent' => false,
					'required' => array('show_header_one_phone_typography','=', 1),
			),
			array(
				'id'       => 'header_phone_hover_color',
				'type'     => 'color',
				'title'    => esc_html__('Phone Hover Color', 'advkt-toolkit'), 
				'default'  => '',
				'output'   => array('.header-area.style-1 .ct-header-btn .content-wrapper .text:hover'),
				'transparent' => false,
				'required' => array('show_header_one_phone_typography','=', 1),
			),
			array(
				'id'       => 'header_phone_background_color',
				'type'     => 'background',
				'title'    => esc_html__('Phone Background Color', 'advkt-toolkit'), 
				'output'   => array('.header-area.style-1 .ct-header-btn .content-wrapper .text'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'default'  => array(
					'background-color' => '',
				),
				'required' => array('show_header_one_phone_typography','=', 1),
			),
			array(
				'id'       => 'header_phone_background_hover_color',
				'type'     => 'background',
				'title'    => esc_html__('Button Background Hover Color', 'advkt-toolkit'), 
				'output'   => array('.header-area.style-1 .ct-header-btn .content-wrapper .text:hover'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'default'  => array(
					'background-color' => '',
				),
				'required' => array('show_header_one_phone_typography','=', 1),
			),
            array(
                'id'       => 'header_phone_border',
				'type'     => 'border',
				'title'    => esc_html__('Phone Border Option', 'your-project-name'),
				'subtitle' => esc_html__('Only color validation can be done on this field type', 'your-project-name'),
				'output'   => array('.header-area.style-1 .ct-header-btn .content-wrapper .text'),
				'desc'     => esc_html__('This is the description field, again good for additional info.', 'your-project-name'),
				'default'  => array(
					'border-color'  => '', 
					'border-style'  => '', 
					'border-top'    => '', 
					'border-right'  => '', 
					'border-bottom' => '', 
					'border-left'   => ''
				),
				'required' => array('show_header_one_phone_typography','=', 1),
            ),
            array(
                'id'       => 'header_phone_padding',
                'type'     => 'spacing',
                'mode'     => 'padding',
                'title'    => esc_html__('Phone Padding Option', 'advkt-toolkit'),
                'output'   => array('.header-area.style-1 .ct-header-btn .content-wrapper .text'),
                'units'    => 'px',
                'default'  => array(
                    'padding-top'    => '',
                    'padding-right'  => '',
                    'padding-bottom' => '',
                    'padding-left'   => '',
                ),
				'required' => array('show_header_one_phone_typography','=', 1),
            ),
			// array(
			// 	'id'   =>'header_top_1',
			// 	'type' => 'divide'
			// ),
			array(
				'id'       => 'show_header_two_phone_typography',
				'type'     => 'switch', 
				'title'    => esc_html__('Header Style 2 : Show Phone Typography', 'advkt-toolkit'),
				'default'  => false,
			),
			array(
				'id'             => 'header_two_phone_Typography',
				'type'           => 'typography',
				'title'          => esc_html__('Phone Typography', 'advkt-toolkit'),
				'google'         => true,
				'text-align'     => false,
				'text-transform' => true,
				'color'          => false,
				'line-height'    => true,
				'letter-spacing' => true,
				'all_styles'     => true,
				'preview'        => array('text'),
				'output'         => array('.header-area .header-cta-btn .phone-number-wrapper .telephone-number'),
				'compiler'       => array('.header-area .header-cta-btn .phone-number-wrapper .telephone-number'),
				'units'          => 'px',
				'default'        => array(
					'font-size'   => '',
					'font-family' => '',
					'font-weight' => '',
					'line-height' => '',
					'color'		=> '',
					'google'      => true
				),
				'required' => array('show_header_two_phone_typography','=', 1),
			),
			array(
					'id'       => 'header_two_phone_color',
					'type'     => 'color',
					'title'    => esc_html__('Phone Normal Color', 'advkt-toolkit'), 
					'default'  => '',
					'output'   => array('.header-area .header-cta-btn .phone-number-wrapper .telephone-number'),
					'transparent' => false,
					'required' => array('show_header_two_phone_typography','=', 1),
			),
			array(
				'id'       => 'header_two_phone_hover_color',
				'type'     => 'color',
				'title'    => esc_html__('Phone Hover Color', 'advkt-toolkit'), 
				'default'  => '',
				'output'   => array('.header-area .header-cta-btn .phone-number-wrapper .telephone-number:hover'),
				'transparent' => false,
				'required' => array('show_header_two_phone_typography','=', 1),
			),
			array(
				'id'       => 'header_two_phone_background_color',
				'type'     => 'background',
				'title'    => esc_html__('Phone Background Color', 'advkt-toolkit'), 
				'output'   => array('.header-area .header-cta-btn .phone-number-wrapper .telephone-number'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'default'  => array(
					'background-color' => '',
				),
				'required' => array('show_header_two_phone_typography','=', 1),
			),
			array(
				'id'       => 'header_two_phone_background_hover_color',
				'type'     => 'background',
				'title'    => esc_html__('Phone Background Hover Color', 'advkt-toolkit'), 
				'output'   => array('.header-area .header-cta-btn .phone-number-wrapper .telephone-number:hover'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'default'  => array(
					'background-color' => '',
				),
				'required' => array('show_header_two_phone_typography','=', 1),
			),
            array(
                'id'       => 'header_two_phone_border',
				'type'     => 'border',
				'title'    => esc_html__('Phone Border Option', 'your-project-name'),
				'subtitle' => esc_html__('Only color validation can be done on this field type', 'your-project-name'),
				'output'   => array('.header-area .header-cta-btn .phone-number-wrapper .telephone-number'),
				'desc'     => esc_html__('This is the description field, again good for additional info.', 'your-project-name'),
				'default'  => array(
					'border-color'  => '', 
					'border-style'  => '', 
					'border-top'    => '', 
					'border-right'  => '', 
					'border-bottom' => '', 
					'border-left'   => ''
				),
				'required' => array('show_header_two_phone_typography','=', 1),
            ),
            array(
                'id'       => 'header_two_phone_padding',
                'type'     => 'spacing',
                'mode'     => 'padding',
                'title'    => esc_html__('Phone Padding Option', 'advkt-toolkit'),
                'output'   => array('.header-area .header-cta-btn .phone-number-wrapper .telephone-number'),
                'units'    => 'px',
                'default'  => array(
                    'padding-top'    => '',
                    'padding-right'  => '',
                    'padding-bottom' => '',
                    'padding-left'   => '',
                ),
				'required' => array('show_header_two_phone_typography','=', 1),
            ),
			array(
				'id'             => 'header_two_phone_label_typography',
				'type'           => 'typography',
				'title'          => esc_html__('Phone Label Typography', 'advkt-toolkit'),
				'google'         => true,
				'text-align'     => false,
				'text-transform' => true,
				'color'          => false,
				'line-height'    => true,
				'letter-spacing' => true,
				'all_styles'     => true,
				'preview'        => array('text'),
				'output'         => array('.header-area.style-2 .header-cta-btn .phone-number-wrapper .text'),
				'compiler'       => array('.header-area.style-2 .header-cta-btn .phone-number-wrapper .text'),
				'units'          => 'px',
				'default'        => array(
					'font-size'   => '',
					'font-family' => '',
					'font-weight' => '',
					'line-height' => '',
					'color'		=> '',
					'google'      => true
				),
				'required' => array('show_header_two_phone_typography','=', 1),
			),
			array(
					'id'       => 'header_two_phone_label_color',
					'type'     => 'color',
					'title'    => esc_html__('Phone Label Color', 'advkt-toolkit'), 
					'default'  => '',
					'output'   => array('.header-area.style-2 .header-cta-btn .phone-number-wrapper .text'),
					'transparent' => false,
					'required' => array('show_header_two_phone_typography','=', 1),
			),



			// array(
			// 	'id'   =>'header_top_2',
			// 	'type' => 'divide'
			// ),

			array(
				'id'       => 'show_header_two_emergency_phone_typography',
				'type'     => 'switch', 
				'title'    => esc_html__('Header Style 2 : Show Emergency Phone Typography', 'advkt-toolkit'),
				'default'  => false,
			),
			array(
				'id'             => 'header_two_emergency_phone_Typography',
				'type'           => 'typography',
				'title'          => esc_html__('Phone Typography', 'advkt-toolkit'),
				'google'         => true,
				'text-align'     => false,
				'text-transform' => true,
				'color'          => false,
				'line-height'    => true,
				'letter-spacing' => true,
				'all_styles'     => true,
				'preview'        => array('text'),
				'output'         => array('.header-area.style-2 .header-wrapper .header-top .header-contact-info .contact-info-item a.number'),
				'compiler'       => array('.header-area.style-2 .header-wrapper .header-top .header-contact-info .contact-info-item a.number'),
				'units'          => 'px',
				'default'        => array(
					'font-size'   => '',
					'font-family' => '',
					'font-weight' => '',
					'line-height' => '',
					'color'		=> '',
					'google'      => true
				),
				'required' => array('show_header_two_emergency_phone_typography','=', 1),
			),
			array(
					'id'       => 'header_two_emergency_phone_color',
					'type'     => 'color',
					'title'    => esc_html__('Phone Normal Color', 'advkt-toolkit'), 
					'default'  => '',
					'output'   => array('.header-area.style-2 .header-wrapper .header-top .header-contact-info .contact-info-item a.number'),
					'transparent' => false,
					'required' => array('show_header_two_emergency_phone_typography','=', 1),
			),
			array(
				'id'       => 'header_two_emergency_phone_hover_color',
				'type'     => 'color',
				'title'    => esc_html__('Phone Hover Color', 'advkt-toolkit'), 
				'default'  => '',
				'output'   => array('.header-area.style-2 .header-wrapper .header-top .header-contact-info .contact-info-item a.number:hover'),
				'transparent' => false,
				'required' => array('show_header_two_emergency_phone_typography','=', 1),
			),
			array(
				'id'       => 'header_two_emergency_phone_background_color',
				'type'     => 'background',
				'title'    => esc_html__('Phone Background Color', 'advkt-toolkit'), 
				'output'   => array('.header-area.style-2 .header-wrapper .header-top .header-contact-info .contact-info-item a.number'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'default'  => array(
					'background-color' => '',
				),
				'required' => array('show_header_two_emergency_phone_typography','=', 1),
			),
			array(
				'id'       => 'header_two_emergency_phone_background_hover_color',
				'type'     => 'background',
				'title'    => esc_html__('Phone Background Hover Color', 'advkt-toolkit'), 
				'output'   => array('.header-area.style-2 .header-wrapper .header-top .header-contact-info .contact-info-item a.number:hover'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'default'  => array(
					'background-color' => '',
				),
				'required' => array('show_header_two_emergency_phone_typography','=', 1),
			),
            array(
                'id'       => 'header_two_emergency_phone_border',
				'type'     => 'border',
				'title'    => esc_html__('Phone Border Option', 'your-project-name'),
				'subtitle' => esc_html__('Only color validation can be done on this field type', 'your-project-name'),
				'output'   => array('.header-area.style-2 .header-wrapper .header-top .header-contact-info .contact-info-item a.number'),
				'desc'     => esc_html__('This is the description field, again good for additional info.', 'your-project-name'),
				'default'  => array(
					'border-color'  => '', 
					'border-style'  => '', 
					'border-top'    => '', 
					'border-right'  => '', 
					'border-bottom' => '', 
					'border-left'   => ''
				),
				'required' => array('show_header_two_emergency_phone_typography','=', 1),
            ),
            array(
                'id'       => 'header_two_emergency_phone_padding',
                'type'     => 'spacing',
                'mode'     => 'padding',
                'title'    => esc_html__('Phone Padding Option', 'advkt-toolkit'),
                'output'   => array('.header-area.style-2 .header-wrapper .header-top .header-contact-info .contact-info-item a.number'),
                'units'    => 'px',
                'default'  => array(
                    'padding-top'    => '',
                    'padding-right'  => '',
                    'padding-bottom' => '',
                    'padding-left'   => '',
                ),
				'required' => array('show_header_two_emergency_phone_typography','=', 1),
            ),
			array(
				'id'             => 'header_two_emergency_phone_label_typography',
				'type'           => 'typography',
				'title'          => esc_html__('Phone Label Typography', 'advkt-toolkit'),
				'google'         => true,
				'text-align'     => false,
				'text-transform' => true,
				'color'          => false,
				'line-height'    => true,
				'letter-spacing' => true,
				'all_styles'     => true,
				'preview'        => array('text'),
				'output'         => array('.header-area.style-2 .header-wrapper .header-top .header-contact-info .contact-info-item .label'),
				'compiler'       => array('.header-area.style-2 .header-wrapper .header-top .header-contact-info .contact-info-item .label'),
				'units'          => 'px',
				'default'        => array(
					'font-size'   => '',
					'font-family' => '',
					'font-weight' => '',
					'line-height' => '',
					'color'		=> '',
					'google'      => true
				),
				'required' => array('show_header_two_emergency_phone_typography','=', 1),
			),
			array(
					'id'       => 'header_two_emergency_phone_label_color',
					'type'     => 'color',
					'title'    => esc_html__('Phone Label Color', 'advkt-toolkit'), 
					'default'  => '',
					'output'   => array('.header-area.style-2 .header-wrapper .header-top .header-contact-info .contact-info-item .label'),
					'transparent' => false,
					'required' => array('show_header_two_emergency_phone_typography','=', 1),
			),
			array(
					'id'       => 'header_two_emergency_phone_icon_color',
					'type'     => 'color',
					'title'    => esc_html__('Phone Icon Color', 'advkt-toolkit'), 
					'default'  => '',
					'output'   => array('.header-area.style-2 .header-wrapper .header-top .header-contact-info .contact-info-item .phone.icon'),
					'transparent' => false,
					'required' => array('show_header_two_emergency_phone_typography','=', 1),
			),



			// array(
			// 	'id'   =>'header_top_3',
			// 	'type' => 'divide'
			// ),
			array(
				'id'       => 'show_header_three_phone_typography',
				'type'     => 'switch', 
				'title'    => esc_html__('Header Style 3 : Show Phone Typography', 'advkt-toolkit'),
				'default'  => false,
			),
			array(
				'id'             => 'header_three_phone_Typography',
				'type'           => 'typography',
				'title'          => esc_html__('Phone Typography', 'advkt-toolkit'),
				'google'         => true,
				'text-align'     => false,
				'text-transform' => true,
				'color'          => false,
				'line-height'    => true,
				'letter-spacing' => true,
				'all_styles'     => true,
				'preview'        => array('text'),
				'output'         => array('.header-area .header-cta-btn .phone-number-wrapper .telephone-number'),
				'compiler'       => array('.header-area .header-cta-btn .phone-number-wrapper .telephone-number'),
				'units'          => 'px',
				'default'        => array(
					'font-size'   => '',
					'font-family' => '',
					'font-weight' => '',
					'line-height' => '',
					'color'		=> '',
					'google'      => true
				),
				'required' => array('show_header_three_phone_typography','=', 1),
			),
			array(
					'id'       => 'header_three_phone_color',
					'type'     => 'color',
					'title'    => esc_html__('Phone Normal Color', 'advkt-toolkit'), 
					'default'  => '',
					'output'   => array('.header-area .header-cta-btn .phone-number-wrapper .telephone-number'),
					'transparent' => false,
					'required' => array('show_header_three_phone_typography','=', 1),
			),
			array(
				'id'       => 'header_three_phone_hover_color',
				'type'     => 'color',
				'title'    => esc_html__('Phone Hover Color', 'advkt-toolkit'), 
				'default'  => '',
				'output'   => array('.header-area .header-cta-btn .phone-number-wrapper .telephone-number:hover'),
				'transparent' => false,
				'required' => array('show_header_three_phone_typography','=', 1),
			),
			array(
				'id'       => 'header_three_phone_background_color',
				'type'     => 'background',
				'title'    => esc_html__('Phone Background Color', 'advkt-toolkit'), 
				'output'   => array('.header-area .header-cta-btn .phone-number-wrapper .telephone-number'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'default'  => array(
					'background-color' => '',
				),
				'required' => array('show_header_three_phone_typography','=', 1),
			),
			array(
				'id'       => 'header_three_phone_background_hover_color',
				'type'     => 'background',
				'title'    => esc_html__('Phone Background Hover Color', 'advkt-toolkit'), 
				'output'   => array('.header-area .header-cta-btn .phone-number-wrapper .telephone-number:hover'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'default'  => array(
					'background-color' => '',
				),
				'required' => array('show_header_three_phone_typography','=', 1),
			),
            array(
                'id'       => 'header_three_phone_border',
				'type'     => 'border',
				'title'    => esc_html__('Phone Border Option', 'your-project-name'),
				'subtitle' => esc_html__('Only color validation can be done on this field type', 'your-project-name'),
				'output'   => array('.header-area .header-cta-btn .phone-number-wrapper .telephone-number'),
				'desc'     => esc_html__('This is the description field, again good for additional info.', 'your-project-name'),
				'default'  => array(
					'border-color'  => '', 
					'border-style'  => '', 
					'border-top'    => '', 
					'border-right'  => '', 
					'border-bottom' => '', 
					'border-left'   => ''
				),
				'required' => array('show_header_three_phone_typography','=', 1),
            ),
            array(
                'id'       => 'header_three_phone_padding',
                'type'     => 'spacing',
                'mode'     => 'padding',
                'title'    => esc_html__('Phone Padding Option', 'advkt-toolkit'),
                'output'   => array('.header-area .header-cta-btn .phone-number-wrapper .telephone-number'),
                'units'    => 'px',
                'default'  => array(
                    'padding-top'    => '',
                    'padding-right'  => '',
                    'padding-bottom' => '',
                    'padding-left'   => '',
                ),
				'required' => array('show_header_three_phone_typography','=', 1),
            ),
			array(
				'id'             => 'header_three_phone_label_typography',
				'type'           => 'typography',
				'title'          => esc_html__('Phone Label Typography', 'advkt-toolkit'),
				'google'         => true,
				'text-align'     => false,
				'text-transform' => true,
				'color'          => false,
				'line-height'    => true,
				'letter-spacing' => true,
				'all_styles'     => true,
				'preview'        => array('text'),
				'output'         => array('.header-area.style-2 .header-cta-btn .phone-number-wrapper .text'),
				'compiler'       => array('.header-area.style-2 .header-cta-btn .phone-number-wrapper .text'),
				'units'          => 'px',
				'default'        => array(
					'font-size'   => '',
					'font-family' => '',
					'font-weight' => '',
					'line-height' => '',
					'color'		=> '',
					'google'      => true
				),
				'required' => array('show_header_three_phone_typography','=', 1),
			),
			array(
					'id'       => 'header_three_phone_label_color',
					'type'     => 'color',
					'title'    => esc_html__('Phone Label Color', 'advkt-toolkit'), 
					'default'  => '',
					'output'   => array('.header-area.style-2 .header-cta-btn .phone-number-wrapper .text'),
					'transparent' => false,
					'required' => array('show_header_three_phone_typography','=', 1),
			),


			// array(
			// 	'id'   =>'header_top_4',
			// 	'type' => 'divide'
			// ),

			array(
				'id'       => 'show_header_three_emergency_phone_typography',
				'type'     => 'switch', 
				'title'    => esc_html__('Header Style 3 : Show Emergency Phone Typography', 'advkt-toolkit'),
				'default'  => false,
			),
			array(
				'id'             => 'header_three_emergency_phone_Typography',
				'type'           => 'typography',
				'title'          => esc_html__('Phone Typography', 'advkt-toolkit'),
				'google'         => true,
				'text-align'     => false,
				'text-transform' => true,
				'color'          => false,
				'line-height'    => true,
				'letter-spacing' => true,
				'all_styles'     => true,
				'preview'        => array('text'),
				'output'         => array('.header-area.style-2 .header-wrapper .header-top .header-contact-info .contact-info-item a.number'),
				'compiler'       => array('.header-area.style-2 .header-wrapper .header-top .header-contact-info .contact-info-item a.number'),
				'units'          => 'px',
				'default'        => array(
					'font-size'   => '',
					'font-family' => '',
					'font-weight' => '',
					'line-height' => '',
					'color'		=> '',
					'google'      => true
				),
				'required' => array('show_header_three_emergency_phone_typography','=', 1),
			),
			array(
					'id'       => 'header_three_emergency_phone_color',
					'type'     => 'color',
					'title'    => esc_html__('Phone Normal Color', 'advkt-toolkit'), 
					'default'  => '',
					'output'   => array('.header-area.style-2 .header-wrapper .header-top .header-contact-info .contact-info-item a.number'),
					'transparent' => false,
					'required' => array('show_header_three_emergency_phone_typography','=', 1),
			),
			array(
				'id'       => 'header_three_emergency_phone_hover_color',
				'type'     => 'color',
				'title'    => esc_html__('Phone Hover Color', 'advkt-toolkit'), 
				'default'  => '',
				'output'   => array('.header-area.style-2 .header-wrapper .header-top .header-contact-info .contact-info-item a.number:hover'),
				'transparent' => false,
				'required' => array('show_header_three_emergency_phone_typography','=', 1),
			),
			array(
				'id'       => 'header_three_emergency_phone_background_color',
				'type'     => 'background',
				'title'    => esc_html__('Phone Background Color', 'advkt-toolkit'), 
				'output'   => array('.header-area.style-2 .header-wrapper .header-top .header-contact-info .contact-info-item a.number'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'default'  => array(
					'background-color' => '',
				),
				'required' => array('show_header_three_emergency_phone_typography','=', 1),
			),
			array(
				'id'       => 'header_three_emergency_phone_background_hover_color',
				'type'     => 'background',
				'title'    => esc_html__('Phone Background Hover Color', 'advkt-toolkit'), 
				'output'   => array('.header-area.style-2 .header-wrapper .header-top .header-contact-info .contact-info-item a.number:hover'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'default'  => array(
					'background-color' => '',
				),
				'required' => array('show_header_three_emergency_phone_typography','=', 1),
			),
            array(
                'id'       => 'header_three_emergency_phone_border',
				'type'     => 'border',
				'title'    => esc_html__('Phone Border Option', 'your-project-name'),
				'subtitle' => esc_html__('Only color validation can be done on this field type', 'your-project-name'),
				'output'   => array('.header-area.style-2 .header-wrapper .header-top .header-contact-info .contact-info-item a.number'),
				'desc'     => esc_html__('This is the description field, again good for additional info.', 'your-project-name'),
				'default'  => array(
					'border-color'  => '', 
					'border-style'  => '', 
					'border-top'    => '', 
					'border-right'  => '', 
					'border-bottom' => '', 
					'border-left'   => ''
				),
				'required' => array('show_header_three_emergency_phone_typography','=', 1),
            ),
            array(
                'id'       => 'header_three_emergency_phone_padding',
                'type'     => 'spacing',
                'mode'     => 'padding',
                'title'    => esc_html__('Phone Padding Option', 'advkt-toolkit'),
                'output'   => array('.header-area.style-2 .header-wrapper .header-top .header-contact-info .contact-info-item a.number'),
                'units'    => 'px',
                'default'  => array(
                    'padding-top'    => '',
                    'padding-right'  => '',
                    'padding-bottom' => '',
                    'padding-left'   => '',
                ),
				'required' => array('show_header_three_emergency_phone_typography','=', 1),
            ),
			array(
				'id'             => 'header_three_emergency_phone_label_typography',
				'type'           => 'typography',
				'title'          => esc_html__('Phone Label Typography', 'advkt-toolkit'),
				'google'         => true,
				'text-align'     => false,
				'text-transform' => true,
				'color'          => false,
				'line-height'    => true,
				'letter-spacing' => true,
				'all_styles'     => true,
				'preview'        => array('text'),
				'output'         => array('.header-area.style-2 .header-wrapper .header-top .header-contact-info .contact-info-item .label'),
				'compiler'       => array('.header-area.style-2 .header-wrapper .header-top .header-contact-info .contact-info-item .label'),
				'units'          => 'px',
				'default'        => array(
					'font-size'   => '',
					'font-family' => '',
					'font-weight' => '',
					'line-height' => '',
					'color'		=> '',
					'google'      => true
				),
				'required' => array('show_header_three_emergency_phone_typography','=', 1),
			),
			array(
					'id'       => 'header_three_emergency_phone_label_color',
					'type'     => 'color',
					'title'    => esc_html__('Phone Label Color', 'advkt-toolkit'), 
					'default'  => '',
					'output'   => array('.header-area.style-2 .header-wrapper .header-top .header-contact-info .contact-info-item .label'),
					'transparent' => false,
					'required' => array('show_header_three_emergency_phone_typography','=', 1),
			),
			array(
					'id'       => 'header_three_emergency_phone_icon_color',
					'type'     => 'color',
					'title'    => esc_html__('Phone Icon Color', 'advkt-toolkit'), 
					'default'  => '',
					'output'   => array('.header-area.style-2 .header-wrapper .header-top .header-contact-info .contact-info-item .phone.icon'),
					'transparent' => false,
					'required' => array('show_header_three_emergency_phone_typography','=', 1),
			),
			
		),
	)
);

Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Breadcrumb Setting', 'advkt-toolkit' ),
		'id'               => 'breadcrumb_setting',
		'customizer_width' => '450px',
		'fields'           => array(
			array(
				'id'       => 'choose_default_breadcrumb',
				'type'     => 'select',
				'title'    => esc_html__('Choose Breadcrumb Style', 'advkt-toolkit'), 
				'options'  => array(
					'1' => esc_html__( 'Breadcrumb Style 1', 'advkt-toolkit' ),
				),
				'default'  => '1',
			),
			array(
				'id'       => 'advkt_breadcrumb_bg__color',
				'type'     => 'color',
				'title'    => esc_html__('Breadcrumb BG Color', 'advkt-toolkit'), 
				'default'  => '',
				'transparent' => false,
			),
			array(
				'id'       => 'breadcrumb_bg_img',
				'type'     => 'media', 
				'url'      => false,
				'title'    => esc_html__('Breadcrumb Background Image', 'advkt-toolkit'),
            ),
			array(
				'id'       => 'breadcrumb_left_shape_img',
				'type'     => 'media', 
				'url'      => false,
				'title'    => esc_html__('Breadcrumb Left Shape Image', 'advkt-toolkit'),
            ),
			array(
				'id'       => 'breadcrumb_right_shape_img',
				'type'     => 'media', 
				'url'      => false,
				'title'    => esc_html__('Breadcrumb Right Shape Image', 'advkt-toolkit'),
            ),
			array(
				'id'       => 'breadcrumb_archive',
				'type'     => 'text',
				'title'    => esc_html__('Breadcrumb Archive','advkt-toolkit'),
				'default' => esc_html__('Archive for category','advkt-toolkit'),
            ),
			array(
				'id'       => 'breadcrumb_search',
				'type'     => 'text',
				'title'    => esc_html__('Breadcrumb Search','advkt-toolkit'),
				'default' => esc_html__('Search results for','advkt-toolkit'),
            ),
			array(
				'id'       => 'breadcrumb_post_tags',
				'type'     => 'text',
				'title'    => esc_html__('Breadcrumb tagged','advkt-toolkit'),
				'default' => esc_html__('Posts tagged','advkt-toolkit'),
            ),
			array(
				'id'       => 'breadcrumb_artitle_post_by',
				'type'     => 'text',
				'title'    => esc_html__('Breadcrumb posted by','advkt-toolkit'),
				'default' => esc_html__('Articles posted by','advkt-toolkit'),
            ),
			array(
				'id'       => 'breadcrumb_404',
				'type'     => 'text',
				'title'    => esc_html__('Breadcrumb Page Not Found','advkt-toolkit'),
				'default' => esc_html__('Page Not Found','advkt-toolkit'),
            ),
			array(
				'id'       => 'breadcrumb_page',
				'type'     => 'text',
				'title'    => esc_html__('Breadcrumb Page','advkt-toolkit'),
				'default' => esc_html__('Page','advkt-toolkit'),
            ),
			array(
				'id'       => 'breadcrumb_home',
				'type'     => 'text',
				'title'    => esc_html__('Breadcrumb Home','advkt-toolkit'),
				'default' => esc_html__('Home','advkt-toolkit'),
            ),
			array(
				'id'             => 'breadcrumb_page_title_typography',
				'type'           => 'typography',
				'title'          => esc_html__('Page Title Typography', 'advkt-toolkit'),
				'google'         => true,
				'text-align'     => false,
				'text-transform' => true,
				'color'          => true,
				'line-height'    => true,
				'letter-spacing' => true,
				'all_styles'     => true,
				'preview'        => array('text'),
				'output'         => array('.page-template .breadcrumb-wrapper .page-title'),
				'compiler'       => array('.page-template .breadcrumb-wrapper .page-title'),
				'units'          => 'px',
				'default'        => array(
					'google'      => true
				),
			),
			array(
				'id'             => 'breadcrumb_list_typography',
				'type'           => 'typography',
				'title'          => esc_html__('Breadcrumb List Typography', 'advkt-toolkit'),
				'google'         => true,
				'text-align'     => false,
				'text-transform' => true,
				'color'          => true,
				'line-height'    => true,
				'letter-spacing' => true,
				'all_styles'     => true,
				'preview'        => array('text'),
				'output'         => array('.page-template .breadcrumb-list ul li a'),
				'compiler'       => array('.page-template .breadcrumb-list ul li a'),
				'units'          => 'px',
				'default'        => array(
					'google'      => true
				),
			),
		),
	)
);

Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Blog Setting', 'advkt-toolkit' ),
		'id'               => 'blog_setting',
		'customizer_width' => '450px',
		'fields'           => array(
			array(
				'id'       => 'advkt_blog_btn_switch',
				'type'     => 'switch', 
				'title'    => esc_html__('Show Button', 'advkt-toolkit'),
				'default'  => false,
			),
			array(
				'id'       => 'advkt_blog_btn',
				'type'     => 'text',
				'title'    => esc_html__('Blog Button text','advkt-toolkit'),
				'default' => esc_html__('Read More','advkt-toolkit'),
				'required' => array('advkt_blog_btn_switch','=', 1),
            ),
			array(
				'id'       => 'advkt_blog_btn_icon_switch',
				'type'     => 'switch', 
				'title'    => esc_html__('Show Button Icon', 'advkt-toolkit'),
				'default'  => false,
				'required' => array('advkt_blog_btn_switch','=', 1),
			),

			array(
				'id'       => 'advkt_blog_btn_icon',
				'type'     => 'text',
				'title'    => esc_html__('Button Icon','advkt-toolkit'),
				'default' => esc_html__('fa-solid fa-angle-right','advkt-toolkit'),
				'required' => array('advkt_blog_btn_icon_switch','=', 1),
            ),
			array(
				'id'       => 'show_blog_social_share',
				'type'     => 'switch', 
				'title'    => esc_html__('Show Social Share', 'advkt-toolkit'),
				'default'  => false,
				'required' => array('advkt_blog_btn_switch','=', 1),
			),
			array(
				'id'             => 'advkt_blog_btn_Typography',
				'type'           => 'typography',
				'title'          => esc_html__('Button Typography', 'advkt-toolkit'),
				'google'         => true,
				'text-align'     => false,
				'text-transform' => true,
				'color'          => false,
				'line-height'    => true,
				'letter-spacing' => true,
				'all_styles'     => true,
				'preview'        => array('text'),
				'output'         => array('.blog-btn.theme-btn'),
				'compiler'       => array('.blog-btn.theme-btn'),
				'units'          => 'px',
				'default'        => array(
					'google'      => true
				),
				'required' => array('advkt_blog_btn_switch','=', 1),
			),
			array(
					'id'       => 'advkt_blog_btn_color',
					'type'     => 'color',
					'title'    => esc_html__('Button Normal Color', 'advkt-toolkit'), 
					'default'  => '',
					'output'   => array('.blog-btn.theme-btn'),
					'transparent' => false,
					'required' => array('advkt_blog_btn_switch','=', 1),
			),
			array(
				'id'       => 'advkt_blog_btn_hover_color',
				'type'     => 'color',
				'title'    => esc_html__('Button Hover Color', 'advkt-toolkit'), 
				'default'  => '',
				'output'   => array('.blog-btn.theme-btn:hover'),
				'transparent' => false,
				'required' => array('advkt_blog_btn_switch','=', 1),
			),
			array(
				'id'       => 'advkt_blog_btn_background_color',
				'type'     => 'background',
				'title'    => esc_html__('Button Background Color', 'advkt-toolkit'), 
				'output'   => array('.blog-btn.theme-btn'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'required' => array('advkt_blog_btn_switch','=', 1),
				'default'  => array(
					'background-color' => '',
				)
			),
			array(
				'id'       => 'advkt_blog_btn_background_hover_color',
				'type'     => 'background',
				'title'    => esc_html__('Button Background Hover Color', 'advkt-toolkit'), 
				'output'   => array('.blog-btn.theme-btn:hover'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'required' => array('advkt_blog_btn_switch','=', 1),
				'default'  => array(
					'background-color' => '',
				)
			),
            array(
                'id'       => 'advkt_blog_btn_padding',
                'type'     => 'spacing',
                'mode'     => 'padding',
                'title'    => esc_html__('Button Padding', 'advkt-toolkit'),
                'output'   => array('.blog-btn.theme-btn'),
                'units'    => 'px',
				'required' => array('advkt_blog_btn_switch','=', 1),
                'default'  => array(
                ),
            ),
			array(
				'id'       => 'breadcrumb_blog_title',
				'type'     => 'text',
				'title'    => esc_html__('Blog Title','advkt-toolkit'),
				'default' => esc_html__('Blog','advkt-toolkit'),
            ),
			array(
				'id'       => 'advkt_blog_show_category',
				'type'     => 'switch', 
				'title'    => esc_html__('Show Category', 'advkt-toolkit'),
				'default'  => true,
			),
			array(
				'id'       => 'advkt_blog_show_user',
				'type'     => 'switch', 
				'title'    => esc_html__('Show User', 'advkt-toolkit'),
				'default'  => true,
			),
			array(
				'id'       => 'advkt_blog_show_date',
				'type'     => 'switch', 
				'title'    => esc_html__('Show Date', 'advkt-toolkit'),
				'default'  => true,
			),
			array(
				'id'       => 'advkt_blog_show_comment',
				'type'     => 'switch', 
				'title'    => esc_html__('Show Comment', 'advkt-toolkit'),
				'default'  => false,
			),
		),
	)
);

Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Blog Details Setting', 'advkt-toolkit' ),
		'id'               => 'blog_details_setting',
		'customizer_width' => '450px',
		'fields'           => array(
			array(
				'id'       => 'breadcrumb_blog_title_details',
				'type'     => 'text',
				'title'    => esc_html__('Blog Breadcrumb Details Title','advkt-toolkit'),
				'default' => esc_html__('Blog Details','advkt-toolkit'),
            ),
			array(
				'id'       => 'advkt_bdetails_post_meta_show_user',
				'type'     => 'switch', 
				'title'    => esc_html__('Show User in Post Meta', 'advkt-toolkit'),
				'default'  => true,
			),
			array(
				'id'       => 'advkt_bdetails_post_meta_show_cat',
				'type'     => 'switch', 
				'title'    => esc_html__('Show Category in Post Meta', 'advkt-toolkit'),
				'default'  => false,
			),
			array(
				'id'       => 'advkt_bdetails_post_meta_show_date',
				'type'     => 'switch', 
				'title'    => esc_html__('Show Date in Post Meta', 'advkt-toolkit'),
				'default'  => true,
			),
			array(
				'id'       => 'advkt_bdetails_post_meta_show_comment',
				'type'     => 'switch', 
				'title'    => esc_html__('Show Comment in Post Meta', 'advkt-toolkit'),
				'default'  => true,
			),
			array(
				'id'       => 'advkt_bdetails_show_category',
				'type'     => 'switch', 
				'title'    => esc_html__('Show Category', 'advkt-toolkit'),
				'default'  => true,
			),
			array(
				'id'       => 'advkt_bdetails_show_tag',
				'type'     => 'switch', 
				'title'    => esc_html__('Show Tag', 'advkt-toolkit'),
				'default'  => true,
			),
			array(
				'id'       => 'advkt_bdetails_social_share',
				'type'     => 'switch', 
				'title'    => esc_html__('Show Social Share', 'advkt-toolkit'),
				'default'  => false,
			),
		),
	)
);



/**
 * Font Options Section
 * *******************************************************
 */
Redux::set_section($opt_name, array(
	'icon'   => 'el el-font',
	'title'  => esc_html__('Font Options', 'advkt-toolkit'),
	'desc'   => esc_html__('If you change value in this section, you must "Save & Generate CSS"', 'advkt-toolkit'),
	'fields' => array(
		array(
			'id'             => 'body_font',
			'type'           => 'typography',
			'title'          => esc_html__('Body Font', 'advkt-toolkit'),
			'subtitle'       => esc_html__('organizfy the body font properties.', 'advkt-toolkit'),
			'google'         => true,
			'text-align'     => false,
			'color'          => false,
			'letter-spacing' => false,
			'line-height'    => true,
			'all_styles'     => true,
			'output'         => array('p, p.desc'),
			'compiler'       => array('p, p.desc'),
			'units'          => 'px',
			'default'        => array(
				'google'      => true
			),
		),
		array(
			'id'             => 'h1_font',
			'type'           => 'typography',
			'title'          => esc_html__('H1 Font', 'advkt-toolkit'),
			'subtitle'       => esc_html__('organizfy the H1 font properties.', 'advkt-toolkit'),
			'google'         => true,
			'text-align'     => false,
			'line-height'    => true,
			'color'          => false,
			'letter-spacing' => false,
			'all_styles'     => true,
			'output'         => array('h1, h1.slider-title'),
			'compiler'       => array('h1, h1.slider-title'),
			'units'          => 'px',
			'default'        => array(

			),
		),
		array(
			'id'             => 'h2_font',
			'type'           => 'typography',
			'title'          => esc_html__('H2 Font', 'advkt-toolkit'),
			'subtitle'       => esc_html__('organizfy the H2 font properties.', 'advkt-toolkit'),
			'google'         => true,
			'line-height'    => true,
			'text-align'     => false,
			'color'          => false,
			'letter-spacing' => false,
			'all_styles'     => true,
			'output'         => array('h2, h2.title'),
			'compiler'       => array('h2, h2.title'),
			'units'          => 'px',
			'default'        => array(
			),
		),
		array(
			'id'             => 'h3_font',
			'type'           => 'typography',
			'title'          => esc_html__('H3 Font', 'advkt-toolkit'),
			'subtitle'       => esc_html__('organizfy the H3 font properties.', 'advkt-toolkit'),
			'google'         => true,
			'text-align'     => false,
			'line-height'    => false,
			'color'          => false,
			'letter-spacing' => false,
			'all_styles'     => true,
			'output'         => array('h3, h3. heading-three'),
			'compiler'       => array('h3, h3. heading-three'),
			'units'          => 'px',
			'default'        => array(
			),
		),
		array(
			'id'             => 'h4_font',
			'type'           => 'typography',
			'title'          => esc_html__('H4 Font', 'advkt-toolkit'),
			'subtitle'       => esc_html__('organizfy the H4 font properties.', 'advkt-toolkit'),
			'google'         => true,
			'text-align'     => false,
			'line-height'    => false,
			'color'          => false,
			'letter-spacing' => false,
			'all_styles'     => true,
			'output'         => array('h4, h4.heading-four'),
			'compiler'       => array('h4, h4.heading-four'),
			'units'          => 'px',
			'default'        => array(
			),
		),
		array(
			'id'             => 'h5_font',
			'type'           => 'typography',
			'title'          => esc_html__('H5 Font', 'advkt-toolkit'),
			'subtitle'       => esc_html__('organizfy the H5 font properties.', 'advkt-toolkit'),
			'google'         => true,
			'line-height'    => false,
			'text-align'     => false,
			'color'          => false,
			'letter-spacing' => false,
			'all_styles'     => true,
			'output'         => array('h5, h5.heading-five'),
			'compiler'       => array('h5, h5.heading-five'),
			'units'          => 'px',
			'default'        => array(
			),
		),
		array(
			'id'             => 'h6_font',
			'type'           => 'typography',
			'title'          => esc_html__('H6 Font', 'advkt-toolkit'),
			'subtitle'       => esc_html__('organizfy the H6 font properties.', 'advkt-toolkit'),
			'google'         => true,
			'line-height'    => false,
			'text-align'     => false,
			'color'          => false,
			'letter-spacing' => false,
			'all_styles'     => true,
			'output'         => array('h6, h6.heading-six'),
			'compiler'       => array('h6, h6.heading-six'),
			'units'          => 'px',
			'default'        => array(

			),
		),
	),
));



Redux::set_section(
	$opt_name,
	array(
		'title'            	=> esc_html__( '404 Setting', 'advkt-toolkit' ),
		'id'               	=> '404_setting',
		'customizer_width' 	=> '450px',
		'fields'           	=> array(
			array(
				'id'       	=> 'advkt_error_404_text',
				'type'     	=> 'text',
				'title'    	=> esc_html__('400 Text','advkt-toolkit'),
				'default' 	=> esc_html__('404','advkt-toolkit'),
            ),
			array(
				'id'       	=> 'advkt_error_title',
				'type'     	=> 'text',
				'title'    	=> esc_html__('Not Found Title','advkt-toolkit'),
				'default' 	=> esc_html__('Page not found','advkt-toolkit'),
            ),
			array(
				'id'       	=> 'advkt_error_desc',
				'type'     	=> 'textarea',
				'title'    	=> esc_html__('404 Description Text','advkt-toolkit'),
				'default' 	=> esc_html__('Oops! The page you are looking for does not exist. It might have been moved or deleted','advkt-toolkit'),
            ),
			array(
				'id'       	=> 'advkt_error_link_text',
				'type'     	=> 'text',
				'title'    	=> esc_html__('404 Link Text','advkt-toolkit'),
				'default' 	=> esc_html__('Back To Home','advkt-toolkit'),
            ),
			array(
                'id'       => 'advkt_error_404_section_padding',
                'type'     => 'spacing',
                'mode'     => 'padding',
                'title'    => esc_html__('Section Padding', 'advkt-toolkit'),
                'output'   => array('.error404 .blog-area'),
                'units'    => 'px',
                'default'  => array(

                ),
            ),
			array(
				'id'             => 'advkt_error_404_home_btn_Typography',
				'type'           => 'typography',
				'title'          => esc_html__('Button Typography', 'advkt-toolkit'),
				'google'         => true,
				'text-align'     => false,
				'text-transform' => true,
				'color'          => false,
				'line-height'    => true,
				'letter-spacing' => true,
				'all_styles'     => true,
				'preview'        => array('text'),
				'output'         => array('.error-btn.theme-btn'),
				'compiler'       => array('.error-btn.theme-btn'),
				'units'          => 'px',
				'default'        => array(
					'google'      => true
				),
			),
			array(
					'id'       => 'advkt_error_404_home_btn_color',
					'type'     => 'color',
					'title'    => esc_html__('Button Normal Color', 'advkt-toolkit'), 
					'default'  => '',
					'output'   => array('.error-btn.theme-btn'),
					'transparent' => false,
			),
			array(
				'id'       => 'advkt_error_404_home_btn_hover_color',
				'type'     => 'color',
				'title'    => esc_html__('Button Hover Color', 'advkt-toolkit'), 
				'default'  => '',
				'output'   => array('.error-btn.theme-btn:hover'),
				'transparent' => false,
			),
			array(
				'id'       => 'advkt_error_404_home_btn_background_color',
				'type'     => 'background',
				'title'    => esc_html__('Button Background Color', 'advkt-toolkit'), 
				'output'   => array('.error-btn.theme-btn'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'default'  => array(
					'background-color' => '',
				)
			),
			array(
				'id'       => 'advkt_error_404_home_btn_background_hover_color',
				'type'     => 'background',
				'title'    => esc_html__('Button Background Hover Color', 'advkt-toolkit'), 
				'output'   => array('.error-btn.theme-btn:hover'),
				'transparent' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'background-image' => false,
				'background-size' => false,
				'default'  => array(
					'background-color' => '#141F39',
				)
			),
            array(
                'id'       => 'advkt_error_404_home_btn_padding',
                'type'     => 'spacing',
                'mode'     => 'padding',
                'title'    => esc_html__('Button Padding', 'advkt-toolkit'),
                'output'   => array('.error-btn.theme-btn'),
                'units'    => 'px',
                'default'  => array(
                    'padding-top'    => '16px',
                    'padding-right'  => '40px',
                    'padding-bottom' => '16px',
                    'padding-left'   => '40px',
                ),
            ),
		),
	)
);

Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Footer', 'advkt-toolkit' ),
		'id'               => 'footer',
		'desc'             => esc_html__( 'All Footer fields here!', 'advkt-toolkit' ),
		'customizer_width' => '450px',
		'icon'             => 'el el-pencil',
	)
);

Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Footer Style Setting', 'advkt-toolkit' ),
		'id'               => 'advkt_footer_setting',
		'subsection'       => true,
		'customizer_width' => '450px',
		'fields'           => array(
			array(
				'id'       => 'choose_default_footer',
				'type'     => 'select',
				'title'    => esc_html__('Choose Footer Style', 'advkt-toolkit'), 
				'options'  => array(
					'1' => esc_html__( 'Footer Style 1', 'advkt-toolkit' ),
					'2' => esc_html__( 'Footer Style 2', 'advkt-toolkit' ),
				),
				'default'  => '1',
			),
			array(
				'id'       => 'advkt_footer_bg_color',
				'type'     => 'color',
				'title'    => esc_html__('Footer BG Color', 'advkt-toolkit'), 
				'default'  => '',
				'transparent' => false,
			),
			array(
				'id'       => 'advkt_footer_bg',
				'type'     => 'media', 
				'url'      => false,
				'title'    => esc_html__('Footer Background Image', 'advkt-toolkit'),
            ),
			array(
				'id'       => 'footer_right_shape_img',
				'type'     => 'media', 
				'url'      => false,
				'title'    => esc_html__('Footer Right Shape Image', 'advkt-toolkit'),
            ),
			// array(
			// 	'id'   =>'advkt_footer_style_two_divider',
			// 	'type' => 'divide'
			// ),

			array(
				'id'       => 'advkt_footer_style_two_bg',
				'type'     => 'media', 
				'url'      => false,
				'title'    => esc_html__('Footer Style Two Background Image', 'advkt-toolkit'),
            ),
			array(
				'id'       => 'advkt_footer_style_two_bg_color',
				'type'     => 'color',
				'title'    => esc_html__('Footer Style Two BG Color', 'advkt-toolkit'), 
				'default'  => '',
				'transparent' => false,
			),
			array(
				'id'      => 'advkt_copyright',
				'type'    => 'text',
				'title'   => esc_html__('Copy Right','advkt-toolkit'),
				'default' => esc_html__('Copyright &copy;2024 Advkt. All Rights Reserved','advkt-toolkit'),
            ),
		),
	)
);


Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Footer Typography', 'advkt-toolkit' ),
		'id'               => 'footer_typography',
		'subsection'       => true,
		'customizer_width' => '450px',
		'fields'           => array(
			array(
				'id'             => 'footer_title_typography',
				'type'           => 'typography',
				'title'          => esc_html__('Title Typography', 'advkt-toolkit'),
				'google'         => true,
				'text-align'     => false,
				'text-transform' => true,
				'color'          => false,
				'line-height'    => true,
				'letter-spacing' => true,
				'all_styles'     => true,
				'preview'        => array('text'),
				'output'         => array('.footer-widget-title'),
				'compiler'       => array('.footer-widget-title'),
				'units'          => 'px',
				'default'        => array(
					'google'      => true
				),
			),
			array(
				'id'       => 'footer_title_color',
				'type'     => 'color',
				'title'    => esc_html__('Title Color', 'advkt-toolkit'), 
				'default'  => '',
				'output'   => array('.footer-widget-title'),
				'transparent' => false,
			),
			array(
				'id'       => 'footer_title_hover_color',
				'type'     => 'color',
				'title'    => esc_html__('Title Hover Color', 'advkt-toolkit'), 
				'default'  => '',
				'output'   => array('.footer-widget-title:hover'),
				'transparent' => false,
			),
			array(
				'id'             => 'footer_des_typography',
				'type'           => 'typography',
				'title'          => esc_html__('Description Typography', 'advkt-toolkit'),
				'google'         => true,
				'text-align'     => false,
				'text-transform' => true,
				'color'          => true,
				'line-height'    => true,
				'letter-spacing' => true,
				'all_styles'     => true,
				'preview'        => array('text'),
				'output'         => array('.footer-widget .desc'),
				'compiler'       => array('.footer-widget .desc'),
				'units'          => 'px',
				'default'        => array(
					'google'      => true
				),
			),
		),
	)
);

Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Footer Bottom Typography', 'advkt-toolkit' ),
		'id'               => 'footer_bottom_typography',
		'subsection'       => true,
		'customizer_width' => '450px',
		'fields'           => array(
			array(
				'id'             => 'footer_copyright_text_typography',
				'type'           => 'typography',
				'title'          => esc_html__('Copyright Typography', 'advkt-toolkit'),
				'google'         => true,
				'text-align'     => false,
				'text-transform' => true,
				'color'          => true,
				'line-height'    => true,
				'letter-spacing' => true,
				'all_styles'     => true,
				'preview'        => array('text'),
				'output'         => array('.footer-bottom-area .copyright-text p'),
				'compiler'       => array('.footer-bottom-area .copyright-text p'),
				'units'          => 'px',
				'default'        => array(
					'google'      => true
				),
			),
			array(
				'id'             => 'footer_botttom_menu_typography',
				'type'           => 'typography',
				'title'          => esc_html__('Bottom Menu Typography', 'advkt-toolkit'),
				'google'         => true,
				'text-align'     => false,
				'text-transform' => true,
				'color'          => false,
				'line-height'    => true,
				'letter-spacing' => true,
				'all_styles'     => true,
				'preview'        => array('text'),
				'output'         => array('.footer-bottom-menu ul li a'),
				'compiler'       => array('.footer-bottom-menu ul li a'),
				'units'          => 'px',
				'default'        => array(
					'google'      => true
				),
			),
			array(
				'id'       => 'footer_botttom_menu_color',
				'type'     => 'color',
				'title'    => esc_html__('Menu Color', 'advkt-toolkit'), 
				'default'  => '',
				'output'   => array('.footer-bottom-menu ul li a'),
				'transparent' => false,
			),
			array(
				'id'       => 'footer_botttom_menu_hover_color',
				'type'     => 'color',
				'title'    => esc_html__('Menu Hover Color', 'advkt-toolkit'), 
				'default'  => '',
				'output'   => array('.footer-bottom-menu ul li a:hover'),
				'transparent' => false,
			),
		),
	)
);