<?php 
class AdvktMemberPost 
{
	function __construct() {
		add_action( 'init', array( $this, 'register_custom_post_type' ) );
		add_action( 'init', array( $this, 'create_cat' ) );
		add_filter( 'cmb2_meta_boxes', array( $this, 'add_meta' ) );
		add_filter( 'cmb2_admin_init', array( $this, 'add_left_skills_meta' ) );
		add_filter( 'cmb2_admin_init', array( $this, 'add_right_skills_meta' ) );
		add_filter( 'cmb2_admin_init', array( $this, 'add_social_profiles_meta' ) );
		add_filter( 'template_include', array( $this, 'member_template_include' ) );
	}
	
	public function member_template_include( $template ) {
		if ( is_singular( 'advkt-member' ) ) {
			return $this->get_template( 'single-advkt-member.php');
		}
		return $template;
	}
	
	public function get_template( $template ) {
		if ( $theme_file = locate_template( array( $template ) ) ) {
			$file = $theme_file;
		} 
		else {
			$file = ADVKT_TOOLKIT_DIR . '/template/'. $template;
		}
		return apply_filters( __FUNCTION__, $file, $template );
	}
	
	
	public function register_custom_post_type() {

		$labels = array(
			'name'               => __( 'Member', 'Post Type General Name', 'advkt-toolkit'),
			'singular_name'      => __( 'Member', 'Post Type Singular Name', 'advkt-toolkit'),
			'menu_name'          => __( 'Member', 'advkt-toolkit'),
			'parent_item_colon'  => __( 'Parent member', 'advkt-toolkit'),
			'all_items'          => __( 'All  Members', 'advkt-toolkit'),
			'view_item'          => __( 'View  Member', 'advkt-toolkit'),
			'add_new_item'       => __( 'Add New  member', 'advkt-toolkit'),
			'add_new'            => __( 'Add New  member', 'advkt-toolkit'),
			'edit_item'          => __( 'Edit  Member', 'advkt-toolkit'),
			'update_item'        => __( 'Update  Member', 'advkt-toolkit'),
			'search_items'       => __( 'Search  Member', 'advkt-toolkit'),
			'not_found'          => __( 'Not found', 'advkt-toolkit'),
			'not_found_in_trash' => __( 'Not found in Trash', 'advkt-toolkit'),
		);

		$args   = array(
			'label'               => __( 'Member', 'advkt-toolkit'),
			'description'         => __( 'Create and manage all bdevs member', 'advkt-toolkit'),
			'labels'              => $labels,
			'supports'            => array( 'title','thumbnail', 'editor'),
			'hierarchical'        => false,
			'public'              => true,
			'show_ui'             => true,
			'show_in_menu'        => true,
			'show_in_nav_menus'   => true,
			'show_in_admin_bar'   => true,
			'menu_position'       => 14,
			'rewrite'             =>  array( 'slug' => 'member', 'with_front' => false ),
			'can_export'          => true,
			'has_archive'         => true,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'capability_type'     => 'post',
			'menu_icon'           => 'dashicons-id-alt',
		);

		register_post_type( 'advkt-member', $args );
	}
	
	public function create_cat() {

		$name = 'Member';

		$labels = array(
			'name'              => esc_html($name),
			'singular_name'     => esc_html($name),
			'search_items'      => sprintf(esc_html__( 'Search %s:', 'advkt-toolkit' ),$name),
			'all_items'      	=> sprintf(esc_html__( 'All %s:', 'advkt-toolkit' ),$name),
			'parent_item'      	=> sprintf(esc_html__( 'Parent  %s:', 'advkt-toolkit' ),$name),
			'parent_item_colon' => sprintf(esc_html__( 'Parent  %s:', 'advkt-toolkit' ),$name),
			'edit_item'     	=> sprintf(esc_html__( 'Edit  %s:', 'advkt-toolkit' ),$name),
			'update_item'     	=> sprintf(esc_html__( 'Update %s:', 'advkt-toolkit' ),$name),
			'add_new_item'      => sprintf(esc_html__( 'Add New %s:', 'advkt-toolkit' ),$name),
			'new_item_name'     => sprintf(esc_html__( 'New  %s Name:', 'advkt-toolkit' ),$name),
			'menu_name'      	=> esc_html($name),
		);

		$args = array(
			'hierarchical'      => true,
			'labels'            => $labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'member_cat' ),
		);

		register_taxonomy('member_categories','advkt-member', $args );
	}

	public function add_meta(array $boomdevs) {

		$boomdevs[] = array(
			'id'           => 'advkt-member-section',
			'title'        => esc_html__( 'Member Details Info', 'advkt-toolkit' ),
			'object_types' => array( 'advkt-member'),
			'fields'       => array(	      	
		      	array(
			        'name' => esc_html__('Member Image ','advkt-toolkit'),
			        'type' => 'file',
			        'id' => 'member_single_img'
		      	),		      	
		      	array(
			        'name' => esc_html__('Title ','advkt-toolkit'),
			        'type' => 'text',
			        'id' => 'member_title'
		      	),
				array(
			        'name' => esc_html__('Designation','advkt-toolkit'),
			        'type' => 'text',
			        'id' => 'member_designation'
		      	),
		      	array(
			        'name' => esc_html__('Short Description ','advkt-toolkit'),
			        'type' => 'textarea',
			        'id' => 'member_short_desc'
		      	),
				array(
			        'name' => esc_html__('First Tab Title ','advkt-toolkit'),
			        'type' => 'text',
			        'id' => 'member_first_tab_title'
		      	),
				array(
			        'name' => esc_html__('Second Tab Title ','advkt-toolkit'),
			        'type' => 'text',
			        'id' => 'member_second_tab_title'
		      	),				
			)
		);
		
		return $boomdevs;
	}





	public function add_left_skills_meta() {

		$left_skills = new_cmb2_box( array(
			'title'   => 'First Tab Section',
			'id'    => 'left-skill-section',
			'object_types'  => array('advkt-member')
		));
		

		$group_field_id = $left_skills->add_field( array(
			'id'          => 'left_skills_repeat_group',
			'type'        => 'group',
			'description' => __( 'First Tab Item', 'advkt-toolkit' ),
			'repeatable'  => true, // use false if you want non-repeatable group
			'options'     => array(
			'group_title'   => __( 'First Single Tab Info', 'advkt-toolkit' ), // since version 1.1.4, {#} gets replaced by row number
			'add_button'    => __( 'Add Another Entry', 'advkt-toolkit' ),
			'remove_button' => __( 'Remove Entry', 'advkt-toolkit' ),
			'sortable'      => true, // beta
			'closed'     => false, // true to have the groups closed by default
		),
		) );

		// your icon
		$left_skills->add_group_field( $group_field_id, array(
			'name' => esc_html__('Icon Name','advkt-toolkit'),
			'type' => 'text',
			'id' => 'left_skill_icon'
		) );

		// your title
		$left_skills->add_group_field( $group_field_id, array(
			'name' => esc_html__('Title','advkt-toolkit'),
			'type' => 'textarea_small',
			'id' => 'left_skill_label'
		) );

		// your content
		$left_skills->add_group_field( $group_field_id, array(
			'name' => esc_html__('Content','advkt-toolkit'),
			'type' => 'textarea',
			'id' => 'left_skill_info'
		) );

	}


	public function add_right_skills_meta() {

		$right_skills = new_cmb2_box( array(
			'title'   => '2nd Tab Section',
			'id'    => 'right-skill-section',
			'object_types'  => array('advkt-member')
		));
		

		$group_field_id = $right_skills->add_field( array(
			'id'          => 'right_skills_repeat_group',
			'type'        => 'group',
			'description' => __( 'Second Tab Item', 'advkt-toolkit' ),
			'repeatable'  => true, // use false if you want non-repeatable group
			'options'     => array(
			'group_title'   => __( 'Career Info', 'advkt-toolkit' ), // since version 1.1.4, {#} gets replaced by row number
			'add_button'    => __( 'Add Another Entry', 'advkt-toolkit' ),
			'remove_button' => __( 'Remove Entry', 'advkt-toolkit' ),
			'sortable'      => true, // beta
			'closed'     => false, // true to have the groups closed by default
		),
		) );

		// your icon
		$right_skills->add_group_field( $group_field_id, array(
			'name' => esc_html__('Icon','advkt-toolkit'),
			'type' => 'textarea_small',
			'id' => 'right_skill_icon'
		) );

		// your title
		$right_skills->add_group_field( $group_field_id, array(
			'name' => esc_html__('Title','advkt-toolkit'),
			'type' => 'textarea_small',
			'id' => 'right_skill_label'
		) );

		// your content
		$right_skills->add_group_field( $group_field_id, array(
			'name' => esc_html__('Content','advkt-toolkit'),
			'type' => 'text',
			'id' => 'right_skill_info'
		) );

	}

	public function add_social_profiles_meta() {

		$right_skills = new_cmb2_box( array(
			'title'   => 'Social Profiles Section',
			'id'    => 'social-profiles-section',
			'object_types'  => array('advkt-member')
		));
		

		$group_field_id = $right_skills->add_field( array(
			'id'          => 'social_profiles_repeat_group',
			'type'        => 'group',
			'description' => __( 'Social Profile Item', 'advkt-toolkit' ),
			'repeatable'  => true, // use false if you want non-repeatable group
			'options'     => array(
			'group_title'   => __( 'Social Profile Info', 'advkt-toolkit' ), // since version 1.1.4, {#} gets replaced by row number
			'add_button'    => __( 'Add Another Entry', 'advkt-toolkit' ),
			'remove_button' => __( 'Remove Entry', 'advkt-toolkit' ),
			'sortable'      => true, // beta
			'closed'     => false, // true to have the groups closed by default
		),
		) );

		// your status
		$right_skills->add_group_field( $group_field_id, array(
			'name' => esc_html__('Icon','advkt-toolkit'),
			'type' => 'text',
			'id' => 'social_profile_icon'
		) );

		// your picture
		$right_skills->add_group_field( $group_field_id, array(
			'name' => esc_html__('Link','advkt-toolkit'),
			'type' => 'text',
			'id' => 'social_profile_link'
		) );

	}



}

new AdvktMemberPost();
