<?php 
if ( !defined('ABSPATH') )
    exit;

/*
Plugin Name: Advkt Toolkit
Plugin URI: http://boomdevs.com/
Description: Advkt Toolkit Plugin
Version: 1.0.2
Author: MonPakhi
Author URI: http://boomdevs.com
*/

define( 'ADVKT_TOOLKIT_VER', '1.0.1' );
define( 'ADVKT_TOOLKIT_DIR', plugin_dir_path( __FILE__ ) );
define( 'ADVKT_TOOLKIT_URL', plugin_dir_url( __FILE__ ) );

define( 'ADVKT_TOOLKIT_METABOX_ACTIVED', in_array( 'cmb2/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) );

final class ADVTK_Toolkit {

	private static $instance;

	function __construct() {

		require_once ADVKT_TOOLKIT_DIR . '/inc/advkt-member-post.php';
		require_once ADVKT_TOOLKIT_DIR . '/inc/advkt-service-post.php';
		require_once ADVKT_TOOLKIT_DIR . '/inc/advkt-portfolios.php';
    	require_once ADVKT_TOOLKIT_DIR . '/inc/advkt-meta-boxes.php';
    	require_once ADVKT_TOOLKIT_DIR . '/inc/advkt-option-framework.php';

    	/**
		* widgets
		*/
		require_once ADVKT_TOOLKIT_DIR . '/widgets/advkt-about-widget.php';
		require_once ADVKT_TOOLKIT_DIR . '/widgets/advkt-company-contact-info-widget.php';
		require_once ADVKT_TOOLKIT_DIR . '/widgets/advkt-adddress-info-widget.php';
		require_once ADVKT_TOOLKIT_DIR . '/widgets/advkt-latest-posts-sidebar.php';
		require_once ADVKT_TOOLKIT_DIR . '/widgets/advkt-subscriber-widget.php';
		require_once ADVKT_TOOLKIT_DIR . '/widgets/advkt-posts-tags.php';
		require_once ADVKT_TOOLKIT_DIR . '/widgets/social-profiles-widget.php';
		require_once ADVKT_TOOLKIT_DIR . '/widgets/advkt-cta-widget.php';
		require_once ADVKT_TOOLKIT_DIR . '/widgets/advkt-email-us-widget.php';
		require_once ADVKT_TOOLKIT_DIR . '/widgets/advkt-phone-widget.php';
		require_once ADVKT_TOOLKIT_DIR . '/widgets/advkt-service-cats-widget.php';
		require_once ADVKT_TOOLKIT_DIR . '/widgets/advkt-project-lists-widget.php';

    	add_filter( 'template_include', array( $this, '_service_template_include' ) );

		add_filter('excerpt_length', array($this,'custom_post_excerpt'));
		add_filter('excerpt_more', array($this,'custom_new_excerpt_more'));
	}

	public static function instance() {

		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof ADVTK_Toolkit ) ) {
			self::$instance = new ADVTK_Toolkit;
		}
		return self::$instance;
	}

	public function _service_template_include( $template ) {
		if ( is_singular( 'advkt-service' ) ) {
			return $this->_get_service_template( 'single-advkt-service.php');
		}
		return $template;
	}
	
	public function _get_service_template( $template ) {
		if ( $theme_file = locate_template( array( $template ) ) ) {
			$file = $theme_file;
		} else {
			$file = ADVKT_TOOLKIT_DIR . 'template/'. $template;
		}
		return apply_filters( __FUNCTION__, $file, $template );
	}

	
	function custom_post_excerpt($length){
		global $post;
		if ($post->post_type == 'advkt-service')
			return 15;
		return $length;
	}

	function custom_new_excerpt_more( $more ) {
		global $post;
		if ($post->post_type == 'advkt-service')
			return '';
		return $more;
	}
}

function ADVTK_Toolkit() {

	return ADVTK_Toolkit::instance();
}

ADVTK_Toolkit();


/**
* taxonomy category
*/
function boomdevs_get_terms($id,$tax){
    $terms = get_the_terms( get_the_ID(), $tax ); 
    $list = '';
    if ( $terms && ! is_wp_error( $terms ) ) : 
        $i=1;
        $cats_count = count($terms);
        foreach ( $terms as $term ) {
            $exatra = ( $cats_count > $i ) ? ', ' : '';
            $list .= $term->name . $exatra;
            $i++;
        }
    endif;
    return trim($list,',');
}
