<?php
namespace AdvktElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Advkt Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class AdvktVideo extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Advkt Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'advkt-video';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Advkt Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'AT Video Popup', 'advkt-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Boomdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-video-playlist';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Boomdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'advkt-elementor' ];
	}

	public function get_keywords() {
		return [ 'video' ];
	}

	public function get_script_depends() {
		return [ 'advkt-elementor'];
	}
	protected function register_controls() {

		$this->start_controls_section(
			'section_content_video',
			[
				'label' => esc_html__( 'Section Video', 'advkt-elementor' ),
			]
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Chose Style', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'video-style-1'  => esc_html__( 'Video Style 1', 'advkt-elementor' ),
					'video-style-2' => esc_html__( 'Video Style 2', 'advkt-elementor' ),
				],
				'default'   => 'video-style-1',
			]
		);


		$this->add_control(
			'thumbnail',
			[
				'label'   => esc_html__( 'Video Thumbnail Image', 'advkt-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your About Image', 'advkt-elementor' ),
				'condition' => [
					'chose_style' => ['video-style-1']
				],
			]
		);

		$this->add_control(
			'video_icon_thumb',
			[
				'label'   => esc_html__( 'Video Icon Image', 'advkt-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Video Icon Image', 'advkt-elementor' ),
				'condition' => [
					'chose_style' => ['video-style-1']
				],
			]
		);

		$this->add_control(
			'shape',
			[
				'label'   => esc_html__( 'Bottom Left Shape Image', 'advkt-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your Shape Image', 'advkt-elementor' ),
				'condition' => [
					'chose_style' => ['video-style-1']
				],
			]
		);


		$this->add_control(
			'link',
			[
				'label' => __( 'Link', 'advkt-elementor' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'advkt-elementor' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
				],
				'label_block' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'contact_form_layout',
			[
				'label' => esc_html__( 'Contact Form', 'advkt-elementor' ),
			]
		);
		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your heading', 'advkt-elementor' ),
				'default'     => __( 'It is Heading', 'advkt-elementor' ),
				'label_block' => true,
			]
		);

        $this->add_control(
			'shortcode',
			[
				'label'   => esc_html__( 'Shortcode', 'advkt-elementor' ),
				'type'    => Controls_Manager::TEXT,
				'dynamic' => [ 'active' => true ],
				'default'		=> __('Contact Shortcode here', 'advkt-elementor'),
				'description' => esc_html__( 'Add Your shortcode here', 'advkt-elementor' ),
				'label_block' => true,
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'advkt-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'advkt-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->add_control(
			'show_thumbnail',
			[
				'label'   => esc_html__( 'Show Video Thumbnail', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Link', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);		

		$this->add_control(
			'show_link',
			[
				'label'   => esc_html__( 'Show Link', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	

		$this->add_control(
			'show_shape',
			[
				'label'   => esc_html__( 'Show Shape', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);		

		$this->end_controls_section();

		/** typography **/
		$this->start_controls_section(
			'heading_style',
			[
				'label' => esc_html__( 'Heading Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
            'heading_color',
            [
                'label' => __( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .comment-respond.style-2 .comment-respond-wrapper .form-title' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'heading_typography',
				'selector' => '{{WRAPPER}} .comment-respond.style-2 .comment-respond-wrapper .form-title',
			]
		);
		$this->end_controls_section();


		/** Start Button **/
	$this->start_controls_section(
		'banner_btn_style',
		[
			'label' => esc_html__( 'Button Style', 'eyewell-elementor'),
			'tab' => Controls_Manager::TAB_STYLE,
			
		]
	);

	$this->start_controls_tabs(
		'style_tabs'
	);


	$this->start_controls_tab(
		'style_normal_tab',
		[
			'label' => esc_html__( 'Normal', 'textdomain' ),
		]
	);

	$this->add_group_control(
		Group_Control_Typography::get_type(),
		[
			'name' => 'banner_btn_typography',
			'selector' => '{{WRAPPER}} .video-popup-area .video-popup-wrapper .comment-respond.style-2 .comment-respond-wrapper .single-input-field .btn',
		]
	);
	

	$this->add_responsive_control(
		'banner_btn_text_color',
		[
			'label' => esc_html__( 'Text Color', 'eyewell-elementor' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .video-popup-area .video-popup-wrapper .comment-respond.style-2 .comment-respond-wrapper .single-input-field .btn' => 'color: {{VALUE}} !important',
			],
		]
	);
	
	$this->add_responsive_control(
		'banner_btn_bg_color',
		[
			'label' => esc_html__( 'Background Color', 'eyewell-elementor' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .video-popup-area .video-popup-wrapper .comment-respond.style-2 .comment-respond-wrapper .single-input-field .btn' => 'background: {{VALUE}} !important',
			],
		]
	);
	
	$this->add_responsive_control(
		'banner_btn_margin',
		[
			'label' => esc_html__( 'Margin', 'eyewell-elementor' ),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
			'selectors' => [
				'{{WRAPPER}} .video-popup-area .video-popup-wrapper .comment-respond.style-2 .comment-respond-wrapper .single-input-field .btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
	
	$this->add_responsive_control(
		'banner_btn_padding',
		[
			'label' => esc_html__( 'Padding', 'eyewell-elementor' ),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
			'selectors' => [
				'{{WRAPPER}} .video-popup-area .video-popup-wrapper .comment-respond.style-2 .comment-respond-wrapper .single-input-field .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
	
	$this->add_group_control(
		Group_Control_Border::get_type(),
		[
			'name' => 'banner_btn_border_border',
			'selector' => '{{WRAPPER}} .video-popup-area .video-popup-wrapper .comment-respond.style-2 .comment-respond-wrapper .single-input-field .btn',
		]
	);
	
	$this->add_responsive_control(
		'banner_btn_border_radius',
		[
			'label' => esc_html__( 'Border Radius', 'eyewell-elementor' ),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
			'selectors' => [
				'{{WRAPPER}} .video-popup-area .video-popup-wrapper .comment-respond.style-2 .comment-respond-wrapper .single-input-field .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);

	$this->end_controls_tab();

	$this->start_controls_tab(
		'style_hover_tab',
		[
			'label' => esc_html__( 'Hover', 'textdomain' ),
		]
	);

	
	$this->add_responsive_control(
		'banner_btn_hover_color',
		[
			'label' => esc_html__( 'Color', 'eyewell-elementor' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .video-popup-area .video-popup-wrapper .comment-respond.style-2 .comment-respond-wrapper .single-input-field .btn:hover' => 'color: {{VALUE}} !important',
			],
		]
	);

	$this->add_responsive_control(
		'banner_btn_bg_hover_color',
		[
			'label' => esc_html__( 'Background Color', 'eyewell-elementor' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .video-popup-area .video-popup-wrapper .comment-respond.style-2 .comment-respond-wrapper .single-input-field .btn:hover' => 'background: {{VALUE}} !important',
			],
		]
	);



	$this->end_controls_tab();

	$this->end_controls_section();



	}

	public function render() {
		$settings  = $this->get_settings_for_display(); 
		extract($settings);
		
		$this->add_render_attribute(
			[
				'link' => [
					'href'   => $settings['link']['url'] ? esc_url($settings['link']['url']) : '#',
					'target' => $settings['link']['is_external'] ? '_blank' : '_self'
				]
			], '', '', true
		);

		if( $chose_style == 'video-style-1' ): ?>

        <!-- Video Popup Card section start !-->
        <div class="video-popup-area">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-12">
                        <div class="video-popup-wrapper">
                            <div class="video-popup-card">
                                <?php 
                                if ( '' !== $settings['thumbnail']['url'] && ( $show_thumbnail ))  : 
                                    $thumbnail_image_src = wp_get_attachment_image_src( $settings['thumbnail']['id'], 'full' );
                                    $thumbnail_image = $thumbnail_image_src ? $thumbnail_image_src[0] : ''; 
                                    ?>
                                    <div class="video-popup-image">
                                        <img src="<?php echo esc_url( $thumbnail_image ); ?>" alt="popup image" />
                                    </div>
                                <?php 
                                endif; ?>

                                <?php 
                                if (( '' !== $link['url'] ) && ( $show_link )) : ?>
                                <div class="video-popup-btn">
                                    <a <?php echo $this->get_render_attribute_string( 'link' ); ?> class="mfp-iframe video-play">
                                        <!-- <i class="fa-solid fa-play" aria-hidden="true"></i> -->
                                        <!-- <img src="images/icon/play-btn.png" alt="icon"> -->

                                        <?php 
                                        if ( '' !== $settings['video_icon_thumb']['url'] )  : 
                                            $video_icon_thumb_src = wp_get_attachment_image_src( $settings['video_icon_thumb']['id'], 'full' );
                                            $video_icon_thumb_image = $video_icon_thumb_src ? $video_icon_thumb_src[0] : ''; 
                                            ?>
                                            <div class="video-popup-image">
                                                <img src="<?php echo esc_url( $video_icon_thumb_image ); ?>" alt="popup image" />
                                            </div>

                                        <?php 
                                        endif; ?>
                                    </a>
                                </div>
                                <?php
                                endif; ?>
                            </div>

                            <div class="get-quot-form">
                                <div class="comment-respond style-2">
                                    <div class="comment-form">
                                        <div class="comment-respond-wrapper">
                                            <?php
                                            if ( ('' !== $heading ) &&  ( $settings['show_heading'] )) : ?>
                                                <h2 class="form-title"><?php echo $heading; ?></h2>
                                            <?php
                                            endif; ?>
                                            <?php print do_shortcode(html_entity_decode( $settings['shortcode'] )); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php 
            if ( '' !== $settings['shape']['url'] && ( $show_shape ))  : 
                $shape_image_src = wp_get_attachment_image_src( $settings['shape']['id'], 'full' );
                $shape_image = $shape_image_src ? $shape_image_src[0] : ''; 
                ?>
                <div class="shape">
                    <img src="<?php echo esc_url( $shape_image ); ?>" alt="popup image" />
                </div>
            <?php 
            endif; ?>

        </div>
        <!-- Video Popup Card section end !-->

        <?php 
        elseif ($chose_style == 'video-style-2'): ?>

        <?php 
    	endif; ?>
	<?php
	}

}