<?php
namespace AdvktElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Advkt Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class AdvktTeam extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Advkt Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'advkt-team';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Advkt Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'AT Team', 'advkt-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Advkt Service widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-post-content';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Advkt Service widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'advkt-elementor' ];
	}

	public function get_keywords() {
		return [ 'team' ];
	}

	public function get_script_depends() {
		return [ 'advkt-elementor'];
	}

	protected function register_controls() {


		$this->start_controls_section(
			'section_content_service_post',
			[
				'label' => esc_html__( 'Section Service Post', 'advkt-elementor' ),
			]
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Chose Style', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'service-style-1'  => esc_html__( 'Service Style 1', 'advkt-elementor' ),
					'service-style-2' => esc_html__( 'Service Style 2', 'advkt-elementor' ),
				],
				'default'   => 'service-style-1',
			]
		);

		$this->add_control(
			'heading_word_count',
			[
				'label'       => __( 'Heading Word Count', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Heading Words Number', 'advkt-elementor' ),
				'default'   => 7,				
			]
		);

		$this->add_control(
			'content_word_count',
			[
				'label'       => __( 'Content Word Count', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Heading Words Number', 'advkt-elementor' ),
				'default'   => 15,				
			]
		);

		$this->add_control(
			'post_number',
			[
				'label'     => esc_html__( 'Post Count', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'1'  => esc_html__( '1', 'advkt-elementor' ),
					'2'  => esc_html__( '2', 'advkt-elementor' ),
					'3'  => esc_html__( '3', 'advkt-elementor' ),
					'4'  => esc_html__( '4', 'advkt-elementor' ),
					'5'  => esc_html__( '5', 'advkt-elementor' ),
					'6' => esc_html__( '6', 'advkt-elementor' ),
					'7' => esc_html__( '7', 'advkt-elementor' ),
					'8' => esc_html__( '8', 'advkt-elementor' ),
					'9' => esc_html__( '9', 'advkt-elementor' ),
					'10' => esc_html__( '10', 'advkt-elementor' ),
					'-1' => esc_html__( 'Show All', 'advkt-elementor' ),
				],
				'default'   => '3',
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'ID'  => esc_html__( 'Post ID', 'advkt-elementor' ),
					'title'  => esc_html__( 'Title', 'advkt-elementor' ),
					'date' => esc_html__( 'Date', 'advkt-elementor' ),
					'modified' => esc_html__( 'Last Modified Date', 'advkt-elementor' ),
					'rand' => esc_html__( 'Random Order', 'advkt-elementor' ),
					'comment_count' => esc_html__( 'Popular Post', 'advkt-elementor' ),
				],
				'default'   => 'ID',
			]
		);
		
		$this->add_control(
			'post_order',
			[
				'label'     => esc_html__( 'Post Order', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'asc'  => esc_html__( 'ASC', 'advkt-elementor' ),
					'desc' => esc_html__( 'DESC', 'advkt-elementor' ),
				],
				'default'   => 'desc',
			]
		);

		$this->add_control(
			'cat',
			[
				'label'       => __( 'Category Slug', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter Category Slug', 'advkt-elementor' ),
				'label_block' => true,				
			]
		);

		$this->add_control(
			'service_link_text',
			[
				'label'       => esc_html__( 'Service Button Text', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Read More ', 'advkt-elementor' ),
				'placeholder' => esc_html__( 'Link Text', 'advkt-elementor' ),
				'label_block' => true
			]
		);		

		$this->add_control(
			'service_icon_name',
			[
				'label'       => esc_html__( 'Service btn Icon Name', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'fa-solid fa-angle-right', 'advkt-elementor' ),
				'placeholder' => esc_html__( 'icon name here', 'advkt-elementor' ),
				'label_block' => true
			]
		);

		$this->add_control(
			'service_btn_on',
			[
				'label'   => esc_html__( 'Service BTN Switch', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'service_icon_on',
			[
				'label'   => esc_html__( 'Service icon Switch', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [
					'service_btn_on' => 'yes'
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'advkt-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'advkt-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->add_control(
			'show_heading_section',
			[
				'label'   => esc_html__( 'Show Heading Section', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	

		$this->add_control(
			'show_sub_heading',
			[
				'label'   => esc_html__( 'Show Sub Heading', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [
					'show_heading_section' => 'yes'
				],
			]
		);	

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [
					'show_heading_section' => 'yes'
				],
			]
		);	

		$this->add_control(
			'show_desc',
			[
				'label'   => esc_html__( 'Show Description', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [
					'show_heading_section' => 'yes'
				],
			]
		);	

		$this->end_controls_section();
		
		/** typography **/
		$this->start_controls_section(
			'feature_style',
			[
				'label' => esc_html__( 'Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
            'service_post_sub_heading_font_color',
            [
                'label' => __( 'Sub Heading Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .service-area .section-title .short-title' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'service_post_sub_heading_font_size',
			[
				'label' => __( 'Sub Heading Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .service-area .section-title .short-title' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'service_post_sub_heading_line_height',
			[
				'label' => __( 'Sub Heading Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .service-area .section-title .short-title' => 'line-height: {{SIZE}};',
				],
			]
		);


		$this->add_control(
			'divider-104654',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
            'service_post_heading_font_color',
            [
                'label' => __( 'Heading Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .service-area .section-title .title' => 'color: {{VALUE}};',
                ]
            ]
        );
		$this->add_control(
            'service_post_heading_font_highlight_color',
            [
                'label' => __( 'Heading Highlight Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .service-area .section-title .title span' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'service_post_heading_font_size',
			[
				'label' => __( 'Heading Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .service-area .section-title .title' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'service_post_heading_line_height',
			[
				'label' => __( 'Heading Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .service-area .section-title .title' => 'line-height: {{SIZE}};',
				],
			]
		);

		$this->add_control(
			'divider-5555',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
            'service_post_heading_divider_font_color',
            [
                'label' => __( 'Divider Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .service-area .section-title .divider' => 'background-color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'divider-6598214',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
            'service_desc_font_color',
            [
                'label' => __( 'Description Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .service-area .section-content p' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'service_desc_font_size',
			[
				'label' => __( 'Description Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .service-area .section-content p' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'service_desc_line_height',
			[
				'label' => __( 'Description Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .service-area .section-content p' => 'line-height: {{SIZE}};',
				],
			]
		);
		$this->add_control(
			'divider-655598214',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_control(
            'service_card_style_one_icon_bg_color',
            [
                'label' => __( 'card Style One Icon Background Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .service-area .info-card .info-card-inner .icon' => 'background: {{VALUE}};',
                ]
            ]
        );
		$this->add_control(
            'service_card_style_two_icon_bg_color',
            [
                'label' => __( 'card Style two Icon Background Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#005bac',
                'selectors' => [
                    '{{WRAPPER}} .service-area .info-card .content-wrapper .content-inner .icon' => 'background: {{VALUE}};',
                ]
            ]
        );
		$this->add_control(
			'divider-6598255615564',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_control(
            'service_card_title_color',
            [
                'label' => __( 'Card title Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .service-area .info-card .info-card-inner .title' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'service_card_title_font_size',
			[
				'label' => __( 'Card title Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .service-area .info-card .info-card-inner .title' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'service_card_title_line_height',
			[
				'label' => __( 'Card title Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .service-area .info-card .info-card-inner .title' => 'line-height: {{SIZE}};',
				],
			]
		);
		$this->add_control(
			'divider-6598215564',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
            'service_card_desc_font_color',
            [
                'label' => __( 'card description Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .service-area .info-card .info-card-inner .content .desc' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'service_card_desc_font_size',
			[
				'label' => __( 'Description Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .service-area .info-card .info-card-inner .content .desc' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'service_card_desc_line_height',
			[
				'label' => __( 'Description Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .service-area .info-card .info-card-inner .content .desc' => 'line-height: {{SIZE}};',
				],
			]
		);
		$this->add_control(
			'divider-659825615564',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
            'service_card_btn_color',
            [
                'label' => __( 'card Button Text Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .service-area .info-card .info-card-inner .content .read-more a' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'service_card_btn_font_size',
			[
				'label' => __( 'Card Button Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .service-area .info-card .info-card-inner .content .read-more a' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'service_card_btn_line_height',
			[
				'label' => __( 'Card Button Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .service-area .info-card .info-card-inner .content .read-more a' => 'line-height: {{SIZE}};',
				],
			]
		);

		$this->end_controls_section();


	}

	public function render() {

		$settings  = $this->get_settings_for_display(); 
		extract( $settings );

		$cat = get_term_by('name', $cat, 'member_categories');
		if( !empty($cat->term_id) ){
			$term_id = $cat->term_id;
		}
 
		if( $chose_style == 'service-style-1' ):
		?>

          <!-- team member area start -->
  <div class="team-member-wrapper">

<div class="container">
        <?php 
        if( !empty($cat->term_id) ){
            $q = new \WP_Query(array(
                'post_type'     => 'advkt-member',
                'posts_per_page'=> $post_number,
                'orderby' 		=> 'menu_order '.$orderby,
                'order'			=> $post_order,
                'tax_query' => array(
                    array(
                        'taxonomy' => 'member_categories',
                        'field'    => 'term_id',
                        'terms'    => array( $term_id ),
                        'operator' => 'IN',
                    ),
                ),
            ));
        
        }else{
            $q = new \WP_Query(array(
                'post_type'     => 'advkt-member',
                'posts_per_page'=> $post_number,
                'orderby' 		=> 'menu_order '.$orderby,
                'order'			=> $post_order,
            ));
        }
            
        if($q->have_posts()):
			$number = 0;
            while($q->have_posts()): $q->the_post(); 
                $designation = get_post_meta(get_the_ID(), 'member_designation', true);
                $title = get_post_meta(get_the_ID(), 'member_title', true);
            ?>

				<?php
				if( $number % 2 === 0): ?>
				<!-- single team member start -->
				<div class="single-team-member">
					<div class="row gy-4">
						<div class="col-lg-5">
							<div class="team-member-thumb">
								<img src="<?php the_post_thumbnail_url('transco-service-thumb'); ?>" alt="">
							</div>
							
						</div>
						<div class="col-lg-7">
							<div class="team-member-content">
								<div class="content">
									<h2 class="title mb-0"><?php echo $title; ?></h2>
									<p>Proin efficitur, mauris vel condimentum pulvinar, velit orci consectetur ligula, eget egestas magna mi ut arcu. Phasellus nec odio orci. Nunc id massa ante. Suspendisse sit amet neque euismod, convallis quam eget, dignissim massa. Aliquam blandit risus purus, in congue nunc venenatis id. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Integer nec quam ut tortor efficitur consectetur sed vitae nisi. Phasellus convallis vulputate euismod. Pellentesque lacinia rutrum libero, sit amet aliquam ante viverra a. Ut sem ipsum, tempor nec rutrum in, gravida eu ipsum.</p>
								</div>
								<div class="member-court">
									<span class="desc">Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut al</span>
								</div>
								<div class="member-social-site">
									<a href="#"><i class="fa-brands fa-twitter"></i></a>
									<a href="#"><i class="fa-brands fa-linkedin-in"></i></a>
									<a href="#"><i class="fa-brands fa-facebook-f"></i></a>
								</div>
							</div>
						</div>
					</div>
				</div>
				<!-- single team member end -->

				<?php
				else: ?>
				<!-- single team member start -->
				<div class="single-team-member">
					<div class="row gy-4">
						
						<div class="col-lg-7">
							<div class="team-member-content">
								<div class="content">
									<h2 class="title mb-0"><?php echo $title; ?></h2>
									<p>Proin efficitur, mauris vel condimentum pulvinar, velit orci consectetur ligula, eget egestas magna mi ut arcu. Phasellus nec odio orci. Nunc id massa ante. Suspendisse sit amet neque euismod, convallis quam eget, dignissim massa. Aliquam blandit risus purus, in congue nunc venenatis id. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Integer nec quam ut tortor efficitur consectetur sed vitae nisi. Phasellus convallis vulputate euismod. Pellentesque lacinia rutrum libero, sit amet aliquam ante viverra a. Ut sem ipsum, tempor nec rutrum in, gravida eu ipsum.</p>
								</div>
								<div class="member-court">
									<span class="desc">Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut al</span>
								</div>
								<div class="member-social-site">
									<a href="#"><i class="fa-brands fa-twitter"></i></a>
									<a href="#"><i class="fa-brands fa-linkedin-in"></i></a>
									<a href="#"><i class="fa-brands fa-facebook-f"></i></a>
								</div>
							</div>
						</div>
						<div class="col-lg-5">
							<div class="team-member-thumb">
								<img src="<?php the_post_thumbnail_url('transco-service-thumb'); ?>" alt="">
							</div>
							
						</div>
					</div>
				</div>
				<!-- single team member end -->

				<?php
				endif; ?>



			<?php 
			$number++;
			endwhile; 
			wp_reset_postdata(); 
		endif; 
		?>

</div>

</div>
<!-- team member area end -->




        <?php 
		elseif( $chose_style == 'service-style-2' ): ?>

		
		<?php 
		endif; ?>	
	<?php
	}
}