<?php
namespace AdvktElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Advkt Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class AdvktServicePost extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Advkt Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'advkt-service-post';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Advkt Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Post Services', 'advkt-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Advkt Service widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-post-content';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Advkt Service widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'advkt-elementor' ];
	}

	public function get_keywords() {
		return [ 'service-post' ];
	}

	public function get_script_depends() {
		return [ 'advkt-elementor'];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content_heading',
			[
				'label' => esc_html__( 'Services Section', 'advkt-elementor' ),
			]
		);


		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Chose Style', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'service-style-1'  => esc_html__( 'Service Style 1', 'advkt-elementor' ),
					'service-style-2' => esc_html__( 'Service Style 2', 'advkt-elementor' ),
					'service-style-3' => esc_html__( 'Service Style 3', 'advkt-elementor' ),
				],
				'default'   => 'service-style-1',
			]
		);

		$this->add_control(
			'heading_word_count',
			[
				'label'       => __( 'Heading Word Count', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Heading Words Number', 'advkt-elementor' ),
				'default'   => 7,				
			]
		);

		$this->add_control(
			'content_word_count',
			[
				'label'       => __( 'Content Word Count', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Heading Words Number', 'advkt-elementor' ),
				'default'   => 15,				
			]
		);

		$this->add_control(
			'post_number',
			[
				'label'     => esc_html__( 'Post Count', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'1'  => esc_html__( '1', 'advkt-elementor' ),
					'2'  => esc_html__( '2', 'advkt-elementor' ),
					'3'  => esc_html__( '3', 'advkt-elementor' ),
					'4'  => esc_html__( '4', 'advkt-elementor' ),
					'5'  => esc_html__( '5', 'advkt-elementor' ),
					'6' => esc_html__( '6', 'advkt-elementor' ),
					'7' => esc_html__( '7', 'advkt-elementor' ),
					'8' => esc_html__( '8', 'advkt-elementor' ),
					'9' => esc_html__( '9', 'advkt-elementor' ),
					'10' => esc_html__( '10', 'advkt-elementor' ),
					'-1' => esc_html__( 'Show All', 'advkt-elementor' ),
				],
				'default'   => '3',
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'ID'  => esc_html__( 'Post ID', 'advkt-elementor' ),
					'title'  => esc_html__( 'Title', 'advkt-elementor' ),
					'date' => esc_html__( 'Date', 'advkt-elementor' ),
					'modified' => esc_html__( 'Last Modified Date', 'advkt-elementor' ),
					'rand' => esc_html__( 'Random Order', 'advkt-elementor' ),
					'comment_count' => esc_html__( 'Popular Post', 'advkt-elementor' ),
				],
				'default'   => 'ID',
			]
		);
		
		$this->add_control(
			'post_order',
			[
				'label'     => esc_html__( 'Post Order', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'asc'  => esc_html__( 'ASC', 'advkt-elementor' ),
					'desc' => esc_html__( 'DESC', 'advkt-elementor' ),
				],
				'default'   => 'desc',
			]
		);

		$this->add_control(
			'cat',
			[
				'label'       => __( 'Category Slug', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter Category Slug', 'advkt-elementor' ),
				'label_block' => true,				
			]
		);

		$this->add_control(
			'service_link_text',
			[
				'label'       => esc_html__( 'Service Button Text', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Read More ', 'advkt-elementor' ),
				'placeholder' => esc_html__( 'Link Text', 'advkt-elementor' ),
				'label_block' => true
			]
		);		

		$this->add_control(
			'service_icon_name',
			[
				'label'       => esc_html__( 'Service btn Icon Name', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'fa-solid fa-angle-right', 'advkt-elementor' ),
				'placeholder' => esc_html__( 'icon name here', 'advkt-elementor' ),
				'label_block' => true
			]
		);

		$this->add_control(
			'service_btn_on',
			[
				'label'   => esc_html__( 'Service BTN Switch', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'service_icon_on',
			[
				'label'   => esc_html__( 'Service icon Switch', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [
					'service_btn_on' => 'yes'
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'advkt-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'advkt-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->add_control(
			'show_icon',
			[
				'label'   => esc_html__( 'Show Icon', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => '',
			]
		);	

		$this->add_control(
			'show_icon_img',
			[
				'label'   => esc_html__( 'Show Icon Image', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	
	
		$this->end_controls_section();
		
		/** typography **/
		$this->start_controls_section(
			'service_info_style',
			[
				'label' => esc_html__( 'Service info Style One', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

	
		$this->add_control(
            'service_post_heading_font_color',
            [
                'label' => __( 'Heading Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .el-services.style-1 .info-card .title-wrapper h2' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'service_post_heading_font_size',
			[
				'label' => __( 'Heading Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .el-services.style-1 .info-card .title-wrapper h2' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'service_post_heading_line_height',
			[
				'label' => __( 'Heading Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .el-services.style-1 .info-card .title-wrapper h2' => 'line-height: {{SIZE}};',
				],
			]
		);

		$this->add_control(
			'divider-1000',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
            'service_desc_font_color',
            [
                'label' => __( 'Description Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
					'{{WRAPPER}} .el-services.style-1 .info-card .content p' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'service_desc_font_size',
			[
				'label' => __( 'Description Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .el-services.style-1 .info-card .content p' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'service_desc_line_height',
			[
				'label' => __( 'Description Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .el-services.style-1 .info-card .content p' => 'line-height: {{SIZE}};',
				],
			]
		);


		$this->end_controls_section();


		$this->start_controls_section(
			'service_card_style_one',
			[
				'label' => esc_html__( 'Service Card Style One', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
            'service_card_style_one_bg_color',
            [
                'label' => __( 'Card Style One Background Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .el-services.style-1 .info-card' => 'background: {{VALUE}};',
                ]
            ]
        );

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'service_card_style_one',
				'selector' => '{{WRAPPER}} .el-services.style-1 .info-card',
			]
		);

		$this->add_responsive_control(
			'service_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'advkt-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .el-services.style-1 .info-card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'service_card_style_one_margin',
			[
				'label' => esc_html__( 'Margin', 'advkt-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .el-services.style-1 .info-card' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'service_card_style_one_padding',
			[
				'label' => esc_html__( 'Padding', 'advkt-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .el-services.style-1 .info-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


		$this->end_controls_section();

			/** typography **/
			$this->start_controls_section(
				'service_two_info_style',
				[
					'label' => esc_html__( 'Service info Style Two', 'advkt-elementor' ),
					'tab' => Controls_Manager::TAB_STYLE,
				]
			);
	
		
			$this->add_control(
				'service_two_post_heading_font_color',
				[
					'label' => __( 'Heading Color', 'advkt-elementor' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .all-process-steps .content h3.title' => 'color: {{VALUE}};',
					]
				]
			);
	
			$this->add_control(
				'service_two_post_heading_font_size',
				[
					'label' => __( 'Heading Font Size', 'advkt-elementor' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 300,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => '',
					],
					'selectors' => [
						'{{WRAPPER}} .all-process-steps .content h3.title' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
	
			$this->add_control(
				'service_two_post_heading_line_height',
				[
					'label' => __( 'Heading Line Height', 'advkt-elementor' ),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'min' => 1,
					'max' => 100,
					'step' => 1,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .all-process-steps .content h3.title' => 'line-height: {{SIZE}};',
					],
				]
			);
	
			$this->add_control(
				'divider-2000',
				[
					'type' => \Elementor\Controls_Manager::DIVIDER,
				]
			);
	
			$this->add_control(
				'service_two_desc_font_color',
				[
					'label' => __( 'Description Color', 'advkt-elementor' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .all-process-steps .content p' => 'color: {{VALUE}};',
					]
				]
			);
	
			$this->add_control(
				'service_two_desc_font_size',
				[
					'label' => __( 'Description Font Size', 'advkt-elementor' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 300,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => '',
					],
					'selectors' => [
						'{{WRAPPER}} .all-process-steps .content p' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
	
			$this->add_control(
				'service_two_desc_line_height',
				[
					'label' => __( 'Description Line Height', 'advkt-elementor' ),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'min' => 1,
					'max' => 100,
					'step' => 1,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .all-process-steps .content p' => 'line-height: {{SIZE}};',
					],
				]
			);
	
	
			$this->add_control(
				'divider-3000',
				[
					'type' => \Elementor\Controls_Manager::DIVIDER,
				]
			);
	
			$this->add_responsive_control(
				'service_two_link_color',
				[
					'label' => esc_html__( 'Icon Color', 'advkt-elementor' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .all-process-steps .content a.read-more-btn' => 'color: {{VALUE}} !important',
					],
				]
			);
			
			$this->add_responsive_control(
				'service_two_link_bg_color',
				[
					'label' => esc_html__( 'Icon BG Color', 'advkt-elementor' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .all-process-steps .content a.read-more-btn' => 'background-color: {{VALUE}} !important',
					],
				]
			);
			
	
			$this->end_controls_section();
	
	
			$this->start_controls_section(
				'service_two_card_style',
				[
					'label' => esc_html__( 'Service Card Style Two', 'advkt-elementor' ),
					'tab' => Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'service_two_diver_bg_color',
				[
					'label' => esc_html__( 'Divider Background Color', 'advkt-elementor' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .all-process-steps .process-step:hover .divider span' => 'background-color: {{VALUE}} !important',
					],
				]
			);
	


	
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'service_two_card_style',
					'selector' => '{{WRAPPER}} .all-process-steps .process-step .divider span',
				]
			);
	
			$this->add_responsive_control(
				'service_two_border_radius',
				[
					'label' => esc_html__( 'Border Radius', 'advkt-elementor' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .all-process-steps .process-step .divider span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
	
			$this->end_controls_section();


	}

	public function render() {

		$settings  = $this->get_settings_for_display(); 
		extract( $settings );

		$cat = get_term_by('name', $cat, 'service_categories');
		if( !empty($cat->term_id) ){
			$term_id = $cat->term_id;
		}
 
		if( $chose_style == 'service-style-1' ): 
		?>


    <!-- Feature Area Start-->
	<div class="all-services el-services style-1">
		<div class="container">
			<div class="row gy-5">

				<?php 
				if( !empty($cat->term_id) ){
					$q = new \WP_Query(array(
						'post_type'     => 'advkt-service',
						'posts_per_page'=> $post_number,
						'orderby' 		=> 'menu_order '.$orderby,
						'order'			=> $post_order,
						'tax_query' => array(
							array(
								'taxonomy' => 'service_categories',
								'field'    => 'term_id',
								'terms'    => array( $term_id ),
								'operator' => 'IN',
							),
						),
					));
				
				}else{
					$q = new \WP_Query(array(
						'post_type'     => 'advkt-service',
						'posts_per_page'=> $post_number,
						'orderby' 		=> 'menu_order '.$orderby,
						'order'			=> $post_order,
					));
				}
					
				if($q->have_posts()):
					while($q->have_posts()): $q->the_post(); 
						$icon = get_post_meta(get_the_ID(), 'service_icon', true);
						$icon_img = get_post_meta(get_the_ID(), 'service_icon_image', true);
						$tiny_content = get_post_meta(get_the_ID(), 'service_tiny_text', true);
					?>

					<div class="col-md-6 col-lg-3">
						<!-- single info-card start -->
						<div class="info-card ">
							<div class="info-card-inner">
								<div class="content-wrapper">
									<div class="title-wrapper">

										<?php
										if( '' !== $icon_img && '' !== $show_icon_img): ?>
											<div class="icon">
												<img src="<?php echo esc_url($icon_img); ?>" alt="<?php echo esc_attr__('icon', 'advkt-elementor'); ?>">
											</div>
										<?php 
										endif; ?>

										<?php
										if( '' !== $icon && '' !== $show_icon): ?>
											<div class="icon">
												<i class="<?php echo esc_attr($icon); ?>"></i>
											</div>
										<?php 
										endif; ?>

										<h2 class="title"><?php echo wp_trim_words( get_the_title(), $heading_word_count, '' ); ?></h2>
									</div>
									<div class="content">
										<p class="desc"><?php echo wp_trim_words( $tiny_content, $content_word_count, '' ); ?></p>
									</div>
									<div class="thumbnail-wrapper">
										<div class="thumbnail-inner">
											<img src="<?php the_post_thumbnail_url('transco-service-thumb'); ?>" alt="image" />
										</div>
									</div>
									<?php 
									if ( $settings['service_btn_on'] ) : ?>
										<div class="btn-wrapper">
											<a href="<?php the_permalink(); ?>">
												<i class="fa-sharp fa-solid fa-period"></i>
												<i class="fa-sharp fa-solid fa-period"></i>
												<i class="fa-sharp fa-solid fa-period"></i>
												<i class="fa-sharp fa-solid fa-period"></i>
											</a>
										</div>
									<?php
									endif; ?>
								</div>
							</div>
						</div>
						<!-- single info-card End-->
					</div>
					<?php 
					endwhile; 
					wp_reset_postdata(); 
				endif; 
				?>

					</div>
				</div>
			</div>
			<!-- Feature Area End !-->


        <?php 
		elseif( $chose_style == 'service-style-2' ): ?>

			<!-- Process Step Area Start -->
		<div class="all-process-steps">
			<div class="container">
				<div class="row">
					<div class="col-12">
						<div class="process-step-wrapper">
							<?php 
							if( !empty($cat->term_id) ){
								$q = new \WP_Query(array(
									'post_type'     => 'advkt-service',
									'posts_per_page'=> $post_number,
									'orderby' 		=> 'menu_order '.$orderby,
									'order'			=> $post_order,
									'tax_query' => array(
										array(
											'taxonomy' => 'service_categories',
											'field'    => 'term_id',
											'terms'    => array( $term_id ),
											'operator' => 'IN',
										),
									),
								));
							
							}else{
								$q = new \WP_Query(array(
									'post_type'     => 'advkt-service',
									'posts_per_page'=> $post_number,
									'orderby' 		=> 'menu_order '.$orderby,
									'order'			=> $post_order,
								));
							}
								
							if($q->have_posts()):
								while($q->have_posts()): $q->the_post(); 
									$icon_img = get_post_meta(get_the_ID(), 'service_icon_image', true);
									$icon = get_post_meta(get_the_ID(), 'service_icon', true);
									$tiny_content = get_post_meta(get_the_ID(), 'service_tiny_text', true);
									echo "<pre>";
									var_dump( $icon );
									echo "</pre>";
								?>
								
									<!-- Single Process Step Start -->
									<div class="process-step style-1">
										<?php
										if( '' !== $icon_img && '' !== $show_icon_img): ?>
											<div class="icon">
												<img src="<?php echo esc_url($icon_img); ?>" alt="<?php echo esc_attr__('icon', 'advkt-elementor'); ?>">
											</div>
										<?php 
										endif; ?>

										<?php
										if( '' !== $icon && '' !== $show_icon): ?>
											<div class="icon">
												<i class="<?php echo esc_attr($icon); ?>"></i>
											</div>
										<?php 
										endif; ?>

										<div class="divider">
											<span></span>
										</div>
										<div class="content">
											<h3 class="title"><a href="<?php the_permalink(); ?>"><?php echo wp_trim_words( get_the_title(), $heading_word_count, '' ); ?></a></h3>
											<p class="desc"><?php echo wp_trim_words( $tiny_content, $content_word_count, '' ); ?></p>
											<a href="<?php the_permalink(); ?>" class="read-more-btn"><i class="fa-regular fa-arrow-down-long"></i></a>
										</div>
									</div>
									<!-- Single Process Step End -->
									<?php 
								endwhile; 
								wp_reset_postdata(); 
							endif; 
							?>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- Process Step Area End -->

		
        <?php 
		elseif( $chose_style == 'service-style-3' ): ?>
			<!-- Feature Area Start-->
			<div class="feature-area style-2">
				<div class="container">
					<div class="row gy-4">
						<?php 
							if( !empty($cat->term_id) ){
								$q = new \WP_Query(array(
									'post_type'     => 'advkt-service',
									'posts_per_page'=> $post_number,
									'orderby' 		=> 'menu_order '.$orderby,
									'order'			=> $post_order,
									'tax_query' => array(
										array(
											'taxonomy' => 'service_categories',
											'field'    => 'term_id',
											'terms'    => array( $term_id ),
											'operator' => 'IN',
										),
									),
								));
							
							}else{
								$q = new \WP_Query(array(
									'post_type'     => 'advkt-service',
									'posts_per_page'=> $post_number,
									'orderby' 		=> 'menu_order '.$orderby,
									'order'			=> $post_order,
								));
							}
								
							if($q->have_posts()):
								while($q->have_posts()): $q->the_post(); 
									$icon_img = get_post_meta(get_the_ID(), 'service_icon_image', true);
									$icon = get_post_meta(get_the_ID(), 'service_icon', true);
									$tiny_content = get_post_meta(get_the_ID(), 'service_tiny_text', true);
								?>

								<div class="col-md-6 col-lg-3">
									<!-- single info-card start -->
									<div class="info-card ">
										<div class="info-card-inner">
											<div class="content-wrapper">
												<div class="title-wrapper">


													<?php
													if( '' !== $icon_img && '' !== $show_icon_img): ?>
														<div class="icon">
															<img src="<?php echo esc_url($icon_img); ?>" alt="<?php echo esc_attr__('icon', 'advkt-elementor'); ?>">
														</div>
													<?php 
													endif; ?>

													<?php
													if( '' !== $icon && '' !== $show_icon): ?>
														<div class="icon">
															<i class="<?php echo esc_attr($icon); ?>"></i>
														</div>
													<?php 
													endif; ?>


													<h2 class="title"><a href="<?php the_permalink(); ?>"><?php echo wp_trim_words( get_the_title(), $heading_word_count, '' ); ?></a></h2>
												</div>
												<div class="content">
													<p class="desc"><?php echo wp_trim_words( $tiny_content, $content_word_count, '' ); ?></p>
												</div>
												<div class="thumbnail-wrapper">
													<div class="thumbnail-inner">
														<img src="<?php the_post_thumbnail_url('advkt-service-thumb'); ?>" alt="image" />
													</div>
												</div>
												<div class="btn-wrapper">
													<a href="<?php the_permalink(); ?>">
														<i class="fa-sharp fa-solid fa-period"></i>
														<i class="fa-sharp fa-solid fa-period"></i>
														<i class="fa-sharp fa-solid fa-period"></i>
														<i class="fa-sharp fa-solid fa-period"></i>
													</a>
												</div>
											</div>
										</div>
									</div>
									<!-- single info-card End-->
								</div>
									<?php 
								endwhile; 
								wp_reset_postdata(); 
							endif; 
							?>

					</div>
				</div>
			</div>
			<!-- Feature Area End !-->
		<?php 
		endif; ?>	
	<?php
	}
}