<?php
namespace AdvktElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Advkt Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class AdvktPortfolio extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Advkt Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'advkt-portfolio-post';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Advkt Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'AT Portfolio', 'advkt-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Advkt Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-posts-grid';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Advkt Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'advkt-elementor' ];
	}

	public function get_keywords() {
		return [ 'portfolio' ];
	}

	public function get_script_depends() {
		return [ 'advkt-elementor'];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content_portfolio_post',
			[
				'label' => esc_html__( 'Portfolio Post', 'advkt-elementor' ),
			]
		);

		$this->add_control(
			'heading_word_count',
			[
				'label'       => __( 'Heading Word Count', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Heading Words Number', 'advkt-elementor' ),
				'default'   => 7,				
			]
		);

		$this->add_control(
			'content_word_count',
			[
				'label'       => __( 'Content Word Count', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Content Words Number', 'advkt-elementor' ),
				'default'   => 30,				
			]
		);

		$this->add_control(
			'post_number',
			[
				'label'     => esc_html__( 'Post Count', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'1'  => esc_html__( '1', 'advkt-elementor' ),
					'2'  => esc_html__( '2', 'advkt-elementor' ),
					'3'  => esc_html__( '3', 'advkt-elementor' ),
					'4'  => esc_html__( '4', 'advkt-elementor' ),
					'5'  => esc_html__( '5', 'advkt-elementor' ),
					'6' => esc_html__( '6', 'advkt-elementor' ),
					'7' => esc_html__( '7', 'advkt-elementor' ),
					'8' => esc_html__( '8', 'advkt-elementor' ),
					'9' => esc_html__( '9', 'advkt-elementor' ),
					'10' => esc_html__( '10', 'advkt-elementor' ),
					'-1' => esc_html__( 'Show All', 'advkt-elementor' ),
				],
				'default'   => '3',
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'ID'  => esc_html__( 'Post ID', 'advkt-elementor' ),
					'title'  => esc_html__( 'Title', 'advkt-elementor' ),
					'date' => esc_html__( 'Date', 'advkt-elementor' ),
					'modified' => esc_html__( 'Last Modified Date', 'advkt-elementor' ),
					'rand' => esc_html__( 'Random Order', 'advkt-elementor' ),
					'comment_count' => esc_html__( 'Popular Post', 'advkt-elementor' ),
				],
				'default'   => 'ID',
			]
		);
		
		$this->add_control(
			'post_order',
			[
				'label'     => esc_html__( 'Post Order', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'asc'  => esc_html__( 'ASC', 'advkt-elementor' ),
					'desc' => esc_html__( 'DESC', 'advkt-elementor' ),
				],
				'default'   => 'desc',
			]
		);

		$this->add_control(
			'cat',
			[
				'label'       => __( 'Category Slug', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter Category Slug', 'advkt-elementor' ),
				'label_block' => true,				
			]
		);

		$this->add_control(
			'service_link_text',
			[
				'label'       => esc_html__( 'Service Button Text', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Read More ', 'advkt-elementor' ),
				'placeholder' => esc_html__( 'Link Text', 'advkt-elementor' ),
				'label_block' => true
			]
		);		

		$this->add_control(
			'service_icon_name',
			[
				'label'       => esc_html__( 'Service btn Icon Name', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'fa-solid fa-angle-right', 'advkt-elementor' ),
				'placeholder' => esc_html__( 'icon name here', 'advkt-elementor' ),
				'label_block' => true
			]
		);

		$this->add_control(
			'service_btn_on',
			[
				'label'   => esc_html__( 'Service BTN Switch', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'service_icon_on',
			[
				'label'   => esc_html__( 'Service icon Switch', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [
					'service_btn_on' => 'yes'
				],
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'advkt-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'advkt-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		
		$this->end_controls_section();

		/** Heading typography **/
		$this->start_controls_section(
			'portfolio_heading_style',
			[
				'label' => esc_html__( 'Heading Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'portfolio_heading_typography',
				'selector' => '{{WRAPPER}} .all-portfolios .portfolio-wrapper .portfolio-card h3.title',
			]
		);


		$this->add_control(
			'portfolio_heading_color',
			[
				'label' => __( 'Color', 'advkt-elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .all-portfolios .portfolio-wrapper .portfolio-card h3.title' => 'color: {{VALUE}};',
				]
			]
		);

		$this->end_controls_section();

		/** content typography **/
		$this->start_controls_section(
			'portfolio_content_style',
			[
				'label' => esc_html__( 'Content Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'portfolio_content_typography',
				'selector' => '{{WRAPPER}} .all-portfolios .portfolio-wrapper .content .short-title',
			]
		);


		$this->add_control(
			'portfolio_content_color',
			[
				'label' => __( 'Color', 'advkt-elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .all-portfolios .portfolio-wrapper .content .short-title' => 'color: {{VALUE}};',
				]
			]
		);

		$this->end_controls_section();

		/** icon typography **/
		$this->start_controls_section(
			'portfolio_icon_style',
			[
				'label' => esc_html__( 'Icon Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs(
			'portfolio_link_style_tabs'
		);

		$this->start_controls_tab(
			'portfolio_link_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'textdomain' ),
			]
		);

		$this->add_responsive_control(
			'portfolio_icon_size',
			[
				'label' => __( 'Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .portfolio-card .btn-wrapper .circle-btn' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'portfolio_icon_color',
			[
				'label' => __( 'Color', 'advkt-elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .portfolio-card .btn-wrapper .circle-btn' => 'color: {{VALUE}};',
				]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'portfolio_icon_border_style',
				'selector' => '{{WRAPPER}} .portfolio-card .btn-wrapper .circle-btn',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'portfolio_icon_background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .portfolio-card .btn-wrapper .circle-btn',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'style_hover_tab',
			[
				'label' => esc_html__( 'Hover', 'textdomain' ),
			]
		);

		$this->add_control(
			'portfolio_icon_hover_color',
			[
				'label' => __( 'Color', 'advkt-elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .portfolio-card:hover .btn-wrapper .circle-btn' => 'color: {{VALUE}};',
				]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'portfolio_icon_hover_border_style',
				'selector' => '{{WRAPPER}} .portfolio-card:hover .btn-wrapper .circle-btn',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'portfolio_icon_hover_background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .portfolio-card:hover .btn-wrapper .circle-btn',
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();


	}

	public function render() {

		$settings  = $this->get_settings_for_display(); 
		extract( $settings );
		?>

            <!--- Portfolio Start !-->
            <div class="all-portfolios ">
                <div class="container">
                    <div class="row">
                        <div class="col-12">
                            <div class="portfolio-wrapper">

                                <?php 
                                if( !empty($cat->term_id) ){
                                    $q = new \WP_Query(array(
                                        'post_type'     => 'advkt-portfolio',
                                        'posts_per_page'=> $post_number,
                                        'orderby' 		=> 'menu_order '.$orderby,
                                        'order'			=> $post_order,
                                        'tax_query' => array(
                                            array(
                                                'taxonomy' => 'portfolio_categories',
                                                'field'    => 'term_id',
                                                'terms'    => array( $term_id ),
                                                'operator' => 'IN',
                                            ),
                                        ),
                                    ));
                                
                                }else{
                                    $q = new \WP_Query(array(
                                        'post_type'     => 'advkt-portfolio',
                                        'posts_per_page'=> $post_number,
                                        'orderby' 		=> 'menu_order '.$orderby,
                                        'order'			=> $post_order,
                                    ));
                                }
                                    
                                if($q->have_posts()):
                                    while($q->have_posts()): $q->the_post(); 
                                    $tiny_content = get_post_meta(get_the_ID(), 'portfolio_tiny_content', true);
                                    ?>
									
                                <div class="portfolio-card">
                                    <h3 class="title"><a href="<?php the_permalink(); ?>"><?php echo wp_trim_words( get_the_title(), $heading_word_count, '' ); ?></a></h3>
                                    <div class="content">
                                        <span class="short-title"><?php echo wp_trim_words( $tiny_content, $content_word_count, '' ); ?></span>
                                        <div class="image">
                                            <img src="<?php echo the_post_thumbnail_url('transco-portfolio-thumb'); ?>" alt="Image"/>
                                        </div>
                                    </div>
                                    <div class="btn-wrapper">
                                        <a href="<?php the_permalink(); ?>" class="circle-btn"><i class="fa-light fa-arrow-right-long"></i></a>
                                    </div>
                                </div>


                                    
                                    <?php 
                                    endwhile; 
                                    wp_reset_postdata(); 
                                endif; 
                                ?>

                

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--- Portfolio End !-->

	<?php
	}

}