<?php
namespace AdvktElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class AdvktPortfolioGrid extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'advkt-portfolio-grid';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'AT Portfolio Grid', 'advkt-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-post-content';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'advkt-elementor' ];
	}

	public function get_keywords() {
		return [ 'portfolio' ];
	}

	public function get_script_depends() {
		return [ 'advkt-elementor'];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content_portfolio_post',
			[
				'label' => esc_html__( 'Portfolio Post', 'advkt-elementor' ),
			]
		);

        $this->add_control(
			'heading_word_count',
			[
				'label'       => __( 'Heading Word Count', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Heading Words Number', 'advkt-elementor' ),
				'default'   => 7,				
			]
		);

        $this->add_control(
			'post_number',
			[
				'label'     => esc_html__( 'Post Count', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'1'  => esc_html__( '1', 'advkt-elementor' ),
					'2'  => esc_html__( '2', 'advkt-elementor' ),
					'3'  => esc_html__( '3', 'advkt-elementor' ),
					'4'  => esc_html__( '4', 'advkt-elementor' ),
					'5'  => esc_html__( '5', 'advkt-elementor' ),
					'6' => esc_html__( '6', 'advkt-elementor' ),
					'7' => esc_html__( '7', 'advkt-elementor' ),
					'8' => esc_html__( '8', 'advkt-elementor' ),
					'9' => esc_html__( '9', 'advkt-elementor' ),
					'10' => esc_html__( '10', 'advkt-elementor' ),
					'-1' => esc_html__( 'Show All', 'advkt-elementor' ),
				],
				'default'   => '3',
			]
		);


        $this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'ID'  => esc_html__( 'Post ID', 'advkt-elementor' ),
					'title'  => esc_html__( 'Title', 'advkt-elementor' ),
					'date' => esc_html__( 'Date', 'advkt-elementor' ),
					'modified' => esc_html__( 'Last Modified Date', 'advkt-elementor' ),
					'rand' => esc_html__( 'Random Order', 'advkt-elementor' ),
					'comment_count' => esc_html__( 'Popular Post', 'advkt-elementor' ),
				],
				'default'   => 'ID',
			]
		);

		$this->add_control(
			'post_order',
			[
				'label'     => esc_html__( 'Post Order', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'asc'  => esc_html__( 'ASC', 'advkt-elementor' ),
					'desc' => esc_html__( 'DESC', 'advkt-elementor' ),
				],
				'default'   => 'desc',
			]
		);

		$this->end_controls_section();

		/** Start Style **/


		/** Start Tabs **/
		        
        $this->start_controls_section(
			'portfolio_grid_tabs_style',
			[
				'label' => esc_html__( 'Menu Items', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs(
			'portfolio_grid_tabs_style_tabs'
		);

		$this->start_controls_tab(
			'portfolio_grid_tabs_style_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'advkt-elementor' ),
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'portfolio_grid_tabs_typography',
				'label' => esc_html__( 'Typography', 'advkt-elementor' ),
				'selector' => '{{WRAPPER}} .portfolio-filter li',
			]
		);
        $this->add_responsive_control(
			'portfolio_grid_tabs_active_color',
			[
				'label' => esc_html__( 'Active Color', 'advkt-elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .portfolio-filter li.active' => 'color: {{VALUE}} !important;',
				],
			]
		);
		$this->add_responsive_control(
			'portfolio_grid_tabs_color',
			[
				'label' => esc_html__( 'Color', 'advkt-elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .portfolio-filter li' => 'color: {{VALUE}} !important;',
				],
			]
		);

		$this->add_responsive_control(
			'portfolio_grid_tabs_padding',
			[
				'label'      => esc_html__('Padding', 'advkt-elementor'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .portfolio-filter li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'portfolio_grid_tabs_margin',
			[
				'label'      => esc_html__('Margin', 'advkt-elementor'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .portfolio-filter li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'portfolio_grid_tabs_style_hover_tab',
			[
				'label' => esc_html__( 'Hover', 'advkt-elementor' ),
			]
		);

		$this->add_responsive_control(
			'portfolio_grid_tabs_hover_color',
			[
				'label' => esc_html__( 'Color', 'advkt-elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .portfolio-filter li:hover' => 'color: {{VALUE}} !important;',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		/** End Tabs **/

		/** Start Image Card **/
		        
        $this->start_controls_section(
			'portfolio_grid_img_card_style',
			[
				'label' => esc_html__( 'Image Card', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'portfolio_grid_img_card_color',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .portfolio-style-two .content-wrapper',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'portfolio_grid_img_card_border',
				'selector' => '{{WRAPPER}} .portfolio-style-two',
			]
		);

		$this->add_responsive_control(
			'portfolio_grid_img_card_border_radius',
			[
				'label'      => esc_html__('Border Radius', 'advkt-elementor'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .portfolio-style-two' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
		/** End Image Card **/


		/** Start Title **/	
		$this->start_controls_section(
			'portfolio_grid_card_title_style',
			[
				'label' => esc_html__( 'Image Card Title', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs(
			'portfolio_grid_card_title_style_tabs'
		);

		$this->start_controls_tab(
			'portfolio_grid_card_title_style_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'advkt-elementor' ),
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'portfolio_grid_card_title_typography',
				'label' => esc_html__( 'Typography', 'advkt-elementor' ),
				'selector' => '{{WRAPPER}} .portfolio-style-two .content-wrapper .content .title a',
			]
		);

		$this->add_responsive_control(
			'portfolio_grid_card_title_color',
			[
				'label' => esc_html__( 'Color', 'advkt-elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .portfolio-style-two .content-wrapper .content .title a' => 'color: {{VALUE}} !important;',
				],
			]
		);

		$this->add_responsive_control(
			'portfolio_grid_card_title_padding',
			[
				'label'      => esc_html__('Padding', 'advkt-elementor'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .portfolio-style-two .content-wrapper .content .title a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'portfolio_grid_card_title_margin',
			[
				'label'      => esc_html__('Margin', 'advkt-elementor'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .portfolio-style-two .content-wrapper .content .title a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'portfolio_grid_card_title_style_hover_tab',
			[
				'label' => esc_html__( 'Hover', 'advkt-elementor' ),
			]
		);

		$this->add_responsive_control(
			'portfolio_grid_card_title_hover_color',
			[
				'label' => esc_html__( 'Color', 'advkt-elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .portfolio-style-two .content-wrapper .content .title a:hover' => 'color: {{VALUE}} !important;',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		/** End Title **/

		/** Start Button **/
				
		$this->start_controls_section(
			'portfolio_grid_card_button_style',
			[
				'label' => esc_html__( 'Image Card Button', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs(
			'portfolio_grid_card_button_style_tabs'
		);

		$this->start_controls_tab(
			'portfolio_grid_card_button_style_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'advkt-elementor' ),
			]
		);

		

		$this->add_responsive_control(
			'portfolio_grid_card_btn_btn_bg_color',
			[
				'label' => esc_html__( 'Background color', 'advkt-elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .portfolio-style-two .content-wrapper .content .btn-wrapper a' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'portfolio_grid_card_btn_width',
			[
				'label' => __( 'Width', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .portfolio-style-two .content-wrapper .content .btn-wrapper a' => 'width: {{SIZE}}{{UNIT}};',
				],

			]
		);
		$this->add_responsive_control(
			'portfolio_grid_card_btn_height',
			[
				'label' => __( 'Height', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .portfolio-style-two .content-wrapper .content .btn-wrapper a' => 'height: {{SIZE}}{{UNIT}};',
				],

			]
		);
		$this->add_responsive_control(
			'portfolio_grid_card_btn_border_radius',
			[
				'label' => __( 'Border Radius', 'advkt-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .portfolio-style-two .content-wrapper .content .btn-wrapper a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'portfolio_grid_card_btn_icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'advkt-elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .portfolio-style-two .content-wrapper .content .btn-wrapper a i' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'portfolio_grid_card_btn_icon_font_size',
			[
				'label' => __( 'Icon Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .portfolio-style-two .content-wrapper .content .btn-wrapper a i' => 'font-size: {{SIZE}}{{UNIT}};',
				],

			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'portfolio_grid_card_button_style_hover_tab',
			[
				'label' => esc_html__( 'Hover', 'advkt-elementor' ),
			]
		);

		$this->add_responsive_control(
			'portfolio_grid_card_btn_bg_hover_color',
			[
				'label' => esc_html__( 'Background Color', 'advkt-elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .portfolio-style-two .content-wrapper .content .btn-wrapper a:hover' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'portfolio_grid_card_btn_icon_hover_color',
			[
				'label' => esc_html__( 'Icon Color', 'advkt-elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .portfolio-style-two .content-wrapper .content .btn-wrapper a i:hover' => 'color: {{VALUE}} !important;',
				],
			]
		);
		
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		/** End Button **/

		/** End Style **/

	}

	public function render() {

		$settings  = $this->get_settings_for_display(); 
		extract( $settings );


	    $q = new \WP_Query(array(
	    	'posts_per_page' => $post_number,
	    	'post_type' => 'advkt-portfolio',
	    	'orderby' => 'menu_order '.$orderby,
	    	'order' => $post_order
	    ));
	    

	    //other style
	    $args = array(
	    	'posts_per_page' => $post_number,
	    	'post_type' => 'advkt-portfolio',
	    	'orderby' => 'menu_order '.$orderby,
	    	'order' => $post_order
	    );
	    $filteArr = array();
	    $postArr = new \WP_Query($args);

	    if( is_array($postArr->posts) && !empty($postArr->posts) ) {

	        foreach($postArr->posts as $item) {
	            $taxsArr = wp_get_post_terms($item->ID, 'portfolio_categories', array("fields" => "all"));
	            if(is_array($taxsArr) && !empty($taxsArr)) {
	                foreach($taxsArr as $tax) {
	                    $filteArr[$tax->slug] = $tax->name;
	                }
	            }
	        }
	    }

	    if( is_array($filteArr) && !empty($filteArr) ): ?>
			<div class="portfolio-filter-area style-1">
				<div class="container-fluid">
					<div class="row">
						<div class="col-lg-12">
							<ul class="portfolio-filter">
								<li class="active" data-filter="*">All</li>
								<?php 
								foreach($filteArr as $tax_slug => $tax_name) { ?>
								<li data-filter=".<?php print esc_attr($tax_slug); ?>"><?php print esc_html($tax_name); ?></li>
								<?php 
								}
								?>
							</ul>
						</div>
					</div>
					<div class="isotope-grid">
						<div class="row gy-4">



							<?php 
										$j = 0;
										while($q->have_posts()) : $q->the_post(); 
										$sub_title = get_post_meta(get_the_ID(), 'portfolio_service_sub_title', true);
										$featured_image = get_post_meta(get_the_ID(), 'portfolio_featured_img', true);

										$j++;   
										$item_classes = '';
										$item_cats = get_the_terms( get_the_id(), 'portfolio_categories' );
										if($item_cats):
											foreach($item_cats as $item_cat) {
												$item_classes .= $item_cat->slug . ' ';
											}
										endif;//endif
										?>

										<div class="col-lg-3 col-md-6 masonry-portfolio-item <?php echo esc_attr($item_classes); ?>">
											<div class="portfolio-style-two">
												<div class="image">
													<?php
													if( $featured_image !== "" ): ?>
															<img src="<?php echo esc_url($featured_image); ?>" alt="post-1">
														
													<?php
													else: ?>
														
														<?php 
														if( has_post_thumbnail() ): ?>
															<?php the_post_thumbnail(); ?>
														<?php 
														endif; ?>

													<?php
													endif; ?>

													<div class="content-wrapper">
														<div class="content">
															<div class="content-inner">
																<h3 class="title"><a href="<?php the_permalink(); ?>"><?php echo wp_trim_words(get_the_title(), $heading_word_count, '' ); ?></a></h3>
															</div>
															<div class="btn-wrapper">
																<a href="<?php the_permalink(); ?>"><i class="fa-regular fa-plus"></i></a>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>

										<?php   
										endwhile; 
										wp_reset_postdata(); ?>

						</div>
					</div>
				</div>
			</div>
			<!-- Portfolio Area Start -->
		<?php endif; ?>
	<?php
	}

}