<?php
namespace AdvktElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Advkt Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class AdvktFreeConsultation extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Advkt Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'advkt-free-consultation';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Advkt Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Free Consultation', 'advkt-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Boomdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-table';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Boomdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'advkt-elementor' ];
	}

	public function get_keywords() {
		return [ 'quote' ];
	}

	public function get_script_depends() {
		return [ 'advkt-elementor'];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content_heading',
			[
				'label' => esc_html__( 'Free Consultation Section', 'advkt-elementor' ),
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'advkt-elementor' ),
				'default'     => __( 'It is Heading', 'advkt-elementor' ),
				'label_block' => true
			]
		);

        $this->add_control(
			'shortcode',
			[
				'label'   => esc_html__( 'Shortcode', 'advkt-elementor' ),
				'type'    => Controls_Manager::TEXT,
				'dynamic' => [ 'active' => true ],
				'default'		=> __('Contact Shortcode here', 'advkt-elementor'),
				'description' => esc_html__( 'Add Your shortcode here', 'advkt-elementor' ),
				'label_block' => true,
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'advkt-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'advkt-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->add_control(
			'show_heading_section',
			[
				'label'   => esc_html__( 'Show Heading Section', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	


		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [
					'show_heading_section' => 'yes'
				],
			]
		);	


		$this->end_controls_section();

		/** typography **/
		$this->start_controls_section(
			'feature_style',
			[
				'label' => esc_html__( 'Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'free_consultation_heading_color',
			[
				'label' => esc_html__( 'Heading Color', 'augmit-elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .el-section-title .el-title' => 'color: {{VALUE}} !important',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'free_consultation_heading_typography',
				'selector' => '{{WRAPPER}} .el-section-title .el-title',
			]
		);

		$this->add_responsive_control(
			'free_consultation_bg_color',
			[
				'label' => esc_html__( 'Background Color', 'eyewell-elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .comment-respond.style-2 .comment-respond-wrapper::before' => 'background: {{VALUE}} !important',
				],
			]
		);

		$this->end_controls_section();

					
/** Start Button **/
$this->start_controls_section(
    'banner_btn_style',
    [
        'label' => esc_html__( 'Button', 'eyewell-elementor'),
        'tab' => Controls_Manager::TAB_STYLE,
        
    ]
);

$this->start_controls_tabs(
    'banner_btn_style_tabs'
);

$this->start_controls_tab(
    'banner_btn_style_normal_tab',
    [
        'label' => esc_html__( 'Normal', 'eyewell-elementor' ),
    ]
);
$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'banner_btn_typography',
        'selector' => '{{WRAPPER}} .comment-respond.style-2 .form-field-wrapper .single-input-field .btn',
    ]
);

$this->add_responsive_control(
    'banner_btn_text_color',
    [
        'label' => esc_html__( 'Text Color', 'eyewell-elementor' ),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .comment-respond.style-2 .form-field-wrapper .single-input-field .btn' => 'color: {{VALUE}} !important',
        ],
    ]
);

$this->add_responsive_control(
    'banner_btn_bg_color',
    [
        'label' => esc_html__( 'Background Color', 'eyewell-elementor' ),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .comment-respond.style-2 .form-field-wrapper .single-input-field .btn' => 'background: {{VALUE}} !important',
        ],
    ]
);

$this->add_responsive_control(
    'banner_btn_margin',
    [
        'label' => esc_html__( 'Margin', 'eyewell-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' => [
            '{{WRAPPER}} .comment-respond.style-2 .form-field-wrapper .single-input-field .btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'banner_btn_padding',
    [
        'label' => esc_html__( 'Padding', 'eyewell-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' => [
            '{{WRAPPER}} .comment-respond.style-2 .form-field-wrapper .single-input-field .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);


$this->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name' => 'banner_btn_border_border',
        'selector' => '{{WRAPPER}} .comment-respond.style-2 .form-field-wrapper .single-input-field input.btn, {{WRAPPER}} .comment-respond.style-2 input.btn, {{WRAPPER}} .comment-respond input.btn',
    ]
);

$this->add_responsive_control(
    'banner_btn_border_radius',
    [
        'label' => esc_html__( 'Border Radius', 'eyewell-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' => [
            '{{WRAPPER}} .comment-respond.style-2 .form-field-wrapper .single-input-field .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->end_controls_tab();

$this->start_controls_tab(
    'banner_btn_style_hover_tab',
    [
        'label' => esc_html__( 'Hover', 'eyewell-elementor' ),
    ]
);

$this->add_responsive_control(
    'banner_btn_hover_color',
    [
        'label' => esc_html__( 'Color', 'eyewell-elementor' ),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .comment-respond.style-2 .form-field-wrapper .single-input-field .btn:hover' => 'color: {{VALUE}} !important',
        ],
    ]
);

$this->add_responsive_control(
    'banner_btn_bg_hover_color',
    [
        'label' => esc_html__( 'Background Color', 'eyewell-elementor' ),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .comment-respond.style-2 .form-field-wrapper .single-input-field .btn:hover' => 'background: {{VALUE}} !important',
        ],
    ]
);

$this->add_responsive_control(
    'banner_btn_icon_hover_color',
    [
        'label' => esc_html__( 'Icon Color', 'eyewell-elementor' ),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .comment-respond.style-2 .form-field-wrapper .single-input-field .btn:hover i' => 'color: {{VALUE}} !important',
        ],
    ]
);

$this->end_controls_tab();
$this->end_controls_tabs();
$this->end_controls_section();	


		
		
	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract( $settings );
		?>
        <!-- Comment Form Start -->
        <div class="request-form-area el-section-title">
            <div class="comment-respond style-2">
                <div class="comment-form">
                    <div class="container">
                        <div class="row gx-2">
                            <div class="comment-respond-wrapper">
                                <?php 
                                if (( '' !== $heading ) && ( $show_heading )) : ?>
                                    <h2 class="form-title el-title"><?php echo wp_kses_post( $heading ); ?></h2>
                                <?php 
                                endif; ?>

                                <?php echo do_shortcode(html_entity_decode( $shortcode )); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Comment Form End -->

	<?php
	}
}