<?php
namespace AdvktElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Advkt Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class AdvktFeatures extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Advkt Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'advkt-features';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Advkt Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Features List', 'advkt-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Boomdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-bullet-list';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Boomdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'advkt-elementor' ];
	}

	public function get_keywords() {
		return [ 'features' ];
	}

	public function get_script_depends() {
		return [ 'advkt-elementor'];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_features_heading',
			[
				'label' => esc_html__( 'Features Section', 'advkt-elementor' ),
			]	
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Chose Style', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'feature-style-1'  => esc_html__( 'Feature Style 1', 'advkt-elementor' ),
					'feature-style-2' => esc_html__( 'Feature Style 2', 'advkt-elementor' )
				],
				'default'   => 'feature-style-1',
			]
		);



		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Feature Items', 'advkt-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'tab_title'   => esc_html__( 'Feature One', 'advkt-elementor' ),
						'tab_content' => esc_html__( 'Focus On Email Marketing', 'advkt-elementor' ),
					],
				],
				'fields' => [	
					[
						'name'        => 'tab_title',
						'label'       => esc_html__( 'Title', 'advkt-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Feature Title' , 'advkt-elementor' ),
						'label_block' => true,
					],
					[
						'name'       => 'tab_content',
						'label'      => esc_html__( 'Content', 'advkt-elementor' ),
						'type'       => Controls_Manager::TEXTAREA,
						'dynamic'    => [ 'active' => true ],
						'default'    => esc_html__( 'Feature Content', 'advkt-elementor' ),
						'show_label' => true,
					],
				    [
						'name'    => 'tab_image',
						'label'   => esc_html__( 'Thumbnail Image', 'advkt-elementor' ),
						'type' => \Elementor\Controls_Manager::MEDIA,
						'default' => [
							'url' => \Elementor\Utils::get_placeholder_image_src(),
						],
						'dynamic' => [ 'active' => true ],
					],
					[
						'name'    => 'tab_icon_image',
						'label'   => esc_html__( 'Icon Image', 'advkt-elementor' ),
						'type' => \Elementor\Controls_Manager::MEDIA,
						'default' => [
							'url' => \Elementor\Utils::get_placeholder_image_src(),
						],
						'dynamic' => [ 'active' => true ],
					],				
					[
						'name'        => 'tab_icon_text',
						'label'       => esc_html__( 'Icon Text', 'advkt-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( '' , 'advkt-elementor' ),
						'label_block' => true,
					],		
		
					[
						'name'        => 'tab_link',
						'label'       => esc_html__( 'Link', 'advkt-elementor' ),
						'type'        => Controls_Manager::URL,
						'dynamic'     => [ 'active' => true ],
						'placeholder' => 'http://your-link.com',
						'default'     => [
							'url' => '#',
						],
					],
				],
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'advkt-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'advkt-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'advkt-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'advkt-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'advkt-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'advkt-elementor' ),
						'icon' => 'eicon-text-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
			]
		);

		$this->add_control(
			'show_icon_image',
			[
				'label'   => esc_html__( 'Show Icon Image', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_icon_text',
			[
				'label'   => esc_html__( 'Show Icon Text', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_image',
			[
				'label'   => esc_html__( 'Show Image', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_title',
			[
				'label'   => esc_html__( 'Show Title', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_content',
			[
				'label'   => esc_html__( 'Show Content', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_button',
			[
				'label'   => esc_html__( 'Show Button', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

		/** typography **/
		$this->start_controls_section(
			'heading_style',
			[
				'label' => esc_html__( 'Heading Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
            'feature_heading_font_color',
            [
                'label' => __( 'Heading color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .process-step .content .title' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'heading_typography',
				'selector' => '{{WRAPPER}} .process-step .content .title',
			]
		);

		$this->end_controls_section();

		/** typography **/
		$this->start_controls_section(
			'divider_style',
			[
				'label' => esc_html__( 'Divider Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'types' => [ 'gradient',],
				'selector' => '{{WRAPPER}} .process-step .divider',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'banner_btn_border_border',
				'selector' => '{{WRAPPER}} .process-step .divider span',
			]
		);

		$this->end_controls_section();
		
		$this->start_controls_section(
			'content_style',
			[
				'label' => esc_html__( 'Content Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'feature_content_color',
			[
				'label' => esc_html__( 'Content color', 'advkt-elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .process-step .content .desc' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'feature_content_typography',
				'selector' => '{{WRAPPER}} .process-step .content .desc',
			]
		);




		$this->end_controls_section();

		$this->start_controls_section(
			'btn_style',
			[
				'label' => esc_html__( 'Link Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'feature_btn_text_color',
			[
				'label' => esc_html__( 'Icon color', 'advkt-elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .process-step .content .read-more-btn' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'feature_btn_bg_color',
			[
				'label' => esc_html__( 'Background color', 'advkt-elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .process-step .content .read-more-btn' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract( $settings );
				        

						
		if( $chose_style == 'feature-style-1' ): ?>

    <!-- Feature Area Start-->
	<div class="all-services el-services style-1">
		<div class="container">
			<div class="row gy-5">

				<?php 
				foreach ( $settings['tabs'] as $item ) :
					extract( $item );
					$this->add_render_attribute(
						[
							'feature-link' => [
								'href'   => $item['tab_link']['url'] ? esc_url($item['tab_link']['url']) : '#',
								'target' => $item['tab_link']['is_external'] ? '_blank' : '_self'
							]
						], '', '', true
					); ?>

					<div class="col-md-6 col-lg-3">
						<!-- single info-card start -->
						<div class="info-card ">
							<div class="info-card-inner">
								<div class="content-wrapper">
									<div class="title-wrapper">

										<?php				
										if ( '' !== $item['tab_icon_image'] && $settings['show_icon_image'] === 'yes' ) : 
										$icon_image_src = wp_get_attachment_image_src( $item['tab_icon']['id'], 'full' );
										$tab_icon_image_url = $icon_image_src ? $icon_image_src[0] : ''; ?>
											<div class="icon">
												<img src="<?php echo esc_url($tab_icon_image_url ); ?>" alt="<?php echo esc_attr__('icon', 'advkt-elementor'); ?>">
											</div>
										<?php
										elseif( '' !== $item['tab_icon_text'] && $settings['show_icon_text'] === 'yes' ): ?>
											<div class="icon">
												<i class="<?php echo esc_attr( $item['tab_icon_text'] ); ?>"></i>
											</div>
										<?php 
										endif; ?>

										<?php 
										if ( '' !== $item['tab_title'] && $settings['show_title'] === 'yes' ) : ?>
											<h2 class="title"><?php echo wp_kses_post($item['tab_title']); ?></h2>
										<?php 
										endif; ?>
									</div>

									<div class="content">
										<?php 
										if ( '' !== $item['tab_content'] && $settings['show_content'] === 'yes' ) : ?>
											<p class="desc"><?php echo wp_kses_post($item['tab_content']); ?></p>
										<?php endif; ?>	
									</div>

									<?php				
									if ( '' !== $item['tab_image'] && $settings['show_image'] === 'yes' ) : 
									$image_src = wp_get_attachment_image_src( $item['tab_image']['id'], 'full' );
									$image = $image_src ? $image_src[0] : ''; 
									?>
										<div class="thumbnail-wrapper">
											<div class="thumbnail-inner">
												<img src="<?php print esc_url($image); ?>" alt="support" />
											</div>
										</div>
									<?php 
									endif; ?>

									<?php 
									if( $show_button == 'yes' && $settings['show_button'] === 'yes' ): ?>
										<div class="read-more">
											<a <?php echo $this->get_render_attribute_string( 'feature-link' ); ?>>
												<i class="fa-sharp fa-solid fa-period"></i>
												<i class="fa-sharp fa-solid fa-period"></i>
												<i class="fa-sharp fa-solid fa-period"></i>
												<i class="fa-sharp fa-solid fa-period"></i>
											</a>
										</div>
									<?php 
									endif; ?>			
								</div>
							</div>
						</div>
						<!-- single info-card End-->
					</div>
				<?php
				endforeach; ?>

					</div>
				</div>
			</div>
			<!-- Feature Area End !-->

		<?php 
		elseif ($chose_style == 'feature-style-2') : ?>
		<div class="all-process-steps">
			<div class="container">
				<div class="row">
					<div class="col-12">
						<div class="process-step-wrapper">
					<?php 
					foreach ( $settings['tabs'] as $item ) :
						extract( $item );
						$this->add_render_attribute(
							[
								'feature-link' => [
									'href'   => $item['tab_link']['url'] ? esc_url($item['tab_link']['url']) : '#',
									'target' => $item['tab_link']['is_external'] ? '_blank' : '_self'
								]
							], '', '', true
						); ?>

						<!-- Single Process Step Start -->
						<div class="process-step style-1">

							<?php				
							if ( '' !== $item['tab_icon_image'] && $settings['show_icon_image'] === 'yes' ) : 
							$icon_image_src = wp_get_attachment_image_src( $item['tab_icon']['id'], 'full' );
							$tab_icon_image_url = $icon_image_src ? $icon_image_src[0] : ''; ?>
								<div class="icon">
									<img src="<?php echo esc_url($tab_icon_image_url ); ?>" alt="<?php echo esc_attr__('icon', 'advkt-elementor'); ?>">
								</div>
							<?php
							elseif( '' !== $item['tab_icon_text'] && $settings['show_icon_text'] === 'yes' ): ?>
								<div class="icon">
									<i class="<?php echo esc_attr( $item['tab_icon_text'] ); ?>"></i>
								</div>
							<?php 
							endif; ?>

							<div class="divider">
								<span></span>
							</div>
							<div class="content">
								<?php 
								if ( '' !== $item['tab_title'] && $settings['show_title'] === 'yes' ) : ?>
									<h2 class="title"><a <?php echo $this->get_render_attribute_string( 'feature-link' ); ?>><?php echo wp_kses_post($item['tab_title']); ?></a></h2>
								<?php 
								endif; ?>

								<?php 
								if ( '' !== $item['tab_content'] && $settings['show_content'] === 'yes' ) : ?>
									<p class="desc"><?php echo wp_kses_post($item['tab_content']); ?></p>
								<?php endif; ?>

								<?php 
								if( $show_button == 'yes' && $settings['show_button'] === 'yes' ): ?>
									<a <?php echo $this->get_render_attribute_string( 'feature-link' ); ?> class="read-more-btn"><i class="fa-regular fa-arrow-down-long"></i></a>
								<?php
								endif; ?>
							</div>
						</div>
						<!-- Single Process Step End -->
						<?php
					endforeach; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
		<?php 
		endif; ?>	
	<?php
	}
}