<?php
namespace AdvktElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Advkt Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class AdvktFaq extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Advkt Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'advkt-faq';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Advkt Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'AT FAQ', 'advkt-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Boomdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-plus';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Boomdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'advkt-elementor' ];
	}

	public function get_keywords() {
		return [ 'faq' ];
	}

	public function get_script_depends() {
		return [ 'advkt-elementor'];
	}

	protected function register_controls() {


		$this->start_controls_section(
			'section_content_faq',
			[
				'label' => esc_html__( 'FAQ', 'advkt-elementor' ),
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Analysis Tab Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'tab_title'   => esc_html__( 'Analysis #1', 'bdevs-elementor' ),
						'tab_content' => esc_html__( 'I am item content. Click edit button to change this text.', 'bdevs-elementor' ),
					],
					[
						'tab_title'   => esc_html__( 'Analysis #1', 'bdevs-elementor' ),
						'tab_content' => esc_html__( 'I am item content. Click edit button to change this text.', 'bdevs-elementor' ),
					]
				],
				'fields' => [					
					[
						'name'        => 'tab_title',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Its Title' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'       => 'tab_content',
						'label'      => esc_html__( 'Content', 'bdevs-elementor' ),
						'type'       => Controls_Manager::WYSIWYG,
						'dynamic'    => [ 'active' => true ],
						'default'    => esc_html__( 'Its Content', 'bdevs-elementor' ),
						'show_label' => true,
					],
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'advkt-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'advkt-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);


		$this->end_controls_section();

		
		/** typography **/
		$this->start_controls_section(
			'icon_style',
			[
				'label' => esc_html__( 'Icon Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		
		$this->add_control(
            'faq_heading_icon_color',
            [
                'label' => __( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .accordion-wrapper .accordion-list-item .accordion-head::before' => 'color: {{VALUE}} !important;',
                ]
            ]
        );

		$this->end_controls_section();
		
		/** typography **/
		$this->start_controls_section(
			'heading_style',
			[
				'label' => esc_html__( 'Heading Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		
		$this->add_control(
            'faq_heading_font_color',
            [
                'label' => __( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .accordion-wrapper .accordion-list-item .accordion-head .accordion-title' => 'color: {{VALUE}} !important;',
                ]
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'faq_heading_typography',
				'selector' => '{{WRAPPER}} .accordion-wrapper .accordion-list-item .accordion-head .accordion-title',
			]
		);


		$this->end_controls_section();


		/** Content Typography **/
		$this->start_controls_section(
			'faq_content_style',
			[
				'label' => esc_html__( 'Content Style', 'eyewell-elementor'),
				'tab' => Controls_Manager::TAB_STYLE,
				
			]
		);
		
		$this->add_control(
            'faq_des_font_color',
            [
                'label' => __( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .accordion-wrapper .accordion-list-item .accordion-item-body p' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'faq_des_typography',
				'selector' => '{{WRAPPER}} .accordion-wrapper .accordion-list-item .accordion-item-body p',
			]
		);
		$this->end_controls_section();


	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract( $settings );
		$sentence = 'faq-';
		$faq_id = str_replace(' ', '', strtolower($sentence));
		$faq_id .= mt_rand();
		?>

			<!-- Accordion Start -->
			<div class="accordion-wrapper style-1">
				<div class="accordion-box-wrapper" id="appointmentAreaStyle1FAQ-<?php echo esc_attr($faq_id); ?>">
					<?php 
					foreach ( $settings['tabs'] as $key => $item ) :
						$active_class = ($key == 0 ) ? '' : 'collapsed';
						$show = ($key == 0 ) ? 'show' : '';
						?>
						<div class="accordion-list-item">
							<div id="heading-<?php print esc_attr($item['_id']); ?>">
								<div class="accordion-head <?php echo esc_attr( $active_class ); ?>" data-bs-toggle="collapse" data-bs-target="#collapse-<?php print esc_attr($item['_id']); ?>" aria-expanded="true" aria-controls="collapse-<?php print esc_attr($item['_id']); ?>">
									<h3 class="accordion-title"><?php echo wp_kses_post($item['tab_title']); ?></h3>
								</div>
							</div>
							<div id="collapse-<?php print esc_attr($item['_id']); ?>" class="accordion-collapse collapse <?php print esc_attr($show); ?>" aria-labelledby="heading-<?php print esc_attr($item['_id']); ?>" data-bs-parent="#appointmentAreaStyle1FAQ-<?php print esc_attr( $faq_id ); ?>">
								<div class="accordion-item-body">
									<p><?php echo wp_kses_post($item['tab_content']); ?></p>
								</div>
							</div>
						</div>
					<?php
					endforeach;
					?>
				</div>
			</div>
			<!-- Accordion End -->
	<?php
	}
}