<?php
namespace AdvktElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Advkt Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class AdvktFAQImages extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Advkt Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'advkt-faq-images';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Advkt Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'AT FAQ Gallery', 'advkt-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Boomdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-post-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Boomdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'advkt-elementor' ];
	}

	public function get_keywords() {
		return [ 'faq gallery' ];
	}

	public function get_script_depends() {
		return [ 'advkt-elementor'];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content_features',
			[
				'label' => esc_html__( 'About', 'advkt-elementor' ),
			]	
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Chose Style', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'about-style-1'  => esc_html__( 'About Style 1', 'advkt-elementor' ),
					'about-style-2'  => esc_html__( 'About Style 2', 'advkt-elementor' ),
					'about-style-3'  => esc_html__( 'About Style 3', 'advkt-elementor' )
				],
				'default'   => 'about-style-1',
			]
		);

		$this->add_control(
			'heading_icon',
			[
				'label'   => esc_html__( 'Heading Icon', 'advkt-elementor' ),
				'description' => esc_html__( 'Add Your Heading Icon Image', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'dynamic' => [ 'active' => true ],
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your heading', 'advkt-elementor' ),
				'default'     => __( 'It is heading', 'advkt-elementor' ),
				'label_block' => true,
			]
		);	
        

		$this->end_controls_section();


		$this->start_controls_section(
			'faq_images',
			[
				'label' => esc_html__( 'Images', 'advkt-elementor' ),
			]	
		);
		$this->add_control(
			'left_image',
			[
				'label'   => esc_html__( 'Left Image', 'advkt-elementor' ),
				'description' => esc_html__( 'Add Your Shape Image', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'dynamic' => [ 'active' => true ],
			]
		);

		$this->add_control(
			'right_image',
			[
				'label'   => esc_html__( 'Right Image', 'advkt-elementor' ),
				'description' => esc_html__( 'Add Your Shape Image', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'dynamic' => [ 'active' => true ],
			]
		);

        $this->add_control(
			'bottom_image',
			[
				'label'   => esc_html__( 'Bottom Image', 'advkt-elementor' ),
				'description' => esc_html__( 'Add Your Shape Image', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'dynamic' => [ 'active' => true ],
			]
		);


		$this->end_controls_section();


		/** 
		*	Link section 
		**/
		$this->start_controls_section(
			'link_section_content',
			[
				'label' => esc_html__( 'Link Info', 'advkt-elementor' ),
				'condition' => [
					'chose_style' => ['about-style-1', 'about-style-2', 'about-style-3']
				],
			]
		);		

		$this->add_control(
			'link_text',
			[
				'label'       => __( 'Link Text', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Link Text Here...', 'advkt-elementor' ),
				'default'     => __( 'Learn More', 'advkt-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'link',
			[
				'label' => __( 'Link', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'advkt-elementor' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
	
		$this->end_controls_section();


	
		/** 
		*	Layout section 
		**/
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'advkt-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'advkt-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		);

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);			
	
		$this->end_controls_section();

		/** typography **/
		$this->start_controls_section(
			'feature_style',
			[
				'label' => esc_html__( 'Heading Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		
		$this->add_control(
            'fq_heading_color',
            [
                'label' => __( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .faq-gallery .faq-gallery-wrapper .content-card .title' => 'color: {{VALUE}};',
                ]
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'about_quote_typography',
				'selector' => '{{WRAPPER}} .faq-gallery .faq-gallery-wrapper .content-card .title',
			]
		);

		$this->end_controls_section();

		
	/** Start Button **/
	$this->start_controls_section(
		'banner_btn_style',
		[
			'label' => esc_html__( 'Button Style', 'eyewell-elementor'),
			'tab' => Controls_Manager::TAB_STYLE,
			
		]
	);

	$this->start_controls_tabs(
		'style_tabs'
	);


	$this->start_controls_tab(
		'style_normal_tab',
		[
			'label' => esc_html__( 'Normal', 'textdomain' ),
		]
	);

	$this->add_group_control(
		Group_Control_Typography::get_type(),
		[
			'name' => 'banner_btn_typography',
			'selector' => '{{WRAPPER}} .faq-gallery .faq-gallery-wrapper .content-card .btn-wrapper .theme-btn',
		]
	);
	

	$this->add_responsive_control(
		'banner_btn_text_color',
		[
			'label' => esc_html__( 'Text Color', 'eyewell-elementor' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .faq-gallery .faq-gallery-wrapper .content-card .btn-wrapper .theme-btn' => 'color: {{VALUE}} !important',
			],
		]
	);
	
	$this->add_responsive_control(
		'banner_btn_bg_color',
		[
			'label' => esc_html__( 'Background Color', 'eyewell-elementor' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .faq-gallery .faq-gallery-wrapper .content-card .btn-wrapper .theme-btn' => 'background: {{VALUE}} !important',
			],
		]
	);
	
	$this->add_responsive_control(
		'banner_btn_margin',
		[
			'label' => esc_html__( 'Margin', 'eyewell-elementor' ),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
			'selectors' => [
				'{{WRAPPER}} .faq-gallery .faq-gallery-wrapper .content-card .btn-wrapper .theme-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
	
	$this->add_responsive_control(
		'banner_btn_padding',
		[
			'label' => esc_html__( 'Padding', 'eyewell-elementor' ),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
			'selectors' => [
				'{{WRAPPER}} .faq-gallery .faq-gallery-wrapper .content-card .btn-wrapper .theme-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
	
	$this->add_group_control(
		Group_Control_Border::get_type(),
		[
			'name' => 'banner_btn_border_border',
			'selector' => '{{WRAPPER}} .faq-gallery .faq-gallery-wrapper .content-card .btn-wrapper .theme-btn',
		]
	);
	
	$this->add_responsive_control(
		'banner_btn_border_radius',
		[
			'label' => esc_html__( 'Border Radius', 'eyewell-elementor' ),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
			'selectors' => [
				'{{WRAPPER}} .faq-gallery .faq-gallery-wrapper .content-card .btn-wrapper .theme-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);

	$this->end_controls_tab();

	$this->start_controls_tab(
		'style_hover_tab',
		[
			'label' => esc_html__( 'Hover', 'textdomain' ),
		]
	);

	
	$this->add_responsive_control(
		'banner_btn_hover_color',
		[
			'label' => esc_html__( 'Color', 'eyewell-elementor' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .faq-gallery .faq-gallery-wrapper .content-card .btn-wrapper .theme-btn:hover' => 'color: {{VALUE}} !important',
			],
		]
	);

	$this->add_responsive_control(
		'banner_btn_bg_hover_color',
		[
			'label' => esc_html__( 'Background Color', 'eyewell-elementor' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .faq-gallery .faq-gallery-wrapper .content-card .btn-wrapper .theme-btn:hover' => 'background: {{VALUE}} !important',
			],
		]
	);



	$this->end_controls_tab();

	$this->end_controls_section();


	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract($settings);

		$this->add_render_attribute(
			[
				'link' => [
					'href'   => !empty($settings['link']['url']) ? esc_url($settings['link']['url']) : '#',
					'target' => !empty($settings['link']['is_external']) ? '_blank' : '_self'
				]
			], '', '', true
		);



		if( $chose_style == 'about-style-1' ): ?>

<div class="faq-gallery">
    <div class="faq-gallery-item" data-item="1">
        <div class="faq-gallery-wrapper">
            <div class="shape">
                <?php 
                if ( '' !== $settings['bottom_image']['url'] )  : 
                    $thumbnail_bottom_image_src = wp_get_attachment_image_src( $settings['bottom_image']['id'], 'full' );
                    $thumbnail_bottom_image_url = $thumbnail_bottom_image_src ? $thumbnail_bottom_image_src[0] : ''; 
                    ?>
                    <img class="tilt-animate" src="<?php echo esc_url($thumbnail_bottom_image_url); ?>" alt="about top img">
                <?php 
                endif; ?>
            </div>
            <div class="faq-gallery-thumb">
                <?php 
                if ( '' !== $settings['left_image']['url'] )  : 
                    $thumbnail_left_image_src = wp_get_attachment_image_src( $settings['left_image']['id'], 'full' );
                    $thumbnail_left_image_url = $thumbnail_left_image_src ? $thumbnail_left_image_src[0] : ''; 
                    ?>
                    <img class="tilt-animate" src="<?php echo esc_url($thumbnail_left_image_url); ?>" alt="about left img">
                <?php 
                endif; ?>
            </div>
        </div>
    </div>
    <div class="faq-gallery-item" data-item="2">
        <div class="faq-gallery-wrapper">
            <div class="content-card">
                <div class="icon">
                    <?php 
                    if ( '' !== $settings['heading_icon']['url'] )  : 
                        $thumbnail_heading_icon_src = wp_get_attachment_image_src( $settings['heading_icon']['id'], 'full' );
                        $thumbnail_heading_icon_url = $thumbnail_heading_icon_src ? $thumbnail_heading_icon_src[0] : ''; 
                        ?>
                        <img class="tilt-animate" src="<?php echo esc_url($thumbnail_heading_icon_url); ?>" alt="about left img">
                    <?php 
                    endif; ?>
                </div>
                <?php
                if ( ('' !== $heading ) &&  ( $settings['show_heading'] )) : ?>
                    <h3 class="title"><?php echo $heading; ?></h3>
                <?php
                endif; ?>

                <?php 
                if (( ! empty( $settings['link']['url'] )) ): ?>
                    <div class="btn-wrapper">
                        <a <?php echo $this->get_render_attribute_string( 'link' ); ?> class="theme-btn"><?php echo esc_html($settings['link_text']); ?></a>
                    </div>
                <?php 
                endif; ?>
            </div>
        </div>
    </div>
    <div class="faq-gallery-item" data-item="3">
        <div class="faq-gallery-wrapper">
            <div class="faq-gallery-thumb">
                <?php 
                if ( '' !== $settings['right_image']['url'] )  : 
                    $thumbnail_right_image_src = wp_get_attachment_image_src( $settings['right_image']['id'], 'full' );
                    $thumbnail_right_image_url = $thumbnail_right_image_src ? $thumbnail_right_image_src[0] : ''; 
                    ?>
                    <img class="tilt-animate" src="<?php echo esc_url($thumbnail_right_image_url); ?>" alt="about left img">
                <?php 
                endif; ?>
            </div>
        </div>
    </div>
</div>





		<?php 
		elseif( $chose_style == 'about-style-2' ): ?>
		

		<?php 
		endif; ?>	
	<?php
	}
}