<?php
namespace AdvktElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Advkt Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class AdvktCTA extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Advkt Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'advkt-cta';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Advkt Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'CTA', 'advkt-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Boomdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-plus';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Boomdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'advkt-elementor' ];
	}

	public function get_keywords() {
		return [ 'cta' ];
	}

	public function get_script_depends() {
		return [ 'advkt-elementor'];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content_heading',
			[
				'label' => esc_html__( 'Section Faq Heading', 'advkt-elementor' ),
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'advkt-elementor' ),
				'default'     => __( 'It is Heading', 'advkt-elementor' ),
				'label_block' => true
			]
		);

		$this->add_control(
			'desc',
			[
				'label'       => __( 'Description', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your description', 'advkt-elementor' ),
				'default'     => __( 'It is Description', 'advkt-elementor' ),
				'label_block' => true
			]
		);

		$this->end_controls_section();



		$this->start_controls_section(
			'section_content_faq',
			[
				'label' => esc_html__( 'FAQ', 'advkt-elementor' ),
			]
		);

		$this->add_control(
			'analysis_tabs',
			[
				'label' => esc_html__( 'Analysis Tab Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'tab_title'   => esc_html__( 'Analysis #1', 'bdevs-elementor' ),
						'tab_content' => esc_html__( 'I am item content. Click edit button to change this text.', 'bdevs-elementor' ),
					],
					[
						'tab_title'   => esc_html__( 'Analysis #1', 'bdevs-elementor' ),
						'tab_content' => esc_html__( 'I am item content. Click edit button to change this text.', 'bdevs-elementor' ),
					]
				],
				'fields' => [					
					[
						'name'        => 'tab_number',
						'label'       => esc_html__( 'Number', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( '2500' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'tab_title',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Its Title' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'       => 'tab_content',
						'label'      => esc_html__( 'Content', 'bdevs-elementor' ),
						'type'       => Controls_Manager::WYSIWYG,
						'dynamic'    => [ 'active' => true ],
						'default'    => esc_html__( 'Its Content', 'bdevs-elementor' ),
						'show_label' => true,
					],					
					[
						'name'    => 'tab_image',
						'label'   => esc_html__( 'Image', 'bdevs-elementor' ),
						'type' => \Elementor\Controls_Manager::MEDIA,
						'default' => [
							'url' => \Elementor\Utils::get_placeholder_image_src(),
						],
						'dynamic' => [ 'active' => true ],
					],
				],
			]
		);

		$this->end_controls_section();

        $this->start_controls_section(
			'section_experience',
			[
				'label' => esc_html__( 'Experience', 'advkt-elementor' ),
			]
		);

		$this->add_control(
			'ex_heading',
			[
				'label'       => __( 'Heading', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'advkt-elementor' ),
				'default'     => __( 'It is Heading', 'advkt-elementor' ),
				'label_block' => true
			]
		);

		$this->add_control(
			'ex_number',
			[
				'label'       => __( 'Number', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your number', 'advkt-elementor' ),
				'default'     => __( '10', 'advkt-elementor' ),
				'label_block' => true
			]
		);

        $this->add_control(
			'ex_shape',
			[
				'label'   => esc_html__( 'Shape', 'advkt-elementor' ),
				'description' => esc_html__( 'Add Video Preview Image From Here', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'dynamic' => [ 'active' => true ],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'advkt-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'advkt-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->add_control(
			'show_heading_section',
			[
				'label'   => esc_html__( 'Show Heading Section', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	

		$this->add_control(
			'show_sub_heading',
			[
				'label'   => esc_html__( 'Show Sub Heading', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [
					'show_heading_section' => 'yes'
				],
			]
		);	

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [
					'show_heading_section' => 'yes'
				],
			]
		);	

		$this->add_control(
			'show_desc',
			[
				'label'   => esc_html__( 'Show Description', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

		/** typography **/
		$this->start_controls_section(
			'feature_style',
			[
				'label' => esc_html__( 'Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
            'faq_sub_heading_color',
            [
                'label' => __( 'Sub Heading Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .faq-area .section-title .short-title' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'faq_sub_heading_size',
			[
				'label' => __( 'Sub Heading Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .faq-area .section-title .short-title' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'faq_sub_heading_line_height',
			[
				'label' => __( 'Sub Heading Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .faq-area .section-title .short-title' => 'line-height: {{SIZE}};',
				],
			]
		);

		$this->add_control(
			'divider-10124654',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
            'faq_heading_font_color',
            [
                'label' => __( 'Heading Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .faq-area .section-title .title' => 'color: {{VALUE}} !important;',
                ]
            ]
        );
		$this->add_control(
            'faq_heading_highlight_font_color',
            [
                'label' => __( 'Heading Highlight Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .faq-area .section-title .title span' => 'color: {{VALUE}} !important;',
                ]
            ]
        );

		$this->add_control(
			'faq_heading_font_size',
			[
				'label' => __( 'Heading Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .faq-area .section-title .title' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'faq_heading_line_height',
			[
				'label' => __( 'Heading Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .faq-area .section-title .title' => 'line-height: {{SIZE}};',
				],
			]
		);

		$this->add_control(
			'divider-11124654',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
            'faq_des_font_color',
            [
                'label' => __( 'Description Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .faq-area .section-title .text' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'faq_des_font_size',
			[
				'label' => __( 'Description Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .faq-area .section-title .text' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'faq_des_line_height',
			[
				'label' => __( 'Description Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .faq-area .section-title .text' => 'line-height: {{SIZE}};',
				],
			]
		);
		$this->add_control(
			'divider-1222444654',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
            'faq_tab_title_font_color',
            [
                'label' => __( 'Tab Title Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .faq-area nav ul li' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
            'faq_tab_title_active_font_color',
            [
                'label' => __( 'Tab Active Title Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .faq-area nav ul li.active' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'faq_tab_title_font_size',
			[
				'label' => __( 'Tab Title Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .faq-area nav ul li' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'faq_tab_title_line_height',
			[
				'label' => __( 'Tab Title Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .faq-area nav ul li' => 'line-height: {{SIZE}};',
				],
			]
		);

		$this->add_control(
			'divider-12224654',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
            'faq_tab_des_font_color',
            [
                'label' => __( 'Tab Description Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .faq-area .tab-content .tab-pane p' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'faq_tab_des_font_size',
			[
				'label' => __( 'Tab Description Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .faq-area .tab-content .tab-pane p' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'faq_tab_des_line_height',
			[
				'label' => __( 'Tab Description Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .faq-area .tab-content .tab-pane p' => 'line-height: {{SIZE}};',
				],
			]
		);
		$this->end_controls_section();
	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract( $settings );

	

		$sentence = wp_kses_post( preg_replace('/[^a-zA-Z0-9_ -]/s',' ',$heading) );
		$sentence .= 'faq-';
		$faq_id = str_replace(' ', '', strtolower($sentence));
		$faq_id .= mt_rand();
		?>
            <!-- Call To Action Area Start !-->
    <div class="cta-area">
        <div class="overlay"></div>
        <div class="container">
            <div class="row g-0">
                <div class="col-xxl-6 col-xl-8 col-lg-10">
                    <div class="section-title mb-0">
                        <div class="sec-content">
                            <?php 
                            if (( '' !== $heading ) && ( $show_heading )) : ?>
                                <h2 class="title text-white"><?php echo wp_kses_post( $heading ); ?></h2>
                            <?php 
                            endif; ?>

                            <?php 
                            if (( '' !== $desc ) && ( $show_desc )) : ?>
                                <div class="sec-desc text-white">
                                    <p><?php echo wp_kses_post( $desc ); ?></p>
                                </div>
                            <?php 
                            endif; ?>
                        </div>
                    </div>
                    <div class="icon-card-wrapper">

                            <?php 
							foreach ( $settings['analysis_tabs'] as  $key => $item ) : 
								?>
                                <div class="icon-card style-1">
                                    <div class="icon">
                                        <?php
                                        if ( '' !== $item['tab_image'] )  : 
                                            $image_src = wp_get_attachment_image_src( $item['tab_image']['id'], 'full' );
                                            $image = $image_src ? $image_src[0] : ''; 
                                            ?>
                                            <img src="<?php print esc_url($image); ?>" alt="">
                                        <?php 
                                        endif; ?>
                                        
                                        <?php 
                                        if ( '' !== $item['tab_number'] ) : ?>
                                            <span><?php echo esc_html( $item['tab_number'] ); ?></span>
                                        <?php
                                        endif; ?>
                                    </div>
                                    <div class="content">
                                        <?php 
                                        if ( '' !== $item['tab_title'] ) : ?>
                                            <h3 class="title"><?php echo esc_html( $item['tab_title'] ); ?></h3>
                                        <?php
                                        endif; ?>

                                        <?php 
                                        if ( '' !== $item['tab_content'] ) : ?>
                                            <p class="desc"><?php echo $this->parse_text_editor( $item['tab_content']); ?></p>
                                        <?php 
                                        endif; ?>
                                    </div>
                                </div>

							<?php
							endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="counter-area">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="counter-card">
                            <?php 
                            if ( '' !== $settings['ex_shape']['url'] )  : 
                                $thumbnail_small_image_src = wp_get_attachment_image_src( $settings['ex_shape']['id'], 'full' );
                                $thumbnail_small_image_url = $thumbnail_small_image_src ? $thumbnail_small_image_src[0] : ''; 
                                ?>
                                <div class="counter-shape">
                                    <img src="<?php echo esc_url($thumbnail_small_image_url); ?>" alt="image">
                                </div>
                            <?php 
                            endif; ?>

                            <h2 class="number">
                                <span class="counter"><?php echo esc_html( $ex_number ); ?></span><span>+</span>
                            </h2>

                            <h3 class="title"><?php echo $ex_heading; ?></h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Call To Action Area End !-->

 
               
	<?php
	}
}