<?php
namespace AdvktElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Advkt Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class AdvktBlogPost extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Advkt Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'advkt-blog-post';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Advkt Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'AT Latest Blog', 'advkt-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Advkt Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-posts-group';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Advkt Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'advkt-elementor' ];
	}

	public function get_keywords() {
		return [ 'blog-post' ];
	}

	public function get_script_depends() {
		return [ 'advkt-elementor'];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content_service_post',
			[
				'label' => esc_html__( 'Blog Post', 'advkt-elementor' ),
			]
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Chose Style', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'blog-style-1'  => esc_html__( 'Latest Blog Style 1', 'advkt-elementor' ),
					'blog-style-2' => esc_html__( 'Latest Blog Style 2', 'advkt-elementor' ),
					'blog-style-3' => esc_html__( 'Latest Blog Style 3', 'advkt-elementor' ),
				],
				'default'   => 'blog-style-1',
			]
		);

		$this->add_control(
			'heading_word_count',
			[
				'label'       => __( 'Heading Word Count', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Heading Words Number', 'advkt-elementor' ),
				'default'   => 7,				
			]
		);

		$this->add_control(
			'content_word_count',
			[
				'label'       => __( 'Content Word Count', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Heading Words Number', 'advkt-elementor' ),
				'default'   => 15,				
			]
		);

		$this->add_control(
			'post_number',
			[
				'label'     => esc_html__( 'Post Count', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'1'  => esc_html__( '1', 'advkt-elementor' ),
					'2'  => esc_html__( '2', 'advkt-elementor' ),
					'3'  => esc_html__( '3', 'advkt-elementor' ),
					'4'  => esc_html__( '4', 'advkt-elementor' ),
					'5'  => esc_html__( '5', 'advkt-elementor' ),
					'6' => esc_html__( '6', 'advkt-elementor' ),
					'7' => esc_html__( '7', 'advkt-elementor' ),
					'8' => esc_html__( '8', 'advkt-elementor' ),
					'9' => esc_html__( '9', 'advkt-elementor' ),
					'10' => esc_html__( '10', 'advkt-elementor' ),
					'-1' => esc_html__( 'Show All', 'advkt-elementor' ),
				],
				'default'   => '3',
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'ID'  => esc_html__( 'Post ID', 'advkt-elementor' ),
					'title'  => esc_html__( 'Title', 'advkt-elementor' ),
					'date' => esc_html__( 'Date', 'advkt-elementor' ),
					'modified' => esc_html__( 'Last Modified Date', 'advkt-elementor' ),
					'rand' => esc_html__( 'Random Order', 'advkt-elementor' ),
					'comment_count' => esc_html__( 'Popular Post', 'advkt-elementor' ),
				],
				'default'   => 'ID',
			]
		);

		$this->add_control(
			'order',
			[
				'label'     => esc_html__( 'Post Order', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'asc'  => esc_html__( 'ASC', 'advkt-elementor' ),
					'desc' => esc_html__( 'DESC', 'advkt-elementor' ),
				],
				'default'   => 'desc',
			]
		);		

		$this->add_control(
			'number',
			[
				'label'     => esc_html__( 'Post Count', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'1'  => esc_html__( '1', 'advkt-elementor' ),
					'2'  => esc_html__( '2', 'advkt-elementor' ),
					'3'  => esc_html__( '3', 'advkt-elementor' ),
					'4'  => esc_html__( '4', 'advkt-elementor' ),
					'5'  => esc_html__( '5', 'advkt-elementor' ),
					'6' => esc_html__( '6', 'advkt-elementor' ),
					'7' => esc_html__( '7', 'advkt-elementor' ),
					'8' => esc_html__( '8', 'advkt-elementor' ),
					'9' => esc_html__( '9', 'advkt-elementor' ),
					'10' => esc_html__( '10', 'advkt-elementor' ),
					'-1' => esc_html__( 'Show All', 'advkt-elementor' ),
				],
				'default'   => '3',
			]
		);

		$this->add_control(
			'cat',
			[
				'label'       => __( 'Category Slug', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter category slug here...', 'advkt-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'btn_link_text',
			[
				'label'       => esc_html__( 'Link Text', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'read more', 'advkt-elementor' ),
				'placeholder' => esc_html__( 'Link Text', 'advkt-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'btn_link_icon',
			[
				'label'       => esc_html__( 'Link Icon', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'far fa-long-arrow-right', 'advkt-elementor' ),
				'placeholder' => esc_html__( 'Icon Name', 'advkt-elementor' ),
				'label_block' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'advkt-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'advkt-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);


		$this->end_controls_section();


		/** typography **/
		$this->start_controls_section(
			'latest_posts_heading_style',
			[
				'label' => esc_html__( 'Heading Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'chose_style' => ['blog-style-1', 'blog-style-2']
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'latest_posts_content_typography',
				'selector' => '{{WRAPPER}} .latest-posts.style-1 .post-card.style-1 .content h3',
			]
		);

		$this->add_control(
            'blog_post_heading_color',
            [
                'label' => __( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .latest-posts.style-1 .post-card.style-1 .content h3' => 'color: {{VALUE}};',
                ]
            ]
        );


		$this->end_controls_section();




		/** Date typography **/
		$this->start_controls_section(
			'latest_posts_date_style',
			[
				'label' => esc_html__( 'Date Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'latest_posts_date_typography',
				'selector' => '{{WRAPPER}} .post-card.style-1 .post-meta .single-post-meta .date',
			]
		);

		$this->add_control(
            'blog_post_date_color',
            [
                'label' => __( 'Text Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .post-card.style-1 .post-meta .single-post-meta .date' => 'color: {{VALUE}};',
                ]
            ]
        );




		$this->add_control(
            'blog_post_date_icon_color',
            [
                'label' => __( 'Icon Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .post-card.style-1 .post-meta .single-post-meta .calendar' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'blog_post_date_background',
				'types' => [ 'classic', 'gradient'],
				'selector' => '{{WRAPPER}} .post-card.style-1 .post-meta .single-post-meta .calendar',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'blog_post_date_icon_border_style',
				'selector' => '{{WRAPPER}} .post-card.style-1 .post-meta .single-post-meta .calendar',
			]
		);


		$this->end_controls_section();


		/** Author typography **/
		$this->start_controls_section(
			'latest_posts_author_style',
			[
				'label' => esc_html__( 'Author Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
            'latest_posts_author_color',
            [
                'label' => __( 'Name Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .post-card.style-1 .post-meta .single-post-meta .name' => 'color: {{VALUE}};',
                ]
            ]
        );


		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'latest_posts_author_typography',
				'selector' => '{{WRAPPER}} .post-card.style-1 .post-meta .single-post-meta .name',
			]
		);

		$this->add_control(
            'latest_posts_author_icon_color',
            [
                'label' => __( 'Icon Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .post-card.style-1 .post-meta .single-post-meta .user' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'latest_posts_author_bg_color',
				'types' => [ 'classic', 'gradient'],
				'selector' => '{{WRAPPER}} .post-card.style-1 .post-meta .single-post-meta .user',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'latest_posts_author_icon_border_style',
				'selector' => '{{WRAPPER}} .post-card.style-1 .post-meta .single-post-meta .user',
			]
		);





		$this->end_controls_section();


		
		/** Link Icon typography **/
		$this->start_controls_section(
			'latest_posts_link_icon_style',
			[
				'label' => esc_html__( 'Link Icon Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs(
			'latest_posts_link_style_tabs'
		);

		$this->start_controls_tab(
			'latest_posts_link_style_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'textdomain' ),
			]
		);

		$this->add_control(
            'latest_posts_link_icon_color',
            [
                'label' => __( 'Icon Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .post-card .image .btn-link' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'latest_posts_link_background',
				'types' => [ 'classic', 'gradient'],
				'selector' => '{{WRAPPER}} .post-card .image .btn-link',
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'latest_posts_link_icon_border_style',
				'selector' => '{{WRAPPER}} .post-card .image .btn-link',
			]
		);
		$this->end_controls_tab();


		$this->start_controls_tab(
			'style_hover_tab',
			[
				'label' => esc_html__( 'Hover', 'textdomain' ),
			]
		);

		$this->add_control(
            'latest_posts_link_hover_icon_color',
            [
                'label' => __( 'Icon Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .post-card .image .btn-link:hover' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'latest_posts_link_hover_background',
				'types' => [ 'classic', 'gradient'],
				'selector' => '{{WRAPPER}} .post-card .image .btn-link:hover',
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'latest_posts_link_hover_icon_border_style',
				'selector' => '{{WRAPPER}} .post-card .image .btn-link:hover',
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display(); 
		extract($settings);

	    $cat = get_term_by('slug', $cat, 'category');
	    if( !empty($cat->term_id) ){
	        $term_id = $cat->term_id;
	    }else{
	        $term_id = 1;
	    }

		// .latest-posts.style-1 .post-card.style-1 .content h3
		if( $chose_style == 'blog-style-1' ): ?>

			<div class="latest-posts style-1">
				<div class="container">
					
					<div class="row gy-5">
						<?php 
						$q = new \WP_Query(array(
							'post_type'     => 'post',
							'posts_per_page'=> $post_number,
							'cat'			=> $term_id,
							'orderby'       => 'menu_order '.$orderby,
							'order'         => $order,
							'tax_query' => array(
								array(
									'taxonomy' => 'post_format',
									'field'    => 'slug',
									'terms' => array( 
										'post-format-image', 
									),
									'operator' => 'IN',
								),
							),
						));

						if($q->have_posts()):
							while($q->have_posts()): $q->the_post(); 
							$featured_post_img = get_post_meta( get_the_ID(), 'featured_blog_image', true );
							?>

							<!-- Single Latest Post Start -->
							<div class="col-lg-4 col-md-6 latest-post-card-wrapper">
								<div class="post-card style-1">
								<?php
								if( $featured_post_img !== "" ): ?>

									<div class="image">
										<img src="<?php echo esc_url($featured_post_img); ?>" alt="post-1">
										<a href="<?php the_permalink(); ?>" class="btn-link">
											<i class="fa-regular fa-arrow-right"></i>
										</a>
									</div>
								<?php
								else: ?>
									<div class="image">
										<img src="<?php the_post_thumbnail_url('advkt-featured-post-full'); ?>" alt="post-1">
										<a href="<?php the_permalink(); ?>" class="btn-link">
											<i class="fa-regular fa-arrow-right"></i>
										</a>
									</div>
								<?php
								endif; ?>

									<div class="content">
										<div class="post-meta">
											<span class="single-post-meta">
											<?php //echo dynamic_date_with_link('fa-light fa-calendar-days'); ?>
												<span class="icon calendar">
												<i class="fa-light fa-calendar-days"></i>
												</span>
												<span class="date"><?php the_time(get_option('date_format')); ?></span> 
											</span>
											<span class="single-post-meta">
												<a href="<?php print esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) ?>">
													<span class="icon user">
													<i class="fa-regular fa-user"></i>
													</span>
													<span class="name"><?php print get_the_author(); ?></span>
												</a>
											</span>
										</div>
										<h3 class="title">
											<a href="<?php the_permalink(); ?>"><?php print wp_trim_words(get_the_title(), $heading_word_count, ''); ?></a>
										</h3>
									</div>
								</div>
							</div>
							<!-- Single Latest Post End -->
								<?php 
							endwhile; 
							wp_reset_postdata(); 
						endif; 
						?> 
					</div>
				</div>
			</div>

		<?php 
		elseif ($chose_style == 'blog-style-2') : ?>

			<div class="latest-posts-area style-2">
				<div class="container">
					<div class="row">
						<div class="col-12">
							<div class="section-title">
								<div class="sec-content">
									<h2 class="title">Our Latest News</h2>
									<div class="sec-desc text-black-color">
										<p>Law firms are typically structured with partners, associates, and support staff. <br/> Partners are senior attorneys. </p>
									</div>
								</div>
								<div class="sec-desc">
									<a href="#" class="theme-btn">All blog posts<i class="fa-light fa-arrow-right-long"></i></a>
								</div>
							</div>
						</div>
					</div>
					<div class="row gy-5">



						<?php 
						$q = new \WP_Query(array(
							'post_type'     => 'post',
							'posts_per_page'=> $post_number,
							'cat'			=> $term_id,
							'orderby'       => 'menu_order '.$orderby,
							'order'         => $order,
							'tax_query' => array(
								array(
									'taxonomy' => 'post_format',
									'field'    => 'slug',
									'terms' => array( 
										'post-format-image', 
									),
									'operator' => 'IN',
								),
							),
						));

						if($q->have_posts()):
							while($q->have_posts()): $q->the_post(); 
							$featured_post_img = get_post_meta( get_the_ID(), 'featured_blog_image', true );
							?>
							

							<!-- Single Latest Post Start -->
							<div class="col-lg-4 col-md-6 latest-post-card-wrapper">
								<div class="post-card style-1">

									<?php
									if( $featured_post_img !== "" ): ?>

										<div class="image">
											<img src="<?php echo esc_url($featured_post_img); ?>" alt="post-1">
											<a href="<?php the_permalink(); ?>" class="btn-link">
												<i class="fa-regular fa-arrow-right"></i>
											</a>
										</div>
									<?php
									else: ?>
										<div class="image">
											<img src="<?php the_post_thumbnail_url('advkt-featured-post-full'); ?>" alt="post-1">
											<a href="<?php the_permalink(); ?>" class="btn-link">
												<i class="fa-regular fa-arrow-right"></i>
											</a>
										</div>
									<?php
									endif; ?>


									<div class="content">
										<div class="post-meta">
											<span class="single-post-meta">
												<span class="icon calendar">
													<i class="fa-regular fa-calendar-days"></i>
												</span>
												<span class="date"><?php the_time(get_option('date_format')); ?></span>
											</span>
											<span class="single-post-meta">
												<a href="<?php print esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) ?>">
													<span class="icon user">
													<i class="fa-regular fa-user"></i>
													</span>
													<span class="user"><?php print get_the_author(); ?></span>
												</a>
											</span>
										</div>
										<h3 class="title">
											<a href="<?php the_permalink(); ?>"><?php print wp_trim_words(get_the_title(), $heading_word_count, ''); ?></a>
										</h3>
									</div>
								</div>
							</div>
							<!-- Single Latest Post End -->

							<?php 
							endwhile; 
							wp_reset_postdata(); 
						endif; 
						?> 

					</div>
				</div>
			</div>
		<?php 
		endif; ?>
	<?php
	}
}