<?php
namespace AdvktElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Advkt Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class AdvktBanner extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Advkt Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'advkt-banner';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Advkt Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'AT Banner', 'advkt-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Boomdevs Banner widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-slideshow';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Boomdevs Banner widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'advkt-elementor' ];
	}

	public function get_keywords() {
		return [ 'banner', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'advkt-elementor'];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content_banner',
			[
				'label' => esc_html__( 'Banner', 'advkt-elementor' ),
			]
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Chose Style', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'banner-style-1'  => esc_html__( 'Banner Style 1', 'advkt-elementor' ),
					'banner-style-2' => esc_html__( 'Banner Style 2', 'advkt-elementor' ),
				],
				'default'   => 'banner-style-1',
			]
		);

		$this->add_control(
			'banner_sub_title',
			[
				'label'       => esc_html__( 'Sub Title', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => esc_html__( 'WELCOME TO ADVKT', 'advkt-elementor' ),
				'placeholder' => esc_html__( 'Sub Title Text', 'advkt-elementor' ),
				'label_block' => true,
				'condition' => [
					'chose_style' => ['banner-style-1']
				],
			]
		);	

		$this->add_control(
			'banner_sub_title_img',
			[
				'label'   => esc_html__( 'Sub Title Shape Image', 'advkt-elementor' ),
				'description' => esc_html__( 'Add Video Preview Image From Here', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'dynamic' => [ 'active' => true ],
				'condition' => [
					'chose_style' => ['banner-style-1']
				],
			]
		);

		$this->add_control(
			'banner_title_img',
			[
				'label'   => esc_html__( 'Title Shape Image', 'advkt-elementor' ),
				'description' => esc_html__( 'Add Title Image From Here', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'dynamic' => [ 'active' => true ],
				'condition' => [
					'chose_style' => ['banner-style-2']
				],
			]
		);


		$this->add_control(
			'banner_title',
			[
				'label'       => esc_html__( 'Title', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => esc_html__( '', 'advkt-elementor' ),
				'placeholder' => esc_html__( 'It is a title', 'advkt-elementor' ),
				'label_block' => true
			]
		);	

		$this->add_control(
			'banner_desc',
			[
				'label'       => esc_html__( 'Description', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => esc_html__( '', 'advkt-elementor' ),
				'placeholder' => esc_html__( 'It is a content', 'advkt-elementor' ),
				'label_block' => true,
				'condition' => [
					'chose_style' => ['banner-style-2']
				],
			]
		);	

		$this->end_controls_section();


		$this->start_controls_section(
			'section_content_images',
			[
				'label' => esc_html__( 'Images', 'advkt-elementor' ),
			]
		);	

		$this->add_control(
			'banner_thumbnail',
			[
				'label'   => esc_html__( 'Thumbnail', 'advkt-elementor' ),
				'description' => esc_html__( 'Add Thumbnail Image From Here', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'dynamic' => [ 'active' => true ],
			]
		);

		$this->add_control(
			'banner_bg',
			[
				'label'   => esc_html__( 'Background Image', 'advkt-elementor' ),
				'description' => esc_html__( 'Add Background Image From Here', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'dynamic' => [ 'active' => true ],
				'condition' => [
					'chose_style' => ['banner-style-1', 'banner-style-2']
				],
			]
		);

		$this->add_control(
			'banner_signature',
			[
				'label'   => esc_html__( 'Signature Image', 'advkt-elementor' ),
				'description' => esc_html__( 'Add Signature Image From Here', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'dynamic' => [ 'active' => true ],
				'condition' => [
					'chose_style' => ['banner-style-2']
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_link',
			[
				'label' => esc_html__( 'Link', 'advkt-elementor' ),
				'condition' => [
					'chose_style' => ['banner-style-1']
				],
			]
		);

		$this->add_control(
			'slider_link_text',
			[
				'label'       => __( 'Link Text', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Link Text Here...', 'advkt-elementor' ),
				'default'     => __( 'Learn More', 'advkt-elementor' ),
				'label_block' => true
			]
		);

		$this->add_control(
			'slider_link',
			[
				'label' => __( 'Link', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'advkt-elementor' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);	

		$this->end_controls_section();


		$this->start_controls_section(
			'section_content_brands',
			[
				'label' => esc_html__( 'Brands', 'advkt-elementor' ),
				'condition' => [
					'chose_style' => ['banner-style-1']
				],
			]
		);	
		
		$this->add_control(
			'brand_title',
			[
				'label'       => __( 'Brand Title', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Title Here...', 'advkt-elementor' ),
				'default'     => __( 'It is a brand title', 'advkt-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'brand_desc',
			[
				'label'       => __( 'Brand Description', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Type Description Here...', 'advkt-elementor' ),
				'default'     => __( 'It is a content', 'advkt-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Brand Items', 'advkt-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'tab_icon'   => esc_html__( 'Brand #1', 'advkt-elementor' ),
					],
				],
				'fields' => [	
					[
						'name'    => 'tab_icon',
						'label'   => esc_html__( 'Brand Image', 'advkt-elementor' ),
						'type' => \Elementor\Controls_Manager::MEDIA,
						'default' => [
							'url' => \Elementor\Utils::get_placeholder_image_src(),
						],
						'dynamic' => [ 'active' => true ],
					]
				],
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_content_clients',
			[
				'label' => esc_html__( 'Clients', 'advkt-elementor' ),
				'condition' => [
					'chose_style' => ['banner-style-2']
				],
			]
		);	
		
		$this->add_control(
			'client_title',
			[
				'label'       => __( 'Client Title', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Title Here...', 'advkt-elementor' ),
				'default'     => __( 'It is a client title', 'advkt-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'client_number',
			[
				'label'       => __( 'Number', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Description Here...', 'advkt-elementor' ),
				'default'     => __( 'It is a content', 'advkt-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'clients',
			[
				'label' => esc_html__( 'Client Items', 'advkt-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'tab_image'   => esc_html__( 'Client #1', 'advkt-elementor' ),
					],
				],
				'fields' => [	
					[
						'name'    => 'tab_image',
						'label'   => esc_html__( 'Client Image', 'advkt-elementor' ),
						'type' => \Elementor\Controls_Manager::MEDIA,
						'default' => [
							'url' => \Elementor\Utils::get_placeholder_image_src(),
						],
						'dynamic' => [ 'active' => true ],
					]
				],
			]
		);

		$this->end_controls_section();



		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'advkt-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'advkt-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'advkt-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'advkt-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'advkt-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'advkt-elementor' ),
						'icon' => 'eicon-text-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
			]
		);
		$this->add_control(
			'show_sub_title',
			[
				'label'   => esc_html__( 'Show Sub Title', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_title',
			[
				'label'   => esc_html__( 'Show Title', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);		
		$this->add_control(
			'show_content',
			[
				'label'   => esc_html__( 'Show content', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_social_profiles',
			[
				'label'   => esc_html__( 'Show Social Profiles', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

		/** subtitle typography **/
		$this->start_controls_section(
			'banner_subtitle_style',
			[
				'label' => esc_html__( 'Sub Title Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'chose_style' => ['banner-style-1']
				],
			]
		);

		$this->add_control(
			'banner_sub_title_color',
			[
				'label' => esc_html__( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .el-slider-content .el-sub-title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'banner_sub_title_typography',
				'selector' => '{{WRAPPER}} .el-slider-content .el-sub-title',
			]
		);

		$this->end_controls_section();



		/** title typography **/
		$this->start_controls_section(
			'banner_title_style',
			[
				'label' => esc_html__( 'Title Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'banner_title_color',
			[
				'label' => esc_html__( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .el-slider-content .el-title' => 'color: {{VALUE}} !important',
				],
				'condition' => [
					'chose_style' => ['banner-style-1']
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'banner_title_typography',
				'selector' => '{{WRAPPER}} .el-slider-content .el-title',
				'condition' => [
					'chose_style' => ['banner-style-1']
				],
			]
		);


		$this->add_control(
			'banner_style_2_title_color',
			[
				'label' => esc_html__( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .slider-area.style-2 .slider-wrapper .single-slider-wrapper .single-slider .slider-content-wrapper .slider-content .slider-title' => 'color: {{VALUE}}',
				],
				'condition' => [
					'chose_style' => ['banner-style-2']
				],
			]
		);


		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'banner_style_2_title_typography',
				'selector' => '{{WRAPPER}} .slider-area.style-2 .slider-wrapper .single-slider-wrapper .single-slider .slider-content-wrapper .slider-content .slider-title',
				'condition' => [
					'chose_style' => ['banner-style-2']
				],
			]
		);
		$this->end_controls_section();



		/** Description typography **/
		$this->start_controls_section(
			'banner_desc_style',
			[
				'label' => esc_html__( 'Description Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'chose_style' => ['banner-style-2']
				],
			]
		);

		$this->add_control(
			'banner_desc_color',
			[
				'label' => esc_html__( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .slider-area.style-2 .slider-wrapper .single-slider-wrapper .single-slider .slider-content-wrapper .slider-content .slider-short-desc' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'banner_desc_typography',
				'selector' => '{{WRAPPER}} .slider-area.style-2 .slider-wrapper .single-slider-wrapper .single-slider .slider-content-wrapper .slider-content .slider-short-desc',
			]
		);


		$this->end_controls_section();

		/** Brand Title typography **/
		$this->start_controls_section(
			'banner_brand_style',
			[
				'label' => esc_html__( 'Brand Title Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'chose_style' => ['banner-style-1']
				],
			]
		);

		$this->add_control(
			'banner_brand_title_color',
			[
				'label' => esc_html__( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .el-brand-content .el-title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'banner_brand_title_typography',
				'selector' => '{{WRAPPER}} .el-brand-content .el-title',
			]
		);

		$this->end_controls_section();

		/** Brand Description typography **/
		$this->start_controls_section(
			'banner_brand_desc_style',
			[
				'label' => esc_html__( 'Brand Description Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'chose_style' => ['banner-style-1']
				],
			]
		);

		$this->add_control(
			'banner_brand_desc_color',
			[
				'label' => esc_html__( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .el-brand-content .el-desc' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'banner_brand_desc_typography',
				'selector' => '{{WRAPPER}} .el-brand-content .el-desc',
			]
		);

		$this->end_controls_section();

		/** Brand Description typography **/
		$this->start_controls_section(
			'client_heading_style',
			[
				'label' => esc_html__( 'Client Heading Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'chose_style' => ['banner-style-2']
				],
			]
		);

		$this->add_control(
			'client_heading_color',
			[
				'label' => esc_html__( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .slider-area .single-slider .slider-image .trusted-user .content .counter-desc p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'client_heading_typography',
				'selector' => '{{WRAPPER}} .slider-area .single-slider .slider-image .trusted-user .content .counter-desc p',
			]
		);

		$this->end_controls_section();



				
/** Start Button **/
$this->start_controls_section(
    'banner_btn_style',
    [
        'label' => esc_html__( 'Button', 'eyewell-elementor'),
        'tab' => Controls_Manager::TAB_STYLE,
        
    ]
);

$this->start_controls_tabs(
    'banner_btn_style_tabs'
);

$this->start_controls_tab(
    'banner_btn_style_normal_tab',
    [
        'label' => esc_html__( 'Normal', 'eyewell-elementor' ),
    ]
);
$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'banner_btn_typography',
        'selector' => '{{WRAPPER}} .el-btn-wrapper .el-theme-btn',
    ]
);

$this->add_responsive_control(
    'banner_btn_text_color',
    [
        'label' => esc_html__( 'Text Color', 'eyewell-elementor' ),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .el-btn-wrapper .el-theme-btn' => 'color: {{VALUE}} !important',
        ],
    ]
);

$this->add_responsive_control(
    'banner_btn_bg_color',
    [
        'label' => esc_html__( 'Background Color', 'eyewell-elementor' ),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .el-btn-wrapper .el-theme-btn' => 'background: {{VALUE}} !important',
        ],
    ]
);

$this->add_responsive_control(
    'banner_btn_margin',
    [
        'label' => esc_html__( 'Margin', 'eyewell-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' => [
            '{{WRAPPER}} .el-btn-wrapper .el-theme-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'banner_btn_padding',
    [
        'label' => esc_html__( 'Padding', 'eyewell-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' => [
            '{{WRAPPER}} .el-btn-wrapper .el-theme-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name' => 'banner_btn_border_border',
        'selector' => '{{WRAPPER}} .el-btn-wrapper .el-theme-btn',
    ]
);

$this->add_responsive_control(
    'banner_btn_border_radius',
    [
        'label' => esc_html__( 'Border Radius', 'eyewell-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' => [
            '{{WRAPPER}} .el-btn-wrapper .el-theme-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->end_controls_tab();

$this->start_controls_tab(
    'banner_btn_style_hover_tab',
    [
        'label' => esc_html__( 'Hover', 'eyewell-elementor' ),
    ]
);

$this->add_responsive_control(
    'banner_btn_hover_color',
    [
        'label' => esc_html__( 'Color', 'eyewell-elementor' ),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .el-btn-wrapper .theme-btn:hover' => 'color: {{VALUE}} !important',
        ],
    ]
);

$this->add_responsive_control(
    'banner_btn_bg_hover_color',
    [
        'label' => esc_html__( 'Background Color', 'eyewell-elementor' ),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .el-btn-wrapper .theme-btn:hover' => 'background: {{VALUE}} !important',
        ],
    ]
);

$this->add_responsive_control(
    'banner_btn_icon_hover_color',
    [
        'label' => esc_html__( 'Icon Color', 'eyewell-elementor' ),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .el-btn-wrapper .theme-btn:hover i' => 'color: {{VALUE}} !important',
        ],
    ]
);

$this->end_controls_tab();
$this->end_controls_tabs();
$this->end_controls_section();
		

	}

	public function render() {

		$settings  = $this->get_settings_for_display();
		extract( $settings );

		$this->add_render_attribute(
			[
				'slider_link' => [
					'href'   => !empty($settings['slider_link']['url']) ? esc_url($settings['slider_link']['url']) : '#',
					'target' => !empty($settings['slider_link']['is_external']) ? '_blank' : '_self'
				]
			], '', '', true
		);

		
		if( $chose_style == 'banner-style-1' ): ?>



	<!-- Slider Section Start !-->
	<div class="slider-area style-1 ">
        <div class="slider-wrapper">
            <!-- single slider start -->
            <div class="single-slider-wrapper">
                <div class="single-slider">
                    <div class="container h-100 align-self-center">
                        <div class="row h-100">

                            <div class="col-lg-2 align-self-center">
                                <div class="slider-feature-image">
									<?php 
									if ( '' !== $settings['banner_thumbnail']['url'] )  : 
										$thumbnail_image_src = wp_get_attachment_image_src( $settings['banner_thumbnail']['id'], 'full' );
										$thumbnail_image_url = $thumbnail_image_src ? $thumbnail_image_src[0] : ''; 
										?>
										<img src="<?php echo esc_url($thumbnail_image_url); ?>" alt="image">
									<?php 
									endif; ?>
                                </div>
                            </div>
							
                            <div class="col-lg-7 align-self-center">
                                <div class="slider-title-wrapper el-slider-content">
                                    <h3 class="slider-sub-title el-sub-title">
										<?php 
										if ( '' !== $settings['banner_sub_title_img']['url'] )  : 
											$banner_sub_title_img_src = wp_get_attachment_image_src( $settings['banner_sub_title_img']['id'], 'full' );
											$banner_sub_title_img_url = $banner_sub_title_img_src ? $banner_sub_title_img_src[0] : ''; 
											?>
											<span class="shape-img">
												<img src="<?php echo esc_url($banner_sub_title_img_url); ?>" alt="image">
											</span>
										<?php 
										endif; ?>
										
                                        <?php echo wp_kses_post( $banner_sub_title ); ?>
                                    </h3>
                                    <h1 class="slider-title el-title"><?php echo wp_kses_post( $banner_title ); ?></h1>

									<?php 
									if (( ! empty( $settings['slider_link']['url'] )) ): ?>
										<div class="btn-wrapper el-btn-wrapper mt-4">
											<a <?php echo $this->get_render_attribute_string( 'slider_link' ); ?> class="theme-btn el-theme-btn text-black"><?php echo esc_html($settings['slider_link_text']); ?></a>
										</div>
									<?php 
									endif; ?>

                                </div>
                            </div>
							 
                            <div class="col-lg-3">
                                <div class="slider-content el-brand-content">
									<?php
									if( '' !== $brand_desc): ?>
                                    	<p class="slider-short-desc el-desc"><?php echo wp_kses_post( $brand_desc ); ?></p>
									<?php
									endif; ?>

                                    <div class="divider-wrapper">
                                        <div class="divider one"></div>
                                        <div class="divider two"></div>
                                        <div class="divider three"></div>
                                        <div class="divider four"></div>
                                    </div>
                                    <div class="company-award">
										<?php
										if( '' !== $brand_title ): ?>
											<h3 class="title el-title"><?php echo wp_kses_post( $brand_title ); ?></h3>
										<?php
										endif; ?>
                                        <div class="award-wrapper">
											<?php 
											foreach ( $settings['tabs'] as $item ) : 
												extract($item);
												?>
												<div class="award-item">
													<?php
													if ( '' !== $tab_icon['id'] )  :  
														$image_src = wp_get_attachment_image_src( $tab_icon['id'], 'full' );
														$image_url = $image_src ? $image_src[0] : '';
													?>                        	
														<img src="<?php print esc_url($image_url); ?>" alt="Brand Logo">
													<?php 
													endif; ?>
												</div>
											<?php
											endforeach;
											?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="slider-image-wrapper">
                                    <div class="slider-image">
										<?php 
										if ( '' !== $settings['banner_bg']['url'] )  : 
											$banner_bg_image_src = wp_get_attachment_image_src( $settings['banner_bg']['id'], 'full' );
											$banner_bg_image_url = $banner_bg_image_src ? $banner_bg_image_src[0] : ''; 
											?>
											<img src="<?php echo esc_url($banner_bg_image_url); ?>" alt="image">
										<?php 
										endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- single slider end -->
        </div>
    </div>
    <!-- Slider Section End !-->


       <?php 
	   elseif( $chose_style == 'banner-style-2' ): ?>

<!-- Slider Section Start !-->
<div class="slider-area style-2 el-slider-content">
    <div class="slider-wrapper">
        <!-- single slider start -->
        <div class="single-slider-wrapper">
			<?php
			if ( '' !== $settings['banner_bg']['url'] )  : 
				$banner_bg_image_src = wp_get_attachment_image_src( $settings['banner_bg']['id'], 'full' );
				$banner_bg_image_url = $banner_bg_image_src ? $banner_bg_image_src[0] : ''; 
				?>
				<div class="single-slider" style="background-image: url(<?php echo esc_url($banner_bg_image_url); ?>)">
			<?php
			else: ?>
				<div class="single-slider">
			<?php 
			endif; ?>

			

                <div class="slider-overlay"></div>
                <div class="container h-100 align-self-center">
                    <div class="row h-100">
                        <div class="col-md-7 align-self-center">
                            <div class="slider-content-wrapper">
                                
								<?php 
								if ( '' !== $settings['banner_title_img']['url'] )  : 
									$banner_title_img_src = wp_get_attachment_image_src( $settings['banner_title_img']['id'], 'full' );
									$banner_title_img_url = $banner_title_img_src ? $banner_title_img_src[0] : ''; 
									?>
									<span class="shape">
										<img src="<?php echo esc_url($banner_title_img_url); ?>" alt="image">
									</span>
								<?php 
								endif; ?>
                                

                                <div class="slider-content">
                                    <h1 class="slider-title el-title"><?php echo wp_kses_post( $banner_title ); ?></h1>
                                    <p class="slider-short-desc el-desc"><?php echo wp_kses_post( $banner_desc ); ?></p>
                                </div>
                                
								
								<?php 
								if ( '' !== $settings['banner_signature']['url'] )  : 
									$banner_signature_img_src = wp_get_attachment_image_src( $settings['banner_signature']['id'], 'full' );
									$banner_signature_img_url = $banner_signature_img_src ? $banner_signature_img_src[0] : ''; 
									?>
								
									<div class="signature-shape">
										<img src="<?php echo esc_url($banner_signature_img_url); ?>" alt="image">
									</div>
									<?php 
								endif; ?>
                                
                            </div>
                        </div>
                        <div class="col-md-5 align-self-center">
                            <div class="slider-image">

								<?php 
								if ( '' !== $settings['banner_thumbnail']['url'] )  : 
									$thumbnail_image_src = wp_get_attachment_image_src( $settings['banner_thumbnail']['id'], 'full' );
									$thumbnail_image_url = $thumbnail_image_src ? $thumbnail_image_src[0] : ''; 
									?>
									<img src="<?php echo esc_url($thumbnail_image_url); ?>" alt="image">
								<?php 
								endif; ?>



                                <div class="animate-move-left-right">
                                    <div class="trusted-user">
                                        <div class="user-list-wrapper">
											<?php 
											foreach ( $settings['clients'] as $item ) : 
												extract($item);
												?>
												<div class="single-user">
													<?php
													if ( '' !== $tab_image['id'] )  :  
														$image_src = wp_get_attachment_image_src( $tab_image['id'], 'full' );
														$image_url = $image_src ? $image_src[0] : '';
													?>                        	
														<img src="<?php print esc_url($image_url); ?>" alt="Brand Logo">
													<?php 
													endif; ?>
												</div>
											<?php
											endforeach;
											?>
                                        </div>
                                        <div class="content">
                                            <div class="counter-desc">
                                                <p>
                                                    <span><?php echo wp_kses_post( $client_number ); ?></span> <br/>
                                                   <?php echo wp_kses_post( $client_title ); ?>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- single slider end -->
    </div>
</div>
<!-- Slider Section End !-->
	
       <?php 
		endif; ?>	
	<?php
	}
}