<?php
namespace AdvktElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Advkt Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class AdvktAboutImages extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Advkt Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'advkt-about-images';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Advkt Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'AT About Images', 'advkt-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Boomdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-post-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Boomdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'advkt-elementor' ];
	}

	public function get_keywords() {
		return [ 'about images' ];
	}

	public function get_script_depends() {
		return [ 'advkt-elementor'];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content_features',
			[
				'label' => esc_html__( 'About', 'advkt-elementor' ),
			]	
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Chose Style', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'about-style-1'  => esc_html__( 'About Style 1', 'advkt-elementor' ),
					'about-style-2'  => esc_html__( 'About Style 2', 'advkt-elementor' ),
					'about-style-3'  => esc_html__( 'About Style 3', 'advkt-elementor' )
				],
				'default'   => 'about-style-1',
			]
		);

		$this->add_control(
			'before_heading',
			[
				'label'       => __( 'Before Heading', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your sub heading', 'advkt-elementor' ),
				'default'     => __( 'It is sub heading', 'advkt-elementor' ),
				'label_block' => true,
			]
		);	
        

		$this->add_control(
			'top_image',
			[
				'label'   => esc_html__( 'Top Image', 'advkt-elementor' ),
				'description' => esc_html__( 'Add Your Shape Image', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'dynamic' => [ 'active' => true ],
			]
		);

		$this->add_control(
			'left_image',
			[
				'label'   => esc_html__( 'Left Image', 'advkt-elementor' ),
				'description' => esc_html__( 'Add Your Shape Image', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'dynamic' => [ 'active' => true ],
			]
		);

		$this->add_control(
			'right_image',
			[
				'label'   => esc_html__( 'Right Image', 'advkt-elementor' ),
				'description' => esc_html__( 'Add Your Shape Image', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'dynamic' => [ 'active' => true ],
			]
		);


		$this->end_controls_section();


		/** 
		*	Link section 
		**/
		$this->start_controls_section(
			'link_section_content',
			[
				'label' => esc_html__( 'Link Info', 'advkt-elementor' ),
				'condition' => [
					'chose_style' => ['about-style-1', 'about-style-2', 'about-style-3']
				],
			]
		);		

		$this->add_control(
			'link_text',
			[
				'label'       => __( 'Link Text', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Link Text Here...', 'advkt-elementor' ),
				'default'     => __( 'Learn More', 'advkt-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'link',
			[
				'label' => __( 'Link', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'advkt-elementor' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
	
		$this->end_controls_section();


	
		/** 
		*	Layout section 
		**/
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'advkt-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'advkt-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		);

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);			

		$this->add_control(
			'show_before_heading',
			[
				'label'   => esc_html__( 'Show Before Heading', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);		

		$this->add_control(
			'show_after_heading',
			[
				'label'   => esc_html__( 'Show After Heading Text', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);		

		$this->add_control(
			'show_quote_text',
			[
				'label'   => esc_html__( 'Show Quote Text', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);		

		$this->add_control(
			'show_content',
			[
				'label'   => esc_html__( 'Show Content', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);		
	

		$this->end_controls_section();

		/** typography **/
		$this->start_controls_section(
			'feature_style',
			[
				'label' => esc_html__( 'Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
            'about_sub_heading_font_color',
            [
                'label' => __( 'Sub Heading Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .about-info-card .section-title .short-title' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'about_sub_heading_font_size',
			[
				'label' => __( 'Sub Heading Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .about-info-card .section-title .short-title' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'about_sub_heading_line_height',
			[
				'label' => __( 'Sub Heading Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .about-info-card .section-title .short-title' => 'line-height: {{SIZE}};',
				],
			]
		);


		$this->add_control(
			'divider-104654',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
            'about_heading_font_color',
            [
                'label' => __( 'Heading Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .about-info-card .section-title .title' => 'color: {{VALUE}};',
                ]
            ]
        );
		$this->add_control(
            'about_heading_font_highlight_color',
            [
                'label' => __( 'Heading Highlight Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .about-info-card .section-title .title span' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'about_heading_font_size',
			[
				'label' => __( 'Heading Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .about-info-card .section-title .title' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'about_heading_line_height',
			[
				'label' => __( 'Heading Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .about-info-card .section-title .title' => 'line-height: {{SIZE}};',
				],
			]
		);

		$this->add_control(
			'divider-5555',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
            'about_heading_tag_font_color',
            [
                'label' => __( 'Heading Bottom Text Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .about-info-card .sub-title p' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'about_heading_tag_font_size',
			[
				'label' => __( 'Heading Bottom Text Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .about-info-card .sub-title p' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'about_heading_tag_line_height',
			[
				'label' => __( 'Heading Bottom Text Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .about-info-card .sub-title p' => 'line-height: {{SIZE}};',
				],
			]
		);

		$this->add_control(
			'divider-6598214',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
            'about_desc_font_color',
            [
                'label' => __( 'Description Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .about-info-card .text p.desc' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'about_desc_font_size',
			[
				'label' => __( 'Description Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .about-info-card .text p.desc' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'about_desc_line_height',
			[
				'label' => __( 'Description Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .about-info-card .text p.desc' => 'line-height: {{SIZE}};',
				],
			]
		);

		$this->add_control(
			'divider-656598214',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
            'about_quote_font_color',
            [
                'label' => __( 'Author Quote Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .about-info-card .quote-text p' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'about_quote_font_size',
			[
				'label' => __( 'Author Quote Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .about-info-card .quote-text p' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'about_quote_line_height',
			[
				'label' => __( 'Author Quote Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .about-info-card .quote-text p' => 'line-height: {{SIZE}};',
				],
			]
		);

		$this->add_control(
			'divider-65656598214',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
            'about_quote_name__font_color',
            [
                'label' => __( 'Author name Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .about-info-card .quote-text .quote-text-meta .name' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'about_quote_name_font_size',
			[
				'label' => __( 'Author name Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .about-info-card .quote-text .quote-text-meta .name' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'about_quote_name_line_height',
			[
				'label' => __( 'Author name Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .about-info-card .quote-text .quote-text-meta .name' => 'line-height: {{SIZE}};',
				],
			]
		);

		$this->add_control(
			'divider-6655982141',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
            'about_quote_designation_font_color',
            [
                'label' => __( 'Designation Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .about-info-card .quote-text .quote-text-meta .designation' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'about_quote_designation_font_size',
			[
				'label' => __( 'Designation Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .about-info-card .quote-text .quote-text-meta .designation' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'about_quote_designation_line_height',
			[
				'label' => __( 'Designation Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .about-info-card .quote-text .quote-text-meta .designation' => 'line-height: {{SIZE}};',
				],
			]
		);

		$this->add_control(
			'divider-6565698214',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
            'about_read_more_font_color',
            [
                'label' => __( 'Button Font Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .about-info-card .btn-wrapper a.theme-btn' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'about_read_more_font_size',
			[
				'label' => __( 'Button Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .about-info-card .btn-wrapper a.theme-btn' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'about_read_more_line_height',
			[
				'label' => __( 'Button Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .about-info-card .btn-wrapper a.theme-btn' => 'line-height: {{SIZE}};',
				],
			]
		);

		$this->add_control(
			'divider-65656198214',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
            'about_icon_card_title_color',
            [
                'label' => __( 'Icon Card Title Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .about-info-content .icon-card-wrapper .icon-card .content .title' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'about_icon_card_title_size',
			[
				'label' => __( 'Icon Card Title Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .about-info-content .icon-card-wrapper .icon-card .content .title' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'about_icon_card_title_line_height',
			[
				'label' => __( 'Icon Card Title Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .about-info-content .icon-card-wrapper .icon-card .content .title' => 'line-height: {{SIZE}};',
				],
			]
		);

		$this->add_control(
			'divider-656156198214',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
            'about_icon_card_des_color',
            [
                'label' => __( 'Icon Card Description Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .about-info-content .icon-card-wrapper .icon-card .content .desc' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'about_icon_card_des_size',
			[
				'label' => __( 'Icon Card Description Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .about-info-content .icon-card-wrapper .icon-card .content .desc' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'about_icon_card_des_line_height',
			[
				'label' => __( 'Icon Card Description Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .about-info-content .icon-card-wrapper .icon-card .content .desc' => 'line-height: {{SIZE}};',
				],
			]
		);

		$this->add_control(
			'divider-65612356198214',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
            'about_progressbar_text_color',
            [
                'label' => __( 'Progressbar Text Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .about-info-content .skill-progressbar-wrapper .skill-title' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'about_progressbar_text_size',
			[
				'label' => __( 'Progressbar Text Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .about-info-content .skill-progressbar-wrapper .skill-title' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'about_progressbar_text_line_height',
			[
				'label' => __( 'Progressbar Text Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .about-info-content .skill-progressbar-wrapper .skill-title' => 'line-height: {{SIZE}};',
				],
			]
		);

		$this->add_control(
			'divider-61561235126198214',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
            'about_promotional_phone_color',
            [
                'label' => __( 'Phone Font Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .promotional-bananer-content .content .text a' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'about_promotional_phone_size',
			[
				'label' => __( 'Phone Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .promotional-bananer-content .content .text a' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'about_promotional_phone_line_height',
			[
				'label' => __( 'Phone Font Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .promotional-bananer-content .content .text a' => 'line-height: {{SIZE}};',
				],
			]
		);

		$this->add_control(
			'divider-61561275126198214',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
            'about_promotional_phone_info_color',
            [
                'label' => __( 'Phone Info Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .promotional-bananer-content .content span' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'about_promotional_phone_info_size',
			[
				'label' => __( 'Phone Info Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .promotional-bananer-content .content span' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'about_promotional_phone_info_line_height',
			[
				'label' => __( 'Phone Info Line Height', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .promotional-bananer-content .content span' => 'line-height: {{SIZE}};',
				],
			]
		);

		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract($settings);

		$this->add_render_attribute(
			[
				'link' => [
					'href'   => !empty($settings['link']['url']) ? esc_url($settings['link']['url']) : '#',
					'target' => !empty($settings['link']['is_external']) ? '_blank' : '_self'
				]
			], '', '', true
		);



		if( $chose_style == 'about-style-1' ): ?>


            <div class="about-image-card">
                <div class="main-img-wrapper">
                    <div class="main-img-inner">
                        <?php 
                        if ( '' !== $settings['top_image']['url'] )  : 
                            $thumbnail_top_image_src = wp_get_attachment_image_src( $settings['top_image']['id'], 'full' );
                            $thumbnail_top_image_url = $thumbnail_top_image_src ? $thumbnail_top_image_src[0] : ''; 
                            ?>
                            <img class="tilt-animate" src="<?php echo esc_url($thumbnail_top_image_url); ?>" alt="about top img">
                        <?php 
                        endif; ?>

                        <div class="image-shape">
                            <?php 
                            if ( '' !== $settings['right_image']['url'] )  : 
                                $thumbnail_right_image_src = wp_get_attachment_image_src( $settings['right_image']['id'], 'full' );
                                $thumbnail_right_image_url = $thumbnail_right_image_src ? $thumbnail_right_image_src[0] : ''; 
                                ?>
                                <img class="tilt-animate" src="<?php echo esc_url($thumbnail_right_image_url); ?>" alt="about left img">
                            <?php 
                            endif; ?>
                        </div>

                        <div class="image-two">
                            <?php 
                            if ( '' !== $settings['left_image']['url'] )  : 
                                $thumbnail_left_image_src = wp_get_attachment_image_src( $settings['left_image']['id'], 'full' );
                                $thumbnail_left_image_url = $thumbnail_left_image_src ? $thumbnail_left_image_src[0] : ''; 
                                ?>
                                <img class="tilt-animate" src="<?php echo esc_url($thumbnail_left_image_url); ?>" alt="about left img">
                            <?php 
                            endif; ?>
                        </div>
                    </div>
                </div>
            </div>



		<?php 
		elseif( $chose_style == 'about-style-2' ): ?>
		

		<?php 
		endif; ?>	
	<?php
	}
}